/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.logging.XMLLoggerParser;
import com.kms.katalon.core.logging.XMLParserException;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.JUnitError;
import com.kms.katalon.core.reporting.JUnitFailure;
import com.kms.katalon.core.reporting.JUnitProperties;
import com.kms.katalon.core.reporting.JUnitProperty;
import com.kms.katalon.core.reporting.JUnitReportObjectFactory;
import com.kms.katalon.core.reporting.JUnitSkipped;
import com.kms.katalon.core.reporting.JUnitTestCase;
import com.kms.katalon.core.reporting.JUnitTestSuite;
import com.kms.katalon.core.reporting.JUnitTestSuites;
import com.kms.katalon.core.reporting.ReportWriterUtil;
import com.kms.katalon.core.testcase.VariableReport;
import com.kms.katalon.core.testdata.reader.CsvWriter;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

public class ReportUtil {
    public static final String JUNIT_REPORT_FILE_NAME = "JUnit_Report.xml";

    public static String getOs() {
        return System.getProperty("os.name") + " " + System.getProperty("sun.arch.data.model") + "bit";
    }

    public static String getHostName() {
        String hostName = "Unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        return hostName;
    }

    private static void collectInfoLines(ILogRecord logRecord, List<ILogRecord> rmvLogs) {
        if (logRecord instanceof MessageLogRecord && (logRecord.getStatus().getStatusValue() == TestStatus.TestStatusValue.INCOMPLETE || logRecord.getStatus().getStatusValue() == TestStatus.TestStatusValue.INFO)) {
            rmvLogs.add(logRecord);
        }
        ILogRecord[] iLogRecordArray = logRecord.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord childLogRecord = iLogRecordArray[n2];
            ReportUtil.collectInfoLines(childLogRecord, rmvLogs);
            ++n2;
        }
    }

    public static void writeLogRecordToCSVFile(TestSuiteLogRecord suiteLogEntity, File destFile, List<ILogRecord> filteredTestCases) throws IOException {
        ReportUtil.writeLogRecordToCSVFile(suiteLogEntity, destFile, filteredTestCases, true);
    }

    public static void writeLogRecordToCSVFile(TestSuiteLogRecord suiteLogEntity, File destFile, List<ILogRecord> filteredTestCases, boolean stepsIncluded) throws IOException {
        CsvWriter.writeCsvReport(suiteLogEntity, destFile, filteredTestCases, stepsIncluded);
    }

    public static void writeLogRecordToJUnitFile(String logFolder) throws Exception {
        TestSuiteLogRecord testSuiteLogRecord = ReportWriterUtil.parseCollectionSuiteLog(logFolder);
        if (testSuiteLogRecord != null) {
            ReportUtil.writeJUnitReport(testSuiteLogRecord, new File(logFolder));
        }
    }

    public static JUnitTestSuite generateJUnitTestSuite(TestSuiteLogRecord suiteLogEntity) {
        String msg;
        JUnitReportObjectFactory factory = new JUnitReportObjectFactory();
        String testSuiteName = suiteLogEntity.getName();
        String totalTests = "" + suiteLogEntity.getTotalTestCases();
        String totalError = "" + suiteLogEntity.getTotalErrorTestCases();
        String totalFailure = "" + suiteLogEntity.getTotalFailedTestCases();
        String totalSkipped = "" + suiteLogEntity.getTotalSkippedTestCases();
        TestCaseLogRecord lastTestCaseLogRecord = suiteLogEntity.getLastTestCaseLogRecord();
        String duration = "" + (float)((lastTestCaseLogRecord != null ? lastTestCaseLogRecord.getEndTime() : suiteLogEntity.getEndTime()) - suiteLogEntity.getStartTime()) / 1000.0f;
        JUnitProperties properties = factory.createProperties();
        List<JUnitProperty> propertyList = properties.getProperty();
        propertyList.add(new JUnitProperty("deviceName", suiteLogEntity.getDeviceName()));
        propertyList.add(new JUnitProperty("devicePlatform", suiteLogEntity.getDevicePlatform()));
        propertyList.add(new JUnitProperty("logFolder", StringEscapeUtils.escapeJava((String)suiteLogEntity.getLogFolder())));
        propertyList.add(new JUnitProperty("logFiles", factory.sanitizeReportLogs(suiteLogEntity)));
        propertyList.add(new JUnitProperty("attachments", factory.sanitizeReportAttachments(suiteLogEntity)));
        suiteLogEntity.getRunData().forEach((name, value) -> {
            boolean bl = propertyList.add(new JUnitProperty((String)name, (String)value));
        });
        JUnitTestSuite ts = factory.createTestSuite();
        ts.setProperties(properties);
        ts.setId(suiteLogEntity.getId());
        ts.setName(testSuiteName);
        ts.setHostname(suiteLogEntity.getHostName());
        ts.setTime(duration);
        ZonedDateTime zdt = Instant.ofEpochMilli(suiteLogEntity.getStartTime()).atZone(ZoneId.systemDefault());
        ts.setTimestamp(DateTimeFormatter.ISO_INSTANT.format(zdt));
        ts.setSystemOut(suiteLogEntity.getSystemOutMsg().trim());
        ts.setSystemErr(suiteLogEntity.getSystemErrorMsg().trim());
        ts.setTests(totalTests);
        ts.setErrors(totalError);
        ts.setFailures(totalFailure);
        ts.setSkipped(totalSkipped);
        StringBuilder tsSystemOut = new StringBuilder();
        for (ILogRecord log : suiteLogEntity.getBeforeTestSuiteLogRecords()) {
            msg = log.getSystemOutMsg();
            if (!StringUtils.isNotEmpty((String)msg)) continue;
            tsSystemOut.append(msg.trim()).append("\n\n");
        }
        tsSystemOut.append(suiteLogEntity.getSystemOutMsg().trim());
        for (ILogRecord log : suiteLogEntity.getAfterTestSuiteLogRecords()) {
            msg = log.getSystemOutMsg();
            if (!StringUtils.isNotEmpty((String)msg)) continue;
            tsSystemOut.append("\n\n").append(msg.trim());
        }
        ts.setSystemOut(tsSystemOut.toString());
        Arrays.asList(suiteLogEntity.filterFinalTestCasesResult()).stream().forEach(item -> {
            JUnitTestCase tc = factory.createTestCase();
            String time = "" + (float)(item.getEndTime() - item.getStartTime()) / 1000.0f;
            if (item instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)item;
                JUnitProperties testCaseProperties = factory.createProperties();
                List<JUnitProperty> testCasePropertyList = testCaseProperties.getProperty();
                String rawDataBinding = ReportUtil.getTestCaseLogRecordProperty(testCaseLogRecord, "executionBindingVariables");
                Map<String, Object> dataBinding = ReportUtil.parseDataBindingAsMap(rawDataBinding);
                if (dataBinding != null && !dataBinding.isEmpty()) {
                    testCasePropertyList.add(new JUnitProperty("data_binding", null, JsonUtil.toJson(dataBinding, false)));
                    tc.setProperties(testCaseProperties);
                }
            }
            tc.setClassname(item.getId());
            tc.setName(item.getName());
            tc.setTime(time);
            TestStatus status = item.getStatus();
            TestStatus.TestStatusValue statusValue = status.getStatusValue();
            String statusName = statusValue.name();
            String message = StringUtils.removeStart((String)item.getMessage(), (String)(item.getName() + " " + statusName + " because (of) "));
            tc.setStatus(statusName);
            if (TestStatus.TestStatusValue.ERROR == statusValue) {
                JUnitError error = factory.createError();
                error.setType(statusName);
                error.setMessage(message);
                tc.getError().add(error);
            }
            if (TestStatus.TestStatusValue.FAILED == statusValue) {
                JUnitFailure failure = factory.createFailure();
                failure.setType(statusName);
                failure.setMessage(message);
                tc.getFailure().add(failure);
            }
            if (TestStatus.TestStatusValue.SKIPPED == statusValue) {
                JUnitSkipped skipped = factory.createSkipped();
                message = StringUtils.isNotEmpty((String)message) ? message : "Test was skipped";
                skipped.setMessage(message);
                tc.getSkipped().add(skipped);
            }
            tc.getSystemOut().add(item.getSystemOutMsg().trim());
            tc.getSystemErr().add(item.getSystemErrorMsg().trim());
            ts.getTestcase().add(tc);
        });
        return ts;
    }

    public static void writeJUnitReport(TestSuiteCollectionLogRecord suiteCollectionLogRecord, File logFolder) throws JAXBException, IOException {
        JUnitReportObjectFactory factory = new JUnitReportObjectFactory();
        ArrayList<JUnitTestSuite> tsList = new ArrayList<JUnitTestSuite>();
        for (TestSuiteLogRecord suiteLogEntity : suiteCollectionLogRecord.getTestSuiteRecords()) {
            JUnitTestSuite ts = ReportUtil.generateJUnitTestSuite(suiteLogEntity);
            tsList.add(ts);
        }
        String testSuiteCollectionName = suiteCollectionLogRecord.getName();
        String testSuiteCollectionTotalTests = suiteCollectionLogRecord.getTotalTestCases();
        String testSuiteCollectiontotalError = suiteCollectionLogRecord.getTotalErrorTestCases();
        String testSuiteCollectionTotalFailure = suiteCollectionLogRecord.getTotalFailedTestCases();
        String testSuiteCollectionDuration = "" + (float)(suiteCollectionLogRecord.getEndTime() - suiteCollectionLogRecord.getStartTime()) / 1000.0f;
        JUnitTestSuites tss = factory.createTestSuites();
        tss.setErrors(testSuiteCollectiontotalError);
        tss.setFailures(testSuiteCollectionTotalFailure);
        tss.setTests(testSuiteCollectionTotalTests);
        tss.setTime(testSuiteCollectionDuration);
        tss.setName(testSuiteCollectionName);
        tss.getTestsuite().addAll(tsList);
        JAXBContext context = ReportUtil.createJAXBContext();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)tss, new File(logFolder, JUNIT_REPORT_FILE_NAME));
    }

    public static void writeJUnitReport(TestSuiteLogRecord suiteLogEntity, File logFolder) throws JAXBException, IOException {
        JUnitReportObjectFactory factory = new JUnitReportObjectFactory();
        JUnitTestSuite ts = ReportUtil.generateJUnitTestSuite(suiteLogEntity);
        JUnitTestSuites tss = factory.createTestSuites();
        tss.setErrors(ts.getErrors());
        tss.setFailures(ts.getFailures());
        tss.setTests(ts.getTests());
        tss.setTime(ts.getTime());
        tss.setName(ts.getName());
        tss.getTestsuite().add(ts);
        JAXBContext context = ReportUtil.createJAXBContext();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)tss, new File(logFolder, JUNIT_REPORT_FILE_NAME));
    }

    public static String getTestCaseLogRecordProperty(TestCaseLogRecord testCaseLogRecord, String property) {
        if (testCaseLogRecord == null || StringUtils.isBlank((String)property)) {
            return null;
        }
        Map<String, String> testCaseLogRecordProperties = testCaseLogRecord.getProperties();
        if (testCaseLogRecordProperties == null) {
            return null;
        }
        return testCaseLogRecordProperties.get(property);
    }

    public static List<VariableReport> parseDataBinding(String rawDataBinding) {
        if (StringUtils.isBlank((String)rawDataBinding)) {
            return null;
        }
        Type listType = new TypeToken<List<VariableReport>>(){}.getType();
        return (List)JsonUtil.fromJson(rawDataBinding, listType);
    }

    public static Map<String, Object> parseDataBindingAsMap(String rawDataBinding) {
        List<VariableReport> variables = ReportUtil.parseDataBinding(rawDataBinding);
        HashMap<String, Object> dataBinding = new HashMap<String, Object>();
        if (variables == null) {
            return dataBinding;
        }
        variables.forEach(variable -> dataBinding.put(variable.getDisplayReportName(), variable.isMasked() ? "********" : variable.getValue()));
        return dataBinding;
    }

    private static JAXBContext createJAXBContext() throws JAXBException {
        JAXBContext context = JAXBContextFactory.createContext((Class[])new Class[]{JUnitError.class, JUnitFailure.class, JUnitProperties.class, JUnitProperty.class, JUnitTestCase.class, JUnitTestSuites.class, JUnitTestSuite.class, JUnitSkipped.class}, new HashMap());
        return context;
    }

    public static void writeExecutionUUIDToFile(String UUID2, File logFolder) throws IOException, URISyntaxException {
        FileUtils.writeStringToFile((File)new File(logFolder, "execution.uuid"), (String)UUID2, (String)"UTF-8");
    }

    public static void writeCSVReport(TestSuiteLogRecord suiteLogEntity, File logFolder) throws IOException {
        CsvWriter.writeCsvReport(suiteLogEntity, new File(logFolder, logFolder.getName() + ".csv"), Arrays.asList(suiteLogEntity.getChildRecords()));
    }

    public static void writeLogRecordToHTMLFile(ReportWriterUtil.SuiteReportGenerationOptions options) throws IOException, URISyntaxException {
        TestSuiteLogRecord testSuiteLogRecord = options.getSuiteLogRecord();
        ArrayList<ILogRecord> infoLogs = new ArrayList<ILogRecord>();
        ReportUtil.collectInfoLines(testSuiteLogRecord, infoLogs);
        for (ILogRecord infoLog : infoLogs) {
            infoLog.getParentLogRecord().removeChildRecord(infoLog);
        }
        ReportWriterUtil.writeHTMLReport(options);
    }

    public static List<XmlLogRecord> getAllLogRecords(String logFolder) throws XMLParserException, IOException, XMLStreamException {
        return XMLLoggerParser.readFromLogFolder(logFolder);
    }
}

