/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.html;

import com.google.common.io.BaseEncoding;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.html.JsCallStepModel;
import com.kms.katalon.core.reporting.html.JsModel;
import com.kms.katalon.core.reporting.html.JsModelProperty;
import com.kms.katalon.core.setting.BundleSettingStore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class JsStepModel
extends JsModel {
    private TestStepLogRecord stepLogEntity;
    private List<String> listStrings;
    private String parentPrefix;
    private List<JsCallStepModel> calledTests;
    private List<JsStepModel> calledSteps;
    private JsModel status;
    private List<JsModel> logRecords;

    public JsStepModel(TestStepLogRecord stepLog, List<String> listStrings, String parentPrefix) {
        this.stepLogEntity = stepLog;
        this.listStrings = listStrings;
        this.parentPrefix = parentPrefix;
    }

    private void init() {
        this.calledTests = new ArrayList<JsCallStepModel>();
        this.calledSteps = new ArrayList<JsStepModel>();
        this.status = new JsModel();
        this.logRecords = new ArrayList<JsModel>();
        Object stepName = this.stepLogEntity.getName();
        if (this.parentPrefix != null && !this.parentPrefix.isEmpty()) {
            stepName = this.parentPrefix + "." + (String)stepName;
        }
        this.props.add(new JsModelProperty("Type", "0", null));
        this.props.add(new JsModelProperty("name", (String)stepName, this.listStrings));
        this.props.add(new JsModelProperty("timeout", "0", null));
        this.props.add(new JsModelProperty("doc", StringEscapeUtils.unescapeJava((String)this.stepLogEntity.getDescription()), this.listStrings));
        this.props.add(new JsModelProperty("args", "0", null));
        this.initStatus();
        if (this.stepLogEntity.getChildRecords().length > 0) {
            ILogRecord[] iLogRecordArray = this.stepLogEntity.getChildRecords();
            int n = iLogRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILogRecord logRecord = iLogRecordArray[n2];
                if (logRecord instanceof TestCaseLogRecord) {
                    this.calledTests.add(new JsCallStepModel(this.stepLogEntity, (TestCaseLogRecord)logRecord, this.listStrings));
                } else if (logRecord instanceof TestStepLogRecord) {
                    this.calledSteps.add(new JsStepModel((TestStepLogRecord)logRecord, this.listStrings, ""));
                }
                ++n2;
            }
        }
        this.initLogRecords();
    }

    @Override
    public StringBuilder toArrayString() {
        this.init();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (JsModelProperty prop : this.props) {
            sb.append(prop.getPropertyValue());
            sb.append(",");
        }
        sb.append((CharSequence)this.status.toArrayString());
        sb.append(",");
        sb.append("[");
        boolean isLooping = this.calledTests.size() > 1;
        int i = 0;
        while (i < this.calledTests.size()) {
            if (!isLooping) {
                int j = 0;
                while (j < this.calledTests.get(i).getTestModel().getSteps().size()) {
                    JsStepModel innerStep = this.calledTests.get(i).getTestModel().getSteps().get(j);
                    sb.append((CharSequence)innerStep.toArrayString());
                    if (j < this.calledTests.get(i).getTestModel().getSteps().size() - 1) {
                        sb.append(",");
                    }
                    ++j;
                }
            } else {
                sb.append((CharSequence)this.calledTests.get(i).toArrayString());
                if (i < this.calledTests.size() - 1) {
                    sb.append(",");
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.calledSteps.size()) {
            JsStepModel innerStep = this.calledSteps.get(i);
            sb.append((CharSequence)innerStep.toArrayString());
            if (i < this.calledSteps.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        sb.append(",");
        sb.append("[");
        i = 0;
        while (i < this.logRecords.size()) {
            sb.append((CharSequence)this.logRecords.get(i).toArrayString());
            if (i < this.logRecords.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        sb.append("]");
        return sb;
    }

    private void initStatus() {
        Object statVal = "";
        statVal = this.stepLogEntity.getStatus() == null ? "" + TestStatus.TestStatusValue.INCOMPLETE.ordinal() : "" + this.stepLogEntity.getStatus().getStatusValue().ordinal();
        long startTime = this.stepLogEntity.getStartTime();
        long elapsedTime = this.stepLogEntity.getEndTime() - startTime;
        this.status.props.add(new JsModelProperty("status", (String)statVal, null));
        this.status.props.add(new JsModelProperty("startTime", String.valueOf(startTime), null));
        this.status.props.add(new JsModelProperty("elapsedTime", String.valueOf(elapsedTime), null));
    }

    private void initLogRecords() {
        ILogRecord[] iLogRecordArray = this.stepLogEntity.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord logRecord = iLogRecordArray[n2];
            if (logRecord instanceof MessageLogRecord) {
                MessageLogRecord messageLog = (MessageLogRecord)logRecord;
                long logStartTime = messageLog.getStartTime();
                String logStatVal = "" + messageLog.getStatus().getStatusValue().ordinal();
                String logStatMsg = messageLog.getMessage();
                JsModel jsLogRecModel = new JsModel();
                jsLogRecModel.props.add(new JsModelProperty("startTime", "" + logStartTime, null));
                jsLogRecModel.props.add(new JsModelProperty("status", logStatVal, null));
                jsLogRecModel.props.add(new JsModelProperty("message", logStatMsg, this.listStrings));
                if (messageLog.getAttachment() != null && !messageLog.getAttachment().isEmpty()) {
                    String logFolder;
                    File attachmentFile = new File(messageLog.getAttachment());
                    if (!attachmentFile.isAbsolute() && (logFolder = this.getLogFolder(messageLog)) != null) {
                        attachmentFile = new File(logFolder + File.separator + messageLog.getAttachment());
                    }
                    if (attachmentFile.exists()) {
                        try {
                            BundleSettingStore bundleSettingStore = new BundleSettingStore(RunConfiguration.getProjectDir(), "com.katalon.plugin.report", true);
                            boolean useBase64 = !bundleSettingStore.getBoolean("useHTMLImageReferences", false);
                            String linkValue = useBase64 ? "data:image/png;base64," + this.encodeFileContent(attachmentFile) : messageLog.getAttachment();
                            jsLogRecModel.props.add(new JsModelProperty("link", linkValue, this.listStrings));
                        }
                        catch (Exception exception) {}
                    }
                }
                this.logRecords.add(jsLogRecModel);
            }
            ++n2;
        }
    }

    private String getLogFolder(MessageLogRecord messageLog) {
        ILogRecord logRecord = messageLog;
        while (logRecord != null) {
            if (logRecord instanceof TestSuiteLogRecord) {
                return ((TestSuiteLogRecord)logRecord).getLogFolder();
            }
            logRecord = logRecord.getParentLogRecord();
        }
        return null;
    }

    private String encodeFileContent(File file) throws FileNotFoundException, Exception, IOException {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            String string = BaseEncoding.base64().encode(this.getBinaryFromInputStream(is));
            return string;
        }
    }

    private byte[] getBinaryFromInputStream(InputStream content) throws Exception {
        int length;
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[8096];
        while ((length = content.read(buffer)) > -1) {
            output.write(buffer, 0, length);
        }
        output.close();
        return output.toByteArray();
    }
}

