/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.newreport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class NewHTMLReportDataWriter {
    public static final String REPORT_DATA_FOLDER = "data";
    public static final String PART_NAME_FORMAT = "part-{0}.js";
    public Writer writer;
    public File outputDir;
    public boolean useSplitReportData;

    public NewHTMLReportDataWriter(Writer writer, File outputDir, boolean useSplitReportData) {
        this.writer = writer;
        this.outputDir = outputDir;
        this.useSplitReportData = useSplitReportData;
    }

    public void writePart(String part, String partKey) throws IOException {
        if (this.useSplitReportData) {
            this.preparePartFolder();
            boolean isMainPart = StringUtils.equals((CharSequence)partKey, (CharSequence)"main");
            if (isMainPart) {
                this.writePart(part, partKey, this.writer);
            } else {
                this.writePart(part, partKey, this.getPartFile(partKey));
            }
        } else {
            this.writePart(part, partKey, this.writer);
        }
    }

    public void writePart(String part, String partKey, File outputFile) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream fileStream = new FileOutputStream(outputFile);){
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileStream, "UTF-8");){
                this.writePart(part, partKey, writer, true);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void writePart(String part, String partKey, Writer writer) throws IOException {
        this.writePart(part, partKey, writer, false);
    }

    public void writePart(String part, String partKey, Writer writer, boolean isExternalScript) throws IOException {
        if (!isExternalScript) {
            writer.write(MessageFormat.format("\n<script id=''{0}''>\n", partKey));
            writer.write("window.addEventListener('DOMContentLoaded', () => {");
        }
        writer.write("loadExecutionData('" + partKey + "', " + part + ")");
        if (!isExternalScript) {
            writer.write("})");
            writer.write("\n</script>\n");
        }
    }

    private File getPartFile(String partKey) {
        return Paths.get(this.outputDir.getAbsolutePath(), REPORT_DATA_FOLDER, this.getPartFileName(partKey)).toFile();
    }

    private void preparePartFolder() {
        this.getPartFile("").getParentFile().mkdirs();
    }

    private String getPartFileName(String partKey) {
        return MessageFormat.format(PART_NAME_FORMAT, partKey);
    }
}

