/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.pdf;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.reporting.pdf.exception.JasperReportException;
import com.kms.katalon.core.reporting.util.ResourceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public abstract class AbstractPdfReportGenerator {
    protected static final String TEST_SUITE_TPL = "resources/pdf/test_suite_tpl.jrxml";
    protected static final String TEST_CASE_TPL = "resources/pdf/test_case_tpl.jrxml";
    protected static final String TEST_CASE_SUMMARY_TPL = "resources/pdf/test_case_summary.jrxml";

    protected abstract ILogRecord[] getLogRecords();

    protected abstract String getPrimaryTemplateLocation();

    protected abstract Map<String, Object> getAdditionalParams();

    private Map<String, Object> getReportParams() {
        HashMap<String, Object> jasperParams = new HashMap<String, Object>();
        jasperParams.put("TEST_CASE_TPL", TEST_CASE_TPL);
        jasperParams.put("TEST_CASE_SUMMARY_TPL", TEST_CASE_SUMMARY_TPL);
        jasperParams.putAll(this.getAdditionalParams());
        return jasperParams;
    }

    public File exportToPDF(String fileLocation) throws JasperReportException, IOException {
        return this.exportToPDF(fileLocation, this.getPrimaryTemplateLocation());
    }

    public File exportToPDF(String fileLocation, String primaryTemplateLocation) throws JasperReportException, IOException {
        File pdfFile = new File(fileLocation);
        File parentDir = pdfFile.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Failed to create parent directory: " + parentDir.getAbsolutePath());
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            File file;
            block17: {
                Throwable throwable = null;
                Object var8_10 = null;
                InputStream inputStream = ResourceUtil.getResourceAsInputStream(this.getClass(), primaryTemplateLocation);
                try {
                    if (inputStream == null) {
                        throw new JasperReportException("Template not found: " + primaryTemplateLocation);
                    }
                    JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)inputStream);
                    JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.getReportParams(), (JRDataSource)new JRBeanCollectionDataSource(Arrays.asList(this.getLogRecords())));
                    JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)pdfFile.getAbsolutePath());
                    file = pdfFile;
                    if (inputStream == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (JRException | JRRuntimeException e) {
                        System.out.println(e.getMessage());
                        throw new JasperReportException("Unable to export pdf to location: " + fileLocation, e);
                    }
                }
                inputStream.close();
            }
            return file;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }
}

