/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting.pdf;

import com.kms.katalon.core.reporting.util.ResourceUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.apache.commons.io.FileUtils;

public class JasperClasspathManager {
    private static JasperClasspathManager _instance;
    private final JRPropertiesUtil jrPropertiesUtil = JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance());
    public static final String TEMP_DIR;
    public static final String JASPER_REPORTS_COMPILER_CLASSPATH = "net.sf.jasperreports.compiler.classpath";
    public static final String JASPER_REPORTS_COMPILER_TEMP_DIR = "net.sf.jasperreports.compiler.temp.dir";
    private boolean resolveClasspath = false;

    static {
        TEMP_DIR = System.getProperty("java.io.tmpdir") + File.separator + "Katalon";
    }

    private JasperClasspathManager() {
    }

    public static JasperClasspathManager getInstance() {
        if (_instance == null) {
            _instance = new JasperClasspathManager();
        }
        return _instance;
    }

    public synchronized void modifySystemProperties() throws IOException, URISyntaxException {
        if (!this.resolveClasspath) {
            this.jrPropertiesUtil.setProperty("net.sf.jasperreports.awt.ignore.missing.font", "true");
            this.modifyClasspathProperty();
            this.modifyTempDirProperty();
        }
        this.resolveClasspath = true;
    }

    private void modifyTempDirProperty() {
        this.jrPropertiesUtil.setProperty(JASPER_REPORTS_COMPILER_TEMP_DIR, TEMP_DIR + "/generated/pdf");
    }

    private File getTempClasspathDir() {
        String nonRemovableSystemDir = new File(TEMP_DIR, "non-removable").getAbsolutePath();
        return new File(nonRemovableSystemDir, "com.kms.katalon.jasper");
    }

    private void modifyClasspathProperty() throws IOException, URISyntaxException {
        StringBuilder classPathBuilder = new StringBuilder();
        File tempClasspathDir = this.getTempClasspathDir();
        if (tempClasspathDir.exists()) {
            FileUtils.cleanDirectory((File)tempClasspathDir);
        }
        tempClasspathDir.mkdirs();
        File[] fileArray = ResourceUtil.getFiles(this.getClass(), "lib", tempClasspathDir, true);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File libFile = fileArray[n2];
            classPathBuilder.append(libFile.getAbsolutePath()).append(";");
            ++n2;
        }
        this.jrPropertiesUtil.setProperty(JASPER_REPORTS_COMPILER_CLASSPATH, classPathBuilder.toString());
    }
}

