/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NodeUtils {
    public static <NodeType> NodeType find(NodeType root, NodeVerifier<NodeType> finder, ChildrenNodeProvider<NodeType> childrenProvider) {
        List<NodeType> founds = NodeUtils.findAll(root, finder, childrenProvider, true);
        return founds.isEmpty() ? null : (NodeType)founds.get(0);
    }

    public static <NodeType> NodeType find(Iterable<NodeType> items, NodeVerifier<NodeType> finder, ChildrenNodeProvider<NodeType> childrenProvider) {
        List<NodeType> founds = NodeUtils.findAll(items, finder, childrenProvider, true);
        return founds.isEmpty() ? null : (NodeType)founds.get(0);
    }

    public static <NodeType> List<NodeType> findAll(NodeType root, NodeVerifier<NodeType> finder, ChildrenNodeProvider<NodeType> childrenProvider) {
        return NodeUtils.findAll(root, finder, childrenProvider, false);
    }

    public static <NodeType> List<NodeType> findAll(Iterable<NodeType> items, NodeVerifier<NodeType> finder, ChildrenNodeProvider<NodeType> childrenProvider) {
        return NodeUtils.findAll(items, finder, childrenProvider, false);
    }

    private static <NodeType> List<NodeType> findAll(NodeType root, NodeVerifier<NodeType> finder, ChildrenNodeProvider<NodeType> childrenProvider, boolean findFirst) {
        ArrayList<NodeType> founds = new ArrayList<NodeType>();
        if (finder.test(root)) {
            founds.add(root);
            if (findFirst) {
                return founds;
            }
        }
        if (childrenProvider != null) {
            founds.addAll(NodeUtils.findAll(childrenProvider.get(root), finder, childrenProvider, findFirst));
        }
        return founds;
    }

    private static <NodeType> List<NodeType> findAll(Iterable<NodeType> items, NodeVerifier<NodeType> finder, ChildrenNodeProvider<NodeType> childrenProvider, boolean findFirst) {
        ArrayList<NodeType> founds = new ArrayList<NodeType>();
        if (items == null) {
            return founds;
        }
        for (NodeType item : items) {
            founds.addAll(NodeUtils.findAll(item, finder, childrenProvider, findFirst));
            if (!findFirst || founds.isEmpty()) continue;
            return new ArrayList<Object>(Arrays.asList(founds.get(0)));
        }
        return founds;
    }

    public static interface ChildrenNodeProvider<NodeType> {
        public Iterable<NodeType> get(NodeType var1);
    }

    public static interface NodeVerifier<NodeType> {
        public boolean test(NodeType var1);
    }
}

