/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;

public class ObjectUtil {
    public static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null ? a.equals(b) : b.equals(a);
    }

    public static <T> T invokeGet(Object object, String getterMethodName) {
        return ObjectUtil.invokeGet(object, getterMethodName, null);
    }

    public static <T> T invokeGet(Object object, String getterMethodName, T defaultValue) {
        Method getter = ObjectUtil.findMethod(object, getterMethodName);
        if (getter != null) {
            return ObjectUtil.valueOrDefault(ObjectUtil.safeInvoke(object, getter), defaultValue);
        }
        return defaultValue;
    }

    public static <T> void invokeSet(Object object, String method, T data) {
        if (data != null) {
            Method setter1 = ObjectUtil.findMethod(object, method, data.getClass());
            if (setter1 != null) {
                ObjectUtil.safeInvoke(object, setter1, data);
                return;
            }
            try {
                Method setter2 = ObjectUtil.findMethod(object, method, (Class)data.getClass().getField("TYPE").get(null));
                if (setter2 != null) {
                    ObjectUtil.safeInvoke(object, setter2, data);
                    return;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
        }
        try {
            Method setter3 = ObjectUtil.findMethod(object, method, (Class)((ParameterizedType)data.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
            if (setter3 != null) {
                ObjectUtil.safeInvoke(object, setter3, data);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public static <T> void invokeSet(Object object, String method, T data, Class<T> type) {
        Method setter = ObjectUtil.findMethod(object, method, type);
        if (setter != null) {
            ObjectUtil.safeInvoke(object, setter, data);
        }
    }

    @SafeVarargs
    public static <T> boolean hasMethod(Object object, String method, Class<T> ... args) {
        return ObjectUtil.findMethod(object, method, args) != null;
    }

    @SafeVarargs
    public static <T> Method findMethod(Object object, String methodName, Class<T> ... args) {
        if (object == null) {
            return null;
        }
        return ObjectUtil.findMethod(object, object.getClass(), methodName, args);
    }

    @SafeVarargs
    public static <T> Method findMethod(Object object, Class<?> clazz, String methodName, Class<T> ... args) {
        if (object == null || clazz == null) {
            return null;
        }
        try {
            Method foundPublicMethod;
            Method method = foundPublicMethod = args.length == 1 && args[0] == Void.TYPE ? clazz.getMethod(methodName, new Class[0]) : clazz.getMethod(methodName, args);
            if (foundPublicMethod != null) {
                return foundPublicMethod;
            }
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
            try {
                Method foundPrivateMethod = clazz.getDeclaredMethod(methodName, args);
                if (foundPrivateMethod != null) {
                    return foundPrivateMethod;
                }
            }
            catch (NoSuchMethodException | SecurityException exception2) {}
        }
        return ObjectUtil.findMethod(object, clazz.getSuperclass(), methodName, args);
    }

    public static Method findMethod(Object object, String methodName) {
        return ObjectUtil.findMethod(object, object.getClass(), methodName);
    }

    public static Method findMethod(Object object, Class<?> clazz, String methodName) {
        if (object == null || clazz == null) {
            return null;
        }
        try {
            Method foundPublicMethod = clazz.getMethod(methodName, new Class[0]);
            if (foundPublicMethod != null) {
                return foundPublicMethod;
            }
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
            try {
                Method foundPrivateMethod = clazz.getDeclaredMethod(methodName, new Class[0]);
                if (foundPrivateMethod != null) {
                    return foundPrivateMethod;
                }
            }
            catch (NoSuchMethodException | SecurityException exception2) {}
        }
        return ObjectUtil.findMethod(object, clazz.getSuperclass(), methodName);
    }

    public static <T> Object safeInvoke(Object object, String methodName) {
        return ObjectUtil.safeInvoke(object, methodName, new Object[0]);
    }

    public static <T> Object safeInvoke(Object object, String methodName, Object ... args) {
        Method method = ObjectUtil.findMethod(object, methodName);
        return ObjectUtil.safeInvoke(object, method, args);
    }

    public static <T> Object safeInvoke(Object object, Method method) {
        return ObjectUtil.safeInvoke(object, method, new Object[0]);
    }

    public static <T> Object safeInvoke(Object object, Method method, Object ... args) {
        if (object == null || method == null) {
            return null;
        }
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(object, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return null;
        }
    }

    public static String getStringField(Object object, String fieldName) {
        Object fieldValue = ObjectUtil.getField(object, fieldName, null);
        return fieldValue instanceof String ? (String)fieldValue : "";
    }

    public static <T> T getField(Object object, String fieldName) {
        return ObjectUtil.getField(object, fieldName, null);
    }

    public static <T> T getField(Object object, String fieldName, T defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        try {
            Field field = ObjectUtil.findField(object, fieldName);
            if (field == null) {
                return defaultValue;
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return ObjectUtil.valueOrDefault(field.get(object), defaultValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
            return defaultValue;
        }
    }

    public static <T> void setField(Object object, String fieldName, T value) {
        if (object == null) {
            return;
        }
        try {
            Field field = ObjectUtil.findField(object, fieldName);
            if (field == null) {
                return;
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {}
    }

    public static <T> boolean hasField(Object object, String fieldName) {
        if (object == null) {
            return false;
        }
        try {
            Field field = ObjectUtil.findField(object, fieldName);
            return field != null;
        }
        catch (IllegalArgumentException | SecurityException runtimeException) {
            return false;
        }
    }

    public static Field findField(Object object, String fieldName) {
        if (object == null) {
            return null;
        }
        return ObjectUtil.findField(object.getClass(), fieldName);
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            return field != null ? field : ObjectUtil.findField(clazz.getSuperclass(), fieldName);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return ObjectUtil.findField(clazz.getSuperclass(), fieldName);
        }
    }

    public static <T> T clone(T source) {
        try {
            return (T)ObjectUtil.clone(source, source.getClass().newInstance());
        }
        catch (IllegalAccessException | InstantiationException error) {
            error.printStackTrace();
            return null;
        }
    }

    public static <T1, T2> T2 clone(T1 source, T2 destination) {
        return ObjectUtil.clone(source, source.getClass(), destination);
    }

    public static <T1, T2> T2 clone(T1 source, Class<?> sourceClass, T2 destination) {
        Field[] fields;
        if (sourceClass.getSuperclass() != null) {
            ObjectUtil.clone(source, sourceClass.getSuperclass(), destination);
        }
        Field[] fieldArray = fields = sourceClass.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            if (ObjectUtil.hasField(destination, fieldName)) {
                ObjectUtil.setField(destination, fieldName, ObjectUtil.getField(source, fieldName));
            }
            ++n2;
        }
        return destination;
    }

    public static <T> T valueOrDefault(Object value, T defaultValue) {
        return (T)(value != null ? value : defaultValue);
    }

    public static void parseAndSet(Object object, String fieldName, String rawValue) {
        Method valueOf;
        Field field = ObjectUtil.findField(object, fieldName);
        if (field == null) {
            return;
        }
        Class<?> type = field.getType();
        if (type.isArray()) {
            return;
        }
        if (type == String.class) {
            ObjectUtil.setField(object, fieldName, rawValue);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            ObjectUtil.setField(object, fieldName, Boolean.valueOf(rawValue));
        } else if (type == Integer.class || type == Integer.TYPE) {
            ObjectUtil.setField(object, fieldName, Integer.valueOf(rawValue, 10));
        } else if (type == Float.class || type == Float.TYPE) {
            ObjectUtil.setField(object, fieldName, Float.valueOf(rawValue));
        } else if (type == Double.class || type == Double.TYPE) {
            ObjectUtil.setField(object, fieldName, Double.valueOf(rawValue));
        } else if (type.isEnum() && (valueOf = ObjectUtil.findMethod(type, type, "valueOf", String.class)) != null) {
            Object enumValue = ObjectUtil.safeInvoke(type, valueOf, rawValue);
            ObjectUtil.setField(object, fieldName, enumValue);
        }
    }
}

