/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.network.ProxyServerType;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ProxyUtil {
    private static final String JAVA_NET_USE_SYSTEM_PROXIES = "java.net.useSystemProxies";
    private static final List<NetworkInterface> NETWORK_INTERFACES;

    static {
        try {
            NETWORK_INTERFACES = Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException se) {
            throw new RuntimeException("Could not retrieve ethernet network interfaces.", se);
        }
    }

    public static Proxy getProxy(ProxyInformation proxyInfo) throws URISyntaxException, IOException {
        if (proxyInfo == null) {
            throw new IllegalArgumentException("proxyInfo cannot be null");
        }
        switch (ProxyOption.valueOf(proxyInfo.getProxyOption())) {
            case NO_PROXY: {
                return Proxy.NO_PROXY;
            }
            case USE_SYSTEM: {
                return ProxyUtil.getSystemProxy();
            }
            case MANUAL_CONFIG: {
                return ProxyUtil.getProxyForManualConfig(proxyInfo);
            }
        }
        return Proxy.NO_PROXY;
    }

    public static Proxy getProxy(ProxyInformation proxyInfo, URL url) throws URISyntaxException, IOException {
        if (proxyInfo == null) {
            throw new IllegalArgumentException("proxyInfo cannot be null");
        }
        String[] excludes = proxyInfo.getExceptionList().split(",");
        switch (ProxyOption.valueOf(proxyInfo.getProxyOption())) {
            case NO_PROXY: {
                return Proxy.NO_PROXY;
            }
            case USE_SYSTEM: {
                return ProxyUtil.getSystemProxy();
            }
            case MANUAL_CONFIG: {
                if (!ProxyUtil.excludes(excludes, url.getHost(), url.getPort())) {
                    return ProxyUtil.getProxyForManualConfig(proxyInfo);
                }
                return Proxy.NO_PROXY;
            }
        }
        return Proxy.NO_PROXY;
    }

    private static boolean excludes(String[] excludes, String targetHost, int targetPort) {
        if (excludes == null || targetHost == null) {
            return false;
        }
        String[] stringArray = excludes;
        int n = excludes.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String exclude;
                block7: {
                    String rawExclude = stringArray[n2];
                    if (StringUtils.isBlank((String)rawExclude)) break block6;
                    exclude = rawExclude.trim();
                    int ix = exclude.indexOf(58);
                    if (ix < 0 || exclude.length() <= ix + 1) break block7;
                    String excludePort = exclude.substring(ix + 1);
                    if (targetPort == -1 || !excludePort.equals(String.valueOf(targetPort))) break block6;
                    exclude = exclude.substring(0, ix);
                }
                String excludeIp = exclude.indexOf(42) >= 0 ? exclude.replace("*", ".*") : ProxyUtil.nslookup(exclude, true);
                String ip = ProxyUtil.nslookup(targetHost, true);
                Pattern pattern = Pattern.compile(excludeIp);
                Matcher matcher = pattern.matcher(ip);
                Matcher matcher2 = pattern.matcher(targetHost);
                if (matcher.find() || matcher2.find()) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private static String nslookup(String hostName, boolean ip) {
        String address;
        try {
            InetAddress hostAddress = InetAddress.getByName(hostName);
            address = ip ? hostAddress.getHostAddress() : hostAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return hostName;
        }
        return address;
    }

    private static Proxy getSystemProxy() throws URISyntaxException, IOException {
        System.setProperty(JAVA_NET_USE_SYSTEM_PROXIES, "true");
        for (String ipAdress : ProxyUtil.getAllIpAddresses()) {
            List<Proxy> l = ProxySelector.getDefault().select(new URI("http://" + ipAdress));
            for (Proxy proxy : l) {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (addr == null) continue;
                return proxy;
            }
        }
        return Proxy.NO_PROXY;
    }

    private static Proxy getProxyForManualConfig(final ProxyInformation proxyInfo) {
        System.setProperty(JAVA_NET_USE_SYSTEM_PROXIES, "false");
        Proxy proxy = new Proxy(ProxyUtil.getProxyTypeForManualConfig(proxyInfo), new InetSocketAddress(proxyInfo.getProxyServerAddress(), proxyInfo.getProxyServerPort()));
        if (StringUtils.isNotEmpty((String)proxyInfo.getUsername()) && StringUtils.isNotEmpty((String)proxyInfo.getPassword())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyInfo.getUsername(), proxyInfo.getPassword().toCharArray());
                }
            });
        }
        return proxy;
    }

    private static Proxy.Type getProxyTypeForManualConfig(ProxyInformation proxyInfo) {
        return ProxyServerType.valueOf(proxyInfo.getProxyServerType()) == ProxyServerType.SOCKS ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
    }

    private static Collection<String> getAllIpAddresses() throws IOException {
        TreeSet<String> addresses = new TreeSet<String>();
        for (NetworkInterface ni : NETWORK_INTERFACES) {
            Enumeration<InetAddress> addressEnumeration = ni.getInetAddresses();
            while (addressEnumeration.hasMoreElements()) {
                InetAddress address = addressEnumeration.nextElement();
                if (address.isLoopbackAddress() || address.getHostAddress().contains(":")) continue;
                addresses.add(address.getHostAddress());
            }
        }
        if (addresses.isEmpty()) {
            throw new IOException("Failed to get non-loopback IP address!");
        }
        return addresses;
    }
}

