/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.factory;

import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.core.keyword.internal.KeywordContributorCollection;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.keyword.KeywordParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuiltInMethodNodeFactory {
    private static List<KeywordClass> keywordClasses;
    public static final String CALL_TEST_CASE_METHOD_NAME = "callTestCase";
    private static Map<String, List<KeywordMethod>> filteredKeywordMethodsMap;
    private static Map<String, KeywordMethod> callTestCaseKeywordMethodMap;

    private static void initKeywordClasses() {
        List keywordContributors = KeywordContributorCollection.getKeywordContributors();
        keywordClasses = new ArrayList<KeywordClass>();
        Collections.sort(keywordContributors, new Comparator<IKeywordContributor>(){

            @Override
            public int compare(IKeywordContributor o1, IKeywordContributor o2) {
                if (o1 != null && o2 != null) {
                    return o1.getPreferredOrder() - o2.getPreferredOrder();
                }
                return 0;
            }
        });
        for (IKeywordContributor keywordContributor : keywordContributors) {
            keywordClasses.add(new KeywordClass(keywordContributor));
        }
    }

    public static List<KeywordClass> getKeywordClasses() {
        if (keywordClasses == null) {
            BuiltInMethodNodeFactory.initKeywordClasses();
        }
        return keywordClasses;
    }

    public static KeywordMethod findMethod(String className, String methodName, String[] paramTypes) {
        List<KeywordMethod> keywordMethods = BuiltInMethodNodeFactory.findKeywordMethodClassByName(className);
        if (keywordMethods == null) {
            return null;
        }
        KeywordMethod mostLikelyMethod = null;
        for (KeywordMethod kwMethod : keywordMethods) {
            if (!kwMethod.getName().equals(methodName)) continue;
            if (paramTypes == null) {
                return kwMethod;
            }
            if (mostLikelyMethod == null) {
                mostLikelyMethod = kwMethod;
            }
            if (kwMethod.getParameters().length != paramTypes.length) continue;
            mostLikelyMethod = kwMethod;
            if (!kwMethod.checkParametersAssignable(paramTypes)) continue;
            return kwMethod;
        }
        return mostLikelyMethod;
    }

    private static List<KeywordMethod> findKeywordMethodClassByName(String className) {
        List<KeywordMethod> keywords = BuiltInMethodNodeFactory.getKeywordMethodsMap().get(className);
        if (keywords != null) {
            return keywords;
        }
        for (Map.Entry<String, List<KeywordMethod>> keywordMethodMapEntry : BuiltInMethodNodeFactory.getKeywordMethodsMap().entrySet()) {
            if (!keywordMethodMapEntry.getKey().contains(className)) continue;
            return keywordMethodMapEntry.getValue();
        }
        return Collections.emptyList();
    }

    public static List<KeywordMethod> getFilteredMethods(String className) {
        return new ArrayList<KeywordMethod>(BuiltInMethodNodeFactory.findKeywordMethodClassByName(className));
    }

    private static boolean hasFailureHandling(KeywordMethod kwMethod) {
        KeywordParameter[] keywordParameterArray = kwMethod.getParameters();
        int n = keywordParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeywordParameter kwParam = keywordParameterArray[n2];
            if (kwParam.isFailureHandlingParam()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List<KeywordMethod> getFilteredMethods(String className, boolean excludeFlowControl) {
        HashMap<String, KeywordMethod> storageFilteredMethods = new HashMap<String, KeywordMethod>();
        for (KeywordMethod kwMethod : BuiltInMethodNodeFactory.getFilteredMethods(className)) {
            String kwName = kwMethod.getName();
            if (storageFilteredMethods.containsKey(kwName) || excludeFlowControl && BuiltInMethodNodeFactory.hasFailureHandling(kwMethod)) continue;
            storageFilteredMethods.put(kwName, kwMethod);
        }
        ArrayList<KeywordMethod> filteredMethods = new ArrayList<KeywordMethod>(storageFilteredMethods.values());
        Collections.sort(filteredMethods, new Comparator<KeywordMethod>(){

            @Override
            public int compare(KeywordMethod kwA, KeywordMethod kwB) {
                return kwA.getName().compareTo(kwB.getName());
            }
        });
        return filteredMethods;
    }

    public static KeywordMethod findCallTestCaseMethod(String className) {
        KeywordMethod keywordMethod = BuiltInMethodNodeFactory.getCallTestCaseKeywordMethodMap().get(className);
        if (keywordMethod != null) {
            return keywordMethod;
        }
        for (Map.Entry<String, KeywordMethod> keywordMethodMapEntry : BuiltInMethodNodeFactory.getCallTestCaseKeywordMethodMap().entrySet()) {
            if (!keywordMethodMapEntry.getKey().contains(className)) continue;
            return keywordMethodMapEntry.getValue();
        }
        return null;
    }

    public static KeywordClass findClass(String keywordClassName) {
        for (KeywordClass keywordClass : BuiltInMethodNodeFactory.getKeywordClasses()) {
            if (!keywordClass.getName().equals(keywordClassName) && !keywordClass.getSimpleName().equals(keywordClassName) && !keywordClass.getAliasName().equals(keywordClassName)) continue;
            return keywordClass;
        }
        return null;
    }

    private static Map<String, List<KeywordMethod>> getKeywordMethodsMap() {
        if (filteredKeywordMethodsMap == null) {
            BuiltInMethodNodeFactory.initFilteredMethodMap();
        }
        return filteredKeywordMethodsMap;
    }

    private static void initFilteredMethodMap() {
        filteredKeywordMethodsMap = new HashMap<String, List<KeywordMethod>>();
        for (KeywordClass keywordClass : BuiltInMethodNodeFactory.getKeywordClasses()) {
            List<KeywordMethod> keywordMethods = keywordClass.getKeywordMethods();
            Collections.sort(keywordMethods, new Comparator<KeywordMethod>(){

                @Override
                public int compare(KeywordMethod keywordMethod_1, KeywordMethod keywordMethod_2) {
                    int order = keywordMethod_1.getName().compareTo(keywordMethod_2.getName());
                    if (order == 0 && keywordMethod_1.getParameters() != null && keywordMethod_2.getParameters() != null) {
                        return keywordMethod_1.getParameters().length - keywordMethod_2.getParameters().length;
                    }
                    return order;
                }
            });
            for (KeywordMethod method : keywordMethods) {
                if (!method.getName().equals(CALL_TEST_CASE_METHOD_NAME)) continue;
                keywordMethods.remove(method);
                break;
            }
            filteredKeywordMethodsMap.put(keywordClass.getName(), keywordMethods);
        }
    }

    private static Map<String, KeywordMethod> getCallTestCaseKeywordMethodMap() {
        if (callTestCaseKeywordMethodMap == null) {
            BuiltInMethodNodeFactory.initCallTestCaseKeywordMethodMap();
        }
        return callTestCaseKeywordMethodMap;
    }

    private static void initCallTestCaseKeywordMethodMap() {
        callTestCaseKeywordMethodMap = new HashMap<String, KeywordMethod>();
        block0: for (KeywordClass keywordClass : BuiltInMethodNodeFactory.getKeywordClasses()) {
            for (KeywordMethod method : keywordClass.getKeywordMethods()) {
                if (!method.getName().equals(CALL_TEST_CASE_METHOD_NAME)) continue;
                callTestCaseKeywordMethodMap.put(keywordClass.getName(), method);
                continue block0;
            }
        }
    }
}

