/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.util.Util;

public class InferParameterAndReturnTypesRequestor
implements ITypeRequestor {
    private Map<Variable, ClassNode> inferredTypes = new HashMap<Variable, ClassNode>();
    private final Region selectedText;

    public InferParameterAndReturnTypesRequestor(List<Variable> actualParameters, Set<Variable> returnParameters, Region selectedText) {
        for (Variable variable : actualParameters) {
            this.inferredTypes.put(variable, null);
        }
        for (Variable variable : returnParameters) {
            this.inferredTypes.put(variable, null);
        }
        this.selectedText = selectedText;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (!this.interestingElement(enclosingElement)) {
            return ITypeRequestor.VisitStatus.CANCEL_MEMBER;
        }
        if (node instanceof Variable) {
            Variable accessedVar;
            if (this.inferredTypes.containsKey((Variable)node)) {
                this.inferredTypes.put((Variable)node, this.extractType(result));
            } else if (node instanceof VariableExpression && this.inferredTypes.containsKey(accessedVar = ((VariableExpression)node).getAccessedVariable())) {
                this.inferredTypes.put(accessedVar, this.extractType(result));
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private ClassNode extractType(TypeLookupResult result) {
        Object type = result.type;
        type = VariableScope.VOID_WRAPPER_CLASS_NODE.equals(type) ? VariableScope.OBJECT_CLASS_NODE : (!ClassHelper.isDynamicTyped((ClassNode)type) ? type.getPlainNodeReference() : null);
        return type;
    }

    public Map<Variable, ClassNode> getInferredTypes() {
        return this.inferredTypes;
    }

    private boolean interestingElement(IJavaElement enclosingElement) {
        if (enclosingElement.getElementName().equals("<clinit>")) {
            return true;
        }
        if (enclosingElement instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)enclosingElement).getSourceRange();
                return range.getOffset() <= this.selectedText.getOffset() && range.getOffset() + range.getLength() >= this.selectedText.getEnd();
            }
            catch (JavaModelException e) {
                Util.log((Throwable)e);
            }
        }
        return false;
    }
}

