/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rename;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class MethodVariantRenameParticipant
extends RenameParticipant {
    private IMethod target;
    private Map<ICompilationUnit, List<SearchMatch>> matches;

    public String getName() {
        return "Rename Groovy method variant references.";
    }

    protected boolean initialize(Object element) {
        this.target = (IMethod)element;
        if (this.getArguments().getUpdateReferences()) {
            try {
                Region region;
                ASTNode method;
                ISourceRange range = this.target.getNameRange();
                ICompilationUnit unit = this.target.getCompilationUnit();
                if (!this.target.isBinary() && !this.target.isReadOnly() && range.getOffset() > 0 && unit instanceof GroovyCompilationUnit && (method = new ASTNodeFinder(region = new Region(range.getOffset(), range.getLength())).doVisit(((GroovyCompilationUnit)unit).getModuleNode())) instanceof MethodNode && ((MethodNode)method).getOriginal().hasDefaultValue()) {
                    return true;
                }
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        RefactoringStatus status = new RefactoringStatus();
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)pm, (String)"Searching for Groovy method variant references", (int)13);
        try {
            SearchPattern pattern = null;
            IMethod[] iMethodArray = this.target.getDeclaringType().getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (!method.equals(this.target) && method.getNameRange().equals(this.target.getNameRange())) {
                    pattern = pattern == null ? SearchPattern.createPattern((IJavaElement)method, (int)2) : SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((IJavaElement)method, (int)2));
                }
                ++n2;
            }
            submon.worked(1);
            SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (IProgressMonitor)submon.split(10), (RefactoringStatus)status);
            groups = Checks.excludeCompilationUnits((SearchResultGroup[])groups, (RefactoringStatus)status);
            status.merge(Checks.checkCompileErrorsInAffectedFiles((SearchResultGroup[])groups));
            this.matches = new HashMap<ICompilationUnit, List<SearchMatch>>();
            submon.worked(1);
            ReferencesInBinaryContext binaryReferences = new ReferencesInBinaryContext("Binary references to method '" + this.target.getElementName() + "'");
            SearchResultGroup[] searchResultGroupArray = groups;
            int n3 = groups.length;
            int n4 = 0;
            while (n4 < n3) {
                SearchResultGroup group = searchResultGroupArray[n4];
                SearchMatch[] searchMatchArray = group.getSearchResults();
                int n5 = searchMatchArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    SearchMatch match = searchMatchArray[n6];
                    if (match.getAccuracy() == 0) {
                        if (((IMethod)match.getElement()).isBinary()) {
                            binaryReferences.add(match);
                        } else {
                            this.matches.computeIfAbsent(group.getCompilationUnit(), x -> new ArrayList()).add(match);
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            binaryReferences.addErrorIfNecessary(status);
            submon.worked(1);
        }
        catch (CoreException e) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)e.getLocalizedMessage()));
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        CompositeChange change = new CompositeChange(this.getName());
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)pm, (int)this.matches.size());
        for (Map.Entry<ICompilationUnit, List<SearchMatch>> entry : this.matches.entrySet()) {
            CompilationUnitChange edits = Optional.ofNullable((CompilationUnitChange)this.getTextChange(entry.getKey())).orElseGet(() -> {
                CompilationUnitChange cuc = new CompilationUnitChange(this.getName(), (ICompilationUnit)entry.getKey());
                cuc.setEdit((TextEdit)new MultiTextEdit());
                change.add((Change)cuc);
                return cuc;
            });
            for (SearchMatch match : entry.getValue()) {
                edits.addEdit((TextEdit)new ReplaceEdit(match.getOffset(), this.target.getElementName().length(), this.getArguments().getNewName()));
            }
            submon.worked(1);
        }
        this.matches = null;
        this.target = null;
        return change;
    }
}

