/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils;

import groovyjarjarantlr.Token;
import groovyjarjarantlr.TokenStream;
import groovyjarjarantlr.TokenStreamException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.codehaus.groovy.antlr.GroovyTokenTypeBridge;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public final class GroovyConventionsBuilder {
    public static final String CLASS = "class";
    public static final String VARIABLE = "variable";
    public static final String METHOD = "method";
    public static final String FIELD = "field";
    private List<String> names = new ArrayList<String>();
    private String element;
    private MultiStatus state = new MultiStatus("org.codehaus.groovy.eclipse.refactoring", 0, "", null);

    public GroovyConventionsBuilder(String name, String element) {
        this.names.add(name);
        this.element = element;
        this.validateNotNull();
    }

    public GroovyConventionsBuilder(List<String> names, String element) {
        this.names = names;
        this.element = element;
        this.validateNotNull();
    }

    public GroovyConventionsBuilder validateUpperCase(int status) {
        for (String name : this.names) {
            if (name.length() <= 0 || !Character.isLowerCase(name.charAt(0))) continue;
            this.state.add((IStatus)new Status(status, "org.codehaus.groovy.eclipse.refactoring", MessageFormat.format("This name is discouraged. According to convention, names of ''{0}'' should start with an uppercase letter.", this.element)));
        }
        return this;
    }

    public GroovyConventionsBuilder validateLowerCase(int status) {
        for (String name : this.names) {
            if (name.length() <= 0 || !Character.isUpperCase(name.charAt(0))) continue;
            this.state.add((IStatus)new Status(status, "org.codehaus.groovy.eclipse.refactoring", MessageFormat.format("This name is discouraged. According to convention, names of ''{0}'' should start with a lowercase letter.", this.element)));
        }
        return this;
    }

    public GroovyConventionsBuilder validateGroovyIdentifier() {
        for (String name : this.names) {
            List<Token> tokenList = GroovyConventionsBuilder.tokenizeString(name);
            if (tokenList.size() == 1 && tokenList.get(0).getType() == GroovyTokenTypeBridge.IDENT) continue;
            this.state.add((IStatus)new Status(4, "org.codehaus.groovy.eclipse.refactoring", MessageFormat.format("''{0}'' is not a valid Groovy identifier", name)));
        }
        return this;
    }

    public IStatus done() {
        return this.state;
    }

    private void validateNotNull() {
        for (String name : this.names) {
            if (name.length() != 0) continue;
            this.state.add((IStatus)new Status(4, "org.codehaus.groovy.eclipse.refactoring", MessageFormat.format("Provide a ''{0}'' name", this.element)));
        }
    }

    public static List<Token> tokenizeString(String name) {
        StringReader input = new StringReader(name);
        GroovyLexer lexer = new GroovyLexer((Reader)input);
        TokenStream stream = lexer.plumb();
        Vector<Token> tokenList = new Vector<Token>();
        Token token = null;
        try {
            while ((token = stream.nextToken()).getType() != 1) {
                tokenList.add(token);
            }
        }
        catch (TokenStreamException e) {
            e.printStackTrace();
        }
        return tokenList;
    }
}

