/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.handlers.CloseProjectHandler;
import com.kms.katalon.composer.project.handlers.ProjectTrustHandler;
import com.kms.katalon.composer.project.handlers.SwitchingEditionsOrVersionsHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.groovy.reference.EntityReferenceIndexService;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.ExecutionTimeTracker;
import com.kms.katalon.util.ExecutorUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OpenProjectHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication application;
    @Inject
    private UISynchronize sync;

    @Execute
    public void execute(Shell shell) {
        try {
            File projectDirectory;
            DirectoryDialog directoryDialog = new DirectoryDialog(shell);
            String path = directoryDialog.open();
            if (path != null && (projectDirectory = new File(path)) != null && projectDirectory.exists() && projectDirectory.isDirectory()) {
                File projectFile = OpenProjectHandler.getProjectFile(projectDirectory);
                if (projectFile != null) {
                    if (!CloseProjectHandler.closeCurrentProject(this.partService, this.modelService, this.application, this.eventBroker)) {
                        return;
                    }
                    this.openProjectEventHandler(shell, projectFile.getAbsolutePath());
                } else {
                    MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)StringConstants.HAND_WARN_MSG_NO_PROJ_FOUND);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_CANNOT_OPEN_PROJ);
        }
    }

    public static File getProjectFile(File projectDirectory) {
        if (projectDirectory == null) {
            return null;
        }
        File[] childFiles = projectDirectory.listFiles();
        if (childFiles == null) {
            return null;
        }
        File[] fileArray = childFiles;
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && ("." + FilenameUtils.getExtension((String)file.getAbsolutePath())).equals(ProjectEntity.getProjectFileExtension())) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public static List<File> getProjectFiles(File projectDirectory) {
        if (projectDirectory == null || projectDirectory.listFiles() == null) {
            return Collections.emptyList();
        }
        ArrayList<File> childProjectFiles = new ArrayList<File>();
        File[] fileArray = projectDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File projectFile;
            File file = fileArray[n2];
            if (file.isDirectory() && (projectFile = OpenProjectHandler.getProjectFile(file)) != null) {
                childProjectFiles.add(projectFile);
            }
            ++n2;
        }
        return childProjectFiles;
    }

    @Inject
    @Optional
    private void openProjectEventHandler(@Named(value="activeShell") Shell shell, @UIEventTopic(value="PROJECT/OPEN") String projectPk) throws InvocationTargetException, InterruptedException, ControllerException {
        boolean forceToOpenProject = new SwitchingEditionsOrVersionsHandler(shell, projectPk).isOpenProjectAnyway();
        if (!forceToOpenProject) {
            return;
        }
        OpenProjectHandler.doOpenProject(shell, projectPk, this.sync, this.eventBroker, this.partService, this.modelService, this.application);
        this.eventBroker.send("INTRODUCE_GENAI", null);
    }

    @Inject
    @Optional
    private void restoreOpenProjectEventHandler(@Named(value="activeShell") Shell shell, @UIEventTopic(value="PROJECT/OPEN_LATEST") String projectPk) throws InvocationTargetException, InterruptedException, ControllerException {
        OpenProjectHandler.doOpenProject(shell, projectPk, this.sync, this.eventBroker, this.partService, this.modelService, this.application);
        this.eventBroker.post("PROJECT/RESTORE_SESSION", null);
    }

    public static void doOpenProject(Shell shell, final String projectPk, final UISynchronize syncService, final IEventBroker eventBrokerService, EPartService partService, final EModelService modelService, final MApplication application) throws InvocationTargetException, InterruptedException, ControllerException {
        if (!CloseProjectHandler.closeCurrentProject(partService, modelService, application, eventBrokerService)) {
            return;
        }
        if (ApplicationRunningMode.get() == RunningMode.GUI && !ProjectTrustHandler.checkProjectTrust(projectPk, shell)) {
            return;
        }
        new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(StringConstants.HAND_OPENING_PROJ, 10);
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                    monitor.worked(1);
                    monitor.subTask(StringConstants.HAND_LOADING_PROJ);
                    BundleContext bundleContext = FrameworkUtil.getBundle(OpenProjectHandler.class).getBundleContext();
                    final IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
                    IFeatureController featureController = (IFeatureController)context.get(IFeatureController.class);
                    boolean allowSourceAttachment = featureController.canUse(ProductFeature.SOURCE_CODE_FOR_DEBUGGING);
                    final ProjectEntity project = ProjectController.getInstance().openProjectForUI(projectPk, allowSourceAttachment, (IProgressMonitor)progress.newChild(7, 1));
                    monitor.subTask(StringConstants.HAND_REFRESHING_EXPLORER);
                    syncService.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (project != null) {
                                    OpenProjectHandler.updateProjectTitle(project, modelService, application);
                                    ExecutionDefaultSettingStore executionStore = ExecutionDefaultSettingStore.getStore();
                                    Boolean smartWaitEnabled = executionStore != null ? Boolean.valueOf(executionStore.isSmartWaitEnabled()) : null;
                                    Trackings.trackOpenProject((ProjectEntity)project, (Boolean)smartWaitEnabled);
                                    EntityReferenceIndexService.getInstance().switchProject(project.getEntityReferenceIndexPath());
                                    ExecutorService testEntityPreloadPool = Executors.newFixedThreadPool(1);
                                    testEntityPreloadPool.submit(() -> {
                                        OpenProjectHandler.prepareEntityReferenceIndex(project);
                                        OpenProjectHandler.preloadTestEntities(project);
                                    });
                                    ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)testEntityPreloadPool);
                                    UserProfile userProfile = UserProfileHelper.getCurrentProfile();
                                    userProfile.setDoneCreateFirstProject(true);
                                    UserProfileHelper.saveProfile((UserProfile)userProfile);
                                    ISessionController sessionController = (ISessionController)context.get(ISessionController.class);
                                    LicenseType licenseType = sessionController.getLicenseType();
                                    boolean isFreeLicense = licenseType == null || licenseType == LicenseType.FREE;
                                    project.setFreeLicense(isFreeLicense);
                                }
                                eventBrokerService.post("EXPLORER/RELOAD_INPUT", (Object)TreeEntityUtil.getTreeEntities((ProjectEntity)project, (boolean)false));
                                OpenProjectHandler.showProblemView();
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        }
                    });
                    eventBrokerService.post("GLOBAL_VARIABLE/REFRESH", null);
                    monitor.worked(1);
                    LauncherManager.refresh();
                    eventBrokerService.post("CONSOLE_LOG/RESET", null);
                    monitor.worked(1);
                    TimeUnit.SECONDS.sleep(1L);
                    eventBrokerService.post("PROJECT/OPENED", (Object)project.getFolderLocation());
                    eventBrokerService.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
                    eventBrokerService.post("START_PAGE/RELOAD", null);
                    return;
                }
                catch (Exception e) {
                    syncService.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HAND_ERROR_MSG_CANNOT_OPEN_PROJ, (String)e.getClass().getSimpleName());
                        }
                    });
                    LoggerSingleton.logError((Throwable)e);
                    return;
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private static void prepareEntityReferenceIndex(ProjectEntity project) {
        try {
            String taskName = "Scan files to index entity reference";
            ExecutionTimeTracker.getInstance().start(taskName);
            IFolder testCaseScriptFolder = GroovyUtil.getTestCaseScriptSourceFolder((ProjectEntity)project);
            testCaseScriptFolder.refreshLocal(2, null);
            List testCaseScriptFiles = GroovyUtil.getAllTestCaseScripts((ProjectEntity)project).stream().map(iFile -> iFile.getLocation().toFile()).collect(Collectors.toList());
            IFolder testSuiteFolder = GroovyUtil.getTestSuiteSourceFolder((ProjectEntity)project);
            testSuiteFolder.refreshLocal(2, null);
            List testSuiteScriptFiles = GroovyUtil.getAllTestSuiteScripts((ProjectEntity)project).stream().map(iFile -> iFile.getLocation().toFile()).collect(Collectors.toList());
            List<Object> testSuiteXmlFiles = new ArrayList();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (Stream<Path> paths = Files.walk(Paths.get(testSuiteFolder.getLocation().toOSString(), new String[0]), new FileVisitOption[0]);){
                    testSuiteXmlFiles = paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.toString().endsWith(".ts")).map(Path::toFile).collect(Collectors.toList());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            ArrayList allFiles = new ArrayList(testCaseScriptFiles);
            allFiles.addAll(testSuiteScriptFiles);
            allFiles.addAll(testSuiteXmlFiles);
            ExecutionTimeTracker.getInstance().stop(taskName);
            String taskName2 = "(Re)index entity reference if modified (" + allFiles.size() + " file(s))";
            ExecutionTimeTracker.getInstance().start(taskName2);
            EntityReferenceIndexService.getInstance().prepareIndexForNewlyOpenedProject(allFiles);
            ExecutionTimeTracker.getInstance().stop(taskName2);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to prepare entity reference index");
        }
    }

    private static void preloadTestEntities(ProjectEntity project) {
        FolderController folderController = FolderController.getInstance();
        try {
            String taskName = "Preload test entities when opening project";
            ExecutionTimeTracker.getInstance().start(taskName);
            FolderEntity testObjectFolder = folderController.getObjectRepositoryRoot(project);
            int nTestObjects = folderController.getAllDescentdantEntities(testObjectFolder).size();
            FolderEntity testCaseFolder = folderController.getTestCaseRoot(project);
            int nTestCases = folderController.getAllDescentdantEntities(testCaseFolder).size();
            ExecutionTimeTracker.getInstance().stop(taskName);
            LoggerSingleton.logInfo((String)String.format("Finished preloading %d test object(s) and %d test case(s)", nTestObjects, nTestCases));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to preload test entities");
        }
    }

    public static void showProblemView() {
        EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
        MApplication application = ApplicationSingleton.getInstance().getApplication();
        List psList = modelService.findElements((MUIElement)application, null, MPerspectiveStack.class, null);
        MPartStack consolePartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.console", ((MPerspectiveStack)psList.get(0)).getSelectedElement());
        consolePartStack.getTags().remove("Minimized");
        List children = consolePartStack.getChildren();
        MStackElement problemViewStackElement = null;
        for (MStackElement element : children) {
            if (!element.getElementId().equals("org.eclipse.ui.views.ProblemView")) continue;
            problemViewStackElement = element;
            consolePartStack.setSelectedElement((MUIElement)problemViewStackElement);
            consolePartStack.setVisible(true);
            break;
        }
        if (!consolePartStack.isToBeRendered()) {
            consolePartStack.setToBeRendered(true);
        }
    }

    public static void updateProjectTitle(ProjectEntity projectEntity, EModelService modelService, MApplication app) {
        MWindow win = (MWindow)modelService.find("com.kms.katalon.composer.window.main", (MUIElement)app);
        String versionTag = ApplicationInfo.versionTag();
        if (win != null) {
            win.setLabel(Platform.getProduct().getName() + " - " + (String)(!StringUtils.isBlank((String)versionTag) ? versionTag + " - " : "") + projectEntity.getName() + " - [Location: " + projectEntity.getFolderLocation() + "]");
            win.updateLocalization();
        }
    }

    static /* synthetic */ void access$0(ProjectEntity projectEntity) {
        OpenProjectHandler.prepareEntityReferenceIndex(projectEntity);
    }

    static /* synthetic */ void access$1(ProjectEntity projectEntity) {
        OpenProjectHandler.preloadTestEntities(projectEntity);
    }
}

