/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.preference;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.keyword.ActionProviderFactory;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.keyword.BuiltinKeywords;
import com.kms.katalon.core.keyword.IActionProvider;
import com.kms.katalon.core.keyword.IContext;
import com.kms.katalon.core.keyword.IControlSelectionEventHandler;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.custom.keyword.CustomKeywordSettingPage;
import com.kms.katalon.custom.keyword.KeywordsManifest;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.webui.keyword.Context;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class CustomKeywordPluginPreferencePage
extends PreferencePage {
    private final KeywordsManifest keywordsManifest;
    private static final List<String> acceptedTypes = Arrays.asList("text", "secret", "label", "checkbox", "button", "link");
    private Map<String, Pair<CustomKeywordSettingPage.SettingPageComponent, Control>> componentCollection = new HashMap<String, Pair<CustomKeywordSettingPage.SettingPageComponent, Control>>();
    private ClassLoader classLoader;
    private IActionProvider actionProvider = ActionProviderFactory.getInstance().getActionProvider();

    public CustomKeywordPluginPreferencePage(KeywordsManifest keywordsManifest) {
        this.keywordsManifest = keywordsManifest;
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        try {
            this.classLoader = GroovyUtil.getClassLoaderFromParent((ProjectEntity)projectEntity, (ClassLoader)BuiltinKeywords.class.getClassLoader());
        }
        catch (MalformedURLException | CoreException exception) {
            LoggerSingleton.logError((Throwable)exception);
        }
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 15;
        container.setLayout((Layout)gridLayout);
        for (CustomKeywordSettingPage.SettingPageComponent entry2 : this.keywordsManifest.getConfiguration().getSettingPage().getComponents()) {
            String key = entry2.getKey();
            String type = entry2.getType();
            String label = entry2.getLabel();
            final String defaultValue = entry2.getDefaultValue();
            String link = entry2.getLink();
            if (acceptedTypes.indexOf(type) == -1) continue;
            switch (type) {
                case "text": {
                    Label lblComponentLabel = new Label(container, 0);
                    lblComponentLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                    lblComponentLabel.setText(label);
                    Text txtComponentTextEntry = new Text(container, 2048);
                    txtComponentTextEntry.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    this.componentCollection.put(key, (Pair<CustomKeywordSettingPage.SettingPageComponent, Control>)Pair.of((Object)entry2, (Object)txtComponentTextEntry));
                    break;
                }
                case "secret": {
                    Label lblComponentLabel = new Label(container, 0);
                    lblComponentLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                    lblComponentLabel.setText(label);
                    Text txtComponentSecretEntry = new Text(container, 2048);
                    txtComponentSecretEntry.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    txtComponentSecretEntry.setEchoChar("\u2022".charAt(0));
                    this.componentCollection.put(key, (Pair<CustomKeywordSettingPage.SettingPageComponent, Control>)Pair.of((Object)entry2, (Object)txtComponentSecretEntry));
                    break;
                }
                case "checkbox": {
                    Composite checkboxComposite = new Composite(container, 0);
                    GridLayout checkboxLayout = new GridLayout(2, false);
                    checkboxLayout.marginWidth = 0;
                    checkboxLayout.marginHeight = 0;
                    checkboxLayout.horizontalSpacing = 0;
                    checkboxComposite.setLayout((Layout)checkboxLayout);
                    checkboxComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
                    Button chckComponentCheckboxEntry = new Button(checkboxComposite, 32);
                    chckComponentCheckboxEntry.setText(label);
                    GridData checkboxGridData = new GridData(16384, 0x1000000, true, false);
                    chckComponentCheckboxEntry.setLayoutData((Object)checkboxGridData);
                    if (link != null && !link.isEmpty()) {
                        HelpComposite helpComposite = new HelpComposite(checkboxComposite, link);
                        GridData helpCompositeGridData = new GridData(16384, 0x1000000, false, false);
                        helpCompositeGridData.horizontalIndent = 0;
                        helpComposite.setLayoutData((Object)helpCompositeGridData);
                    }
                    this.componentCollection.put(key, (Pair<CustomKeywordSettingPage.SettingPageComponent, Control>)Pair.of((Object)entry2, (Object)chckComponentCheckboxEntry));
                    break;
                }
                case "label": {
                    Label lblComponentLabelEntry = new Label(container, 0);
                    lblComponentLabelEntry.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                    lblComponentLabelEntry.setText(label);
                    this.componentCollection.put(key, (Pair<CustomKeywordSettingPage.SettingPageComponent, Control>)Pair.of((Object)entry2, (Object)lblComponentLabelEntry));
                    break;
                }
                case "link": {
                    Link linkComponentLinkEntry = new Link(container, 0);
                    linkComponentLinkEntry.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                    linkComponentLinkEntry.setText(label);
                    linkComponentLinkEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Program.launch((String)defaultValue);
                        }
                    });
                    this.componentCollection.put(key, (Pair<CustomKeywordSettingPage.SettingPageComponent, Control>)Pair.of((Object)entry2, (Object)linkComponentLinkEntry));
                }
            }
        }
        this.keywordsManifest.getConfiguration().getSettingPage().getComponents().stream().filter(entry -> entry.getType().equals("button")).forEach(entry -> {
            Button btnOperationExecute = new Button(container, 8);
            btnOperationExecute.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
            btnOperationExecute.setText(entry.getLabel());
            btnOperationExecute.setData((Object)entry.getImplementationClassPath());
            this.reigsterListenerForOperationButton(btnOperationExecute);
        });
        this.setInput();
        return container;
    }

    private void reigsterListenerForOperationButton(final Button btnOperationExecute) {
        btnOperationExecute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomKeywordPluginPreferencePage.this.classLoader != null) {
                    String implementationClassPath = (String)btnOperationExecute.getData();
                    Context context = new Context();
                    context.add("selectedControl", (Object)btnOperationExecute);
                    context.add("pluginName", (Object)CustomKeywordPluginPreferencePage.this.keywordsManifest.getName());
                    context.add("pluginId", (Object)CustomKeywordPluginPreferencePage.this.keywordsManifest.getId());
                    context.add("pluginKeywords", (Object)CustomKeywordPluginPreferencePage.this.keywordsManifest.getKeywords());
                    context.add("pluginListeners", (Object)CustomKeywordPluginPreferencePage.this.keywordsManifest.getListeners());
                    try {
                        Map<String, Object> dataFields = CustomKeywordPluginPreferencePage.this.collectDataFieldsWithoutSaving();
                        Class<?> clazz = CustomKeywordPluginPreferencePage.this.classLoader.loadClass(implementationClassPath);
                        Object pluginRuntimeInstance = clazz.newInstance();
                        if (pluginRuntimeInstance instanceof IControlSelectionEventHandler) {
                            IControlSelectionEventHandler pluginButtonSelectionEventHandler = (IControlSelectionEventHandler)pluginRuntimeInstance;
                            pluginButtonSelectionEventHandler.handle(CustomKeywordPluginPreferencePage.this.actionProvider, dataFields, (IContext)context);
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                        LoggerSingleton.logError((Throwable)exception);
                    }
                }
            }
        });
    }

    protected Map<String, Object> collectDataFieldsWithoutSaving() {
        HashMap<String, Object> dataFields = new HashMap<String, Object>();
        for (Map.Entry<String, Pair<CustomKeywordSettingPage.SettingPageComponent, Control>> componentEntry : this.componentCollection.entrySet()) {
            Control control = (Control)componentEntry.getValue().getRight();
            if (control instanceof Text) {
                dataFields.put(componentEntry.getKey(), ((Text)control).getText());
                continue;
            }
            if (!(control instanceof Button)) continue;
            dataFields.put(componentEntry.getKey(), ((Button)control).getSelection());
        }
        return dataFields;
    }

    private BundleSettingStore getSettingStore() {
        return new BundleSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation(), this.keywordsManifest.getConfiguration().getSettingId(), true);
    }

    private void setInput() {
        BundleSettingStore settingStore = this.getSettingStore();
        for (Map.Entry<String, Pair<CustomKeywordSettingPage.SettingPageComponent, Control>> componentEntry : this.componentCollection.entrySet()) {
            try {
                Object storedValue;
                String key = componentEntry.getKey();
                Control control = (Control)componentEntry.getValue().getRight();
                String defaultString = StringUtils.defaultString((String)((CustomKeywordSettingPage.SettingPageComponent)componentEntry.getValue().getLeft()).getDefaultValue());
                if (control instanceof Text) {
                    storedValue = settingStore.getString(key, defaultString);
                    if (StringUtils.isEmpty((CharSequence)storedValue)) continue;
                    ((Text)control).setText((String)storedValue);
                }
                if (!(control instanceof Button) || (control.getStyle() & 0x20) == 0) continue;
                storedValue = settingStore.getBoolean(key, Boolean.parseBoolean(defaultString));
                ((Button)control).setSelection(((Boolean)storedValue).booleanValue());
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void persistPluginDataFields() {
        BundleSettingStore settingStore = this.getSettingStore();
        for (Map.Entry<String, Pair<CustomKeywordSettingPage.SettingPageComponent, Control>> componentEntry : this.componentCollection.entrySet()) {
            try {
                Control control = (Control)componentEntry.getValue().getRight();
                if (control instanceof Text) {
                    settingStore.setProperty(componentEntry.getKey(), ((Text)control).getText());
                }
                if (!(control instanceof Button) || (control.getStyle() & 0x20) == 0) continue;
                settingStore.setProperty(componentEntry.getKey(), ((Button)control).getSelection());
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    public boolean performOk() {
        if (!this.isControlCreated()) {
            return true;
        }
        this.persistPluginDataFields();
        return true;
    }
}

