/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.views;

import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.views.ResizableProjectPage;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewEmptyProjectPage
extends ResizableProjectPage {
    private static final String DEFAULT_PROJECT_LOCATION = System.getProperty("user.home") + File.separator + StringConstants.APP_NAME;
    private static final int PROJECT_DESC_TEXT_LEFT_MARGIN = 3;
    private static final int PROJECT_DESC_DISPLAY_LINE_NUMBER = 4;
    private Text txtProjectName;
    private Text txtProjectLocation;
    private StyledText txtProjectDescription;
    private ProjectEntity project;
    private Button btnFolderChooser;
    Composite mainContent;

    public NewEmptyProjectPage() {
        super(StringConstants.VIEW_NEW_EMPTY_PROJECT_PAGE_NAME);
        this.setTitle(StringConstants.VIEW_TITLE_NEW_PROJ);
        this.setDescription(StringConstants.VIEW_MSG_PLS_ENTER_PROJ_INFO);
    }

    public void createControl(Composite parent) {
        this.mainContent = new Composite(parent, 0);
        this.mainContent.setLayoutData((Object)new GridData(1808));
        this.mainContent.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(this.mainContent, 0);
        label.setText(StringConstants.VIEW_LBL_NAME);
        this.txtProjectName = new Text(this.mainContent, 2048);
        this.txtProjectName.setLayoutData((Object)new GridData(768));
        label = new Label(this.mainContent, 0);
        label.setText(StringConstants.VIEW_LBL_LOCATION);
        this.createFileChooserComposite(this.mainContent);
        label = new Label(this.mainContent, 0);
        label.setText(StringConstants.VIEW_LBL_DESCRIPTION);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.txtProjectDescription = new StyledText(this.mainContent, 2626);
        if (Platform.getOS().equals("macosx")) {
            GridData layout = new GridData(1808);
            GC graphicContext = new GC((Drawable)this.txtProjectDescription);
            FontMetrics fm = graphicContext.getFontMetrics();
            layout.heightHint = 4 * fm.getHeight();
            this.txtProjectDescription.setLayoutData((Object)layout);
            graphicContext.dispose();
            this.txtProjectDescription.setLeftMargin(3);
        } else {
            this.txtProjectDescription.setLayoutData((Object)new GridData(1808));
        }
        new Label(this.mainContent, 0);
        label = new Label(this.mainContent, 0);
        label.setText(StringConstants.VIEW_LBL_NEW_PROJECT_WIZARD_TIP);
        label.setLayoutData((Object)new GridData(768));
        if (this.project != null) {
            this.txtProjectName.setText(this.project.getName());
            this.txtProjectLocation.setText(this.project.getFolderLocation());
            this.txtProjectDescription.setText(this.project.getDescription());
            this.txtProjectLocation.setEnabled(false);
        }
        this.addControlModifyListeners();
        this.setControl((Control)this.mainContent);
        this.setPageComplete(false);
    }

    private Composite createFileChooserComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout theLayout = new GridLayout(this.project == null ? 2 : 1, false);
        theLayout.marginWidth = 0;
        container.setLayout((Layout)theLayout);
        this.txtProjectLocation = new Text(container, 2048);
        this.txtProjectLocation.setLayoutData((Object)new GridData(768));
        this.txtProjectLocation.setText(DEFAULT_PROJECT_LOCATION);
        if (this.project == null) {
            this.btnFolderChooser = new Button(container, 0x800000);
            this.btnFolderChooser.setText(StringConstants.VIEW_BTN_BROWSE);
        }
        return container;
    }

    private void addControlModifyListeners() {
        this.txtProjectLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEmptyProjectPage.this.checkInput();
            }
        });
        this.txtProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEmptyProjectPage.this.checkInput();
            }
        });
        if (Platform.getOS().equals("macosx")) {
            this.txtProjectName.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    NewEmptyProjectPage.this.checkInput();
                }
            });
        }
        if (Platform.getOS().equals("macosx")) {
            this.txtProjectName.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    String projectName = NewEmptyProjectPage.this.txtProjectName.getText();
                    super.focusLost(e);
                    NewEmptyProjectPage.this.txtProjectName.setText(projectName);
                }
            });
        }
        if (this.btnFolderChooser == null) {
            return;
        }
        this.btnFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(NewEmptyProjectPage.this.btnFolderChooser.getShell());
                dialog.setFilterPath(NewEmptyProjectPage.this.getProjectLocationInput());
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                NewEmptyProjectPage.this.txtProjectLocation.setText(path);
            }
        });
    }

    private void checkInput() {
        this.setErrorMessage(null);
        this.setPageComplete(this.validateProjectFolderLocation() && this.validateProjectName() && this.validateProjectNameDuplication());
    }

    private String getProjectLocationInput() {
        if (this.txtProjectLocation == null || StringUtils.isBlank((String)this.txtProjectLocation.getText())) {
            return "";
        }
        Object projectLocation = this.txtProjectLocation.getText().trim();
        if (!((String)projectLocation).contains(File.separator)) {
            projectLocation = DEFAULT_PROJECT_LOCATION + File.separator + (String)projectLocation;
        }
        return projectLocation;
    }

    private boolean validateProjectFolderLocation() {
        String projectLocation = this.getProjectLocationInput();
        if (StringUtils.isBlank((String)projectLocation)) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_CANNOT_BE_BLANK);
            return false;
        }
        Path folderPath = null;
        try {
            folderPath = Paths.get(projectLocation, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_INVALID);
            return false;
        }
        File folderLocation = folderPath.toFile();
        if (!folderLocation.exists()) {
            return true;
        }
        if (!folderLocation.canRead()) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_NOT_READABLE);
            return false;
        }
        if (!folderLocation.canWrite()) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_NOT_WRITEABLE);
            return false;
        }
        return true;
    }

    private boolean validateProjectName() {
        if (StringUtils.isBlank((String)this.txtProjectName.getText())) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_NAME_CANNOT_BE_BLANK);
            return false;
        }
        return true;
    }

    private boolean validateProjectNameDuplication() {
        String projectLocation = this.getProjectLocationInput();
        String projectName = this.txtProjectName.getText().trim();
        try {
            if (!ProjectController.getInstance().validateNewProjectName(projectLocation, projectName)) {
                this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_NAME_EXISTED_IN_LOC);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
    }

    public String getProjectName() {
        return this.txtProjectName.getText();
    }

    public String getProjectLocation() {
        return this.txtProjectLocation.getText();
    }

    public String getProjectDescription() {
        return this.txtProjectDescription.getText();
    }

    @Override
    public Point getPageSize() {
        return new Point(550, 350);
    }
}

