/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.CharBuffer;

public class CharPointer
extends Pointer {
    public CharPointer(String s2) {
        this(s2.toCharArray().length + 1);
        this.putString(s2);
    }

    public CharPointer(char ... array) {
        this(array.length);
        this.put(array);
    }

    public CharPointer(CharBuffer buffer) {
        super(buffer);
        if (buffer != null && buffer.hasArray()) {
            char[] array = buffer.array();
            this.allocateArray(array.length);
            this.put(array);
            this.position(buffer.position());
        }
    }

    public CharPointer(int size) {
        try {
            this.allocateArray(size);
        }
        catch (UnsatisfiedLinkError e2) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", e2);
        }
    }

    public CharPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public CharPointer position(int position) {
        return (CharPointer)super.position(position);
    }

    public CharPointer capacity(int capacity) {
        return (CharPointer)super.capacity(capacity);
    }

    public char[] getStringChars() {
        char[] newbuffer;
        char[] buffer = new char[16];
        int i2 = 0;
        int j2 = this.position();
        while ((buffer[i2] = this.position(j2).get()) != '\u0000') {
            ++j2;
            if (++i2 < buffer.length) continue;
            newbuffer = new char[2 * buffer.length];
            System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
            buffer = newbuffer;
        }
        newbuffer = new char[i2];
        System.arraycopy(buffer, 0, newbuffer, 0, i2);
        return newbuffer;
    }

    public String getString() {
        return new String(this.getStringChars());
    }

    public CharPointer putString(String s2) {
        char[] chars = s2.toCharArray();
        return this.put(chars).put(chars.length, '\u0000');
    }

    public char get() {
        return this.get(0);
    }

    public native char get(int var1);

    public CharPointer put(char c2) {
        return this.put(0, c2);
    }

    public native CharPointer put(int var1, char var2);

    public CharPointer get(char[] array) {
        return this.get(array, 0, array.length);
    }

    public CharPointer put(char[] array) {
        return this.put(array, 0, array.length);
    }

    public native CharPointer get(char[] var1, int var2, int var3);

    public native CharPointer put(char[] var1, int var2, int var3);

    public final CharBuffer asBuffer() {
        return this.asByteBuffer().asCharBuffer();
    }
}

