/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.DoubleBuffer;

public class DoublePointer
extends Pointer {
    public DoublePointer(double ... array) {
        this(array.length);
        this.put(array);
    }

    public DoublePointer(DoubleBuffer buffer) {
        super(buffer);
        if (buffer != null && buffer.hasArray()) {
            double[] array = buffer.array();
            this.allocateArray(array.length);
            this.put(array);
            this.position(buffer.position());
        }
    }

    public DoublePointer(int size) {
        try {
            this.allocateArray(size);
        }
        catch (UnsatisfiedLinkError e2) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", e2);
        }
    }

    public DoublePointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public DoublePointer position(int position) {
        return (DoublePointer)super.position(position);
    }

    public DoublePointer capacity(int capacity) {
        return (DoublePointer)super.capacity(capacity);
    }

    public double get() {
        return this.get(0);
    }

    public native double get(int var1);

    public DoublePointer put(double d2) {
        return this.put(0, d2);
    }

    public native DoublePointer put(int var1, double var2);

    public DoublePointer get(double[] array) {
        return this.get(array, 0, array.length);
    }

    public DoublePointer put(double[] array) {
        return this.put(array, 0, array.length);
    }

    public native DoublePointer get(double[] var1, int var2, int var3);

    public native DoublePointer put(double[] var1, int var2, int var3);

    public final DoubleBuffer asBuffer() {
        return this.asByteBuffer().asDoubleBuffer();
    }
}

