/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.BaseChildSettings;
import com.googlecode.javacv.CameraDevice;
import com.googlecode.javacv.ColorCalibrator;
import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.MarkedPlane;
import com.googlecode.javacv.Marker;
import com.googlecode.javacv.MarkerDetector;
import com.googlecode.javacv.ProjectorDevice;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.awt.Color;

public class ProCamColorCalibrator {
    private Settings settings;
    private MarkerDetector markerDetector = null;
    private MarkedPlane boardPlane = null;
    private CameraDevice camera = null;
    private ProjectorDevice projector = null;
    private Color[] projectorColors = null;
    private Color[] cameraColors = null;
    private int counter = 0;
    private opencv_core.CvMat boardSrcPts;
    private opencv_core.CvMat boardDstPts;
    private opencv_core.CvMat projSrcPts;
    private opencv_core.CvMat projDstPts;
    private opencv_core.CvMat camKinv;
    private opencv_core.IplImage mask;
    private opencv_core.IplImage mask2;
    private opencv_core.IplImage undistImage;
    private static ThreadLocal<opencv_core.CvMat> H3x3 = opencv_core.CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<opencv_core.CvMat> R3x3 = opencv_core.CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<opencv_core.CvMat> t3x1 = opencv_core.CvMat.createThreadLocal(3, 1);
    private static ThreadLocal<opencv_core.CvMat> n3x1 = opencv_core.CvMat.createThreadLocal(3, 1);
    private static ThreadLocal<opencv_core.CvMat> z3x1 = opencv_core.CvMat.createThreadLocal(3, 1);

    public ProCamColorCalibrator(Settings settings, MarkerDetector.Settings detectorSettings, MarkedPlane boardPlane, CameraDevice camera, ProjectorDevice projector) {
        this.settings = settings;
        this.markerDetector = new MarkerDetector(detectorSettings);
        this.boardPlane = boardPlane;
        this.camera = camera;
        this.projector = projector;
        Marker[] boardMarkers = boardPlane.getMarkers();
        this.boardSrcPts = opencv_core.CvMat.create(4 + boardMarkers.length * 4, 1, 6, 2);
        this.boardDstPts = opencv_core.CvMat.create(4 + boardMarkers.length * 4, 1, 6, 2);
        this.boardSrcPts.put(0.0, 0.0, boardPlane.getWidth(), 0.0, boardPlane.getWidth(), boardPlane.getHeight(), 0.0, boardPlane.getHeight());
        for (int i2 = 0; i2 < boardMarkers.length; ++i2) {
            this.boardSrcPts.put(8 + i2 * 8, boardMarkers[i2].corners);
        }
        this.projSrcPts = opencv_core.CvMat.create(4, 1, 6, 2);
        this.projDstPts = opencv_core.CvMat.create(4, 1, 6, 2);
        this.projSrcPts.put(0.0, 0.0, projector.imageWidth - 1, 0.0, projector.imageWidth - 1, projector.imageHeight - 1, 0.0, projector.imageHeight - 1);
        this.camKinv = opencv_core.CvMat.create(3, 3);
        opencv_core.cvInvert(camera.cameraMatrix, this.camKinv);
    }

    public int getColorCount() {
        return this.counter;
    }

    public Color[] getProjectorColors() {
        double invgamma = 1.0 / this.projector.getSettings().getResponseGamma();
        int s2 = this.settings.samplesPerChannel;
        if (this.projectorColors == null) {
            this.projectorColors = new Color[s2 * s2 * s2];
            this.cameraColors = new Color[s2 * s2 * s2];
            for (int i2 = 0; i2 < this.projectorColors.length; ++i2) {
                int j2 = i2 / s2;
                int k2 = j2 / s2;
                double r = Math.pow((double)(i2 % s2) / (double)(s2 - 1), invgamma);
                double g2 = Math.pow((double)(j2 % s2) / (double)(s2 - 1), invgamma);
                double b2 = Math.pow((double)(k2 % s2) / (double)(s2 - 1), invgamma);
                this.projectorColors[i2] = new Color((float)r, (float)g2, (float)b2);
            }
        }
        return this.projectorColors;
    }

    public Color getProjectorColor() {
        return this.getProjectorColors()[this.counter];
    }

    public Color[] getCameraColors() {
        return this.cameraColors;
    }

    public Color getCameraColor() {
        return this.getCameraColors()[this.counter];
    }

    public void addCameraColor() {
        ++this.counter;
    }

    public void addCameraColor(Color color) {
        this.cameraColors[this.counter++] = color;
    }

    public opencv_core.IplImage getMaskImage() {
        return this.mask;
    }

    public opencv_core.IplImage getUndistortedCameraImage() {
        return this.undistImage;
    }

    public boolean processCameraImage(opencv_core.IplImage cameraImage) {
        if (this.undistImage == null || this.undistImage.width() != cameraImage.width() || this.undistImage.height() != cameraImage.height() || this.undistImage.depth() != cameraImage.depth()) {
            this.undistImage = cameraImage.clone();
        }
        if (this.mask == null || this.mask2 == null || this.mask.width() != cameraImage.width() || this.mask2.width() != cameraImage.width() || this.mask.height() != cameraImage.height() || this.mask2.height() != cameraImage.width()) {
            this.mask = opencv_core.IplImage.create(cameraImage.width(), cameraImage.height(), 8, 1, cameraImage.origin());
            this.mask2 = opencv_core.IplImage.create(cameraImage.width(), cameraImage.height(), 8, 1, cameraImage.origin());
        }
        opencv_core.CvMat H = H3x3.get();
        opencv_core.CvMat R = R3x3.get();
        opencv_core.CvMat t = t3x1.get();
        opencv_core.CvMat n2 = n3x1.get();
        opencv_core.CvMat z = z3x1.get();
        z.put(0.0, 0.0, 1.0);
        this.camera.undistort(cameraImage, this.undistImage);
        Marker[] detectedBoardMarkers = this.markerDetector.detect(this.undistImage, false);
        if ((double)detectedBoardMarkers.length >= (double)this.boardPlane.getMarkers().length * this.settings.detectedBoardMin) {
            int j2;
            this.boardPlane.getTotalWarp(detectedBoardMarkers, H);
            opencv_core.cvPerspectiveTransform(this.boardSrcPts, this.boardDstPts, H);
            double[] boardPts = this.boardDstPts.get();
            opencv_core.cvMatMul(this.camKinv, H, R);
            double error = JavaCV.HnToRt(R, z, R, t);
            opencv_core.cvMatMul(R, z, n2);
            double d2 = opencv_core.cvDotProduct(t, z);
            opencv_core.cvGEMM(this.projector.T, n2, -1.0 / d2, this.projector.R, 1.0, H, 2);
            opencv_core.cvMatMul(this.projector.cameraMatrix, H, H);
            opencv_core.cvMatMul(H, this.camKinv, H);
            opencv_core.cvConvertScale(H, H, 1.0 / H.get(8), 0.0);
            opencv_core.cvInvert(H, H);
            opencv_core.cvConvertScale(H, H, 1.0 / H.get(8), 0.0);
            opencv_core.cvPerspectiveTransform(this.projSrcPts, this.projDstPts, H);
            double[] projPts = this.projDstPts.get();
            opencv_core.cvSetZero(this.mask);
            double cx = 0.0;
            double cy = 0.0;
            for (j2 = 0; j2 < 4; ++j2) {
                cx += boardPts[j2 * 2];
                cy += boardPts[j2 * 2 + 1];
            }
            cx /= 4.0;
            cy /= 4.0;
            for (j2 = 0; j2 < 4; ++j2) {
                int n3 = j2 * 2;
                boardPts[n3] = boardPts[n3] - (boardPts[j2 * 2] - cx) * this.settings.trimmingFraction;
                int n4 = j2 * 2 + 1;
                boardPts[n4] = boardPts[n4] - (boardPts[j2 * 2 + 1] - cy) * this.settings.trimmingFraction;
            }
            opencv_core.cvFillConvexPoly((opencv_core.CvArr)this.mask, new opencv_core.CvPoint(16, boardPts, 0, 8), 4, opencv_core.CvScalar.WHITE, 8, 16);
            for (j2 = 0; j2 < (boardPts.length - 8) / 8; ++j2) {
                opencv_core.cvFillConvexPoly((opencv_core.CvArr)this.mask, new opencv_core.CvPoint(16, boardPts, 8 + j2 * 8, 8), 4, opencv_core.CvScalar.BLACK, 8, 16);
            }
            opencv_core.cvSetZero(this.mask2);
            cx = 0.0;
            cy = 0.0;
            for (j2 = 0; j2 < 4; ++j2) {
                cx += projPts[j2 * 2];
                cy += projPts[j2 * 2 + 1];
            }
            cx /= 4.0;
            cy /= 4.0;
            for (j2 = 0; j2 < 4; ++j2) {
                int n5 = j2 * 2;
                projPts[n5] = projPts[n5] - (projPts[j2 * 2] - cx) * this.settings.trimmingFraction;
                int n6 = j2 * 2 + 1;
                projPts[n6] = projPts[n6] - (projPts[j2 * 2 + 1] - cy) * this.settings.trimmingFraction;
            }
            opencv_core.cvFillConvexPoly((opencv_core.CvArr)this.mask2, new opencv_core.CvPoint(16, projPts, 0, 8), 4, opencv_core.CvScalar.WHITE, 8, 16);
            opencv_core.cvAnd(this.mask, this.mask2, this.mask, null);
            opencv_imgproc.cvErode(this.mask, this.mask, null, 1);
            opencv_core.CvScalar c2 = opencv_core.cvAvg(this.undistImage, this.mask);
            int[] o2 = this.camera.getRGBColorOrder();
            double s2 = cameraImage.highValue();
            this.cameraColors[this.counter] = new Color((float)(c2.val(o2[0]) / s2), (float)(c2.val(o2[1]) / s2), (float)(c2.val(o2[2]) / s2));
            return true;
        }
        return false;
    }

    public double calibrate() {
        Color[] cc = this.getCameraColors();
        Color[] pc = this.getProjectorColors();
        assert (this.counter == pc.length);
        ColorCalibrator calibrator = new ColorCalibrator(this.projector);
        this.projector.avgColorErr = calibrator.calibrate(cc, pc);
        this.camera.colorMixingMatrix = opencv_core.CvMat.create(3, 3);
        this.camera.additiveLight = opencv_core.CvMat.create(3, 1);
        opencv_core.cvSetIdentity(this.camera.colorMixingMatrix);
        opencv_core.cvSetZero(this.camera.additiveLight);
        this.counter = 0;
        return this.projector.avgColorErr;
    }

    public static class Settings
    extends BaseChildSettings {
        int samplesPerChannel = 4;
        double trimmingFraction = 0.01;
        double detectedBoardMin = 0.5;

        public int getSamplesPerChannel() {
            return this.samplesPerChannel;
        }

        public void setSamplesPerChannel(int samplesPerChannel) {
            this.samplesPerChannel = samplesPerChannel;
        }

        public double getDetectedBoardMin() {
            return this.detectedBoardMin;
        }

        public void setDetectedBoardMin(double detectedBoardMin) {
            this.detectedBoardMin = detectedBoardMin;
        }
    }
}

