/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public class PlasticToolBarUI
extends MetalToolBarUI {
    private static final String PROPERTY_PREFIX = "ToolBar.";
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent b2) {
        return new PlasticToolBarUI();
    }

    protected Border createRolloverBorder() {
        return PlasticBorders.getRolloverButtonBorder();
    }

    protected void setBorderToRollover(Component c2) {
        if (c2 instanceof AbstractButton) {
            super.setBorderToRollover(c2);
        } else if (c2 instanceof Container) {
            Container cont = (Container)c2;
            for (int i2 = 0; i2 < cont.getComponentCount(); ++i2) {
                super.setBorderToRollover(cont.getComponent(i2));
            }
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    protected void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.toolBar.addPropertyChangeListener(this.listener);
    }

    protected void uninstallListeners() {
        this.toolBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e2) {
                String prop = e2.getPropertyName();
                if (prop.equals("jgoodies.headerStyle") || prop.equals("Plastic.borderStyle")) {
                    PlasticToolBarUI.this.installSpecialBorder();
                }
            }
        };
    }

    private void installSpecialBorder() {
        HeaderStyle headerStyle;
        BorderStyle borderStyle = BorderStyle.from(this.toolBar, "Plastic.borderStyle");
        String suffix = borderStyle == BorderStyle.EMPTY ? "emptyBorder" : (borderStyle == BorderStyle.ETCHED ? "etchedBorder" : (borderStyle == BorderStyle.SEPARATOR ? "separatorBorder" : ((headerStyle = HeaderStyle.from(this.toolBar)) == HeaderStyle.BOTH ? "headerBorder" : (headerStyle == HeaderStyle.SINGLE && this.is3D() ? "etchedBorder" : "border"))));
        LookAndFeel.installBorder(this.toolBar, PROPERTY_PREFIX + suffix);
    }

    public void update(Graphics g2, JComponent c2) {
        if (c2.isOpaque()) {
            g2.setColor(c2.getBackground());
            g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
            if (this.is3D()) {
                Rectangle bounds = new Rectangle(0, 0, c2.getWidth(), c2.getHeight());
                boolean isHorizontal = ((JToolBar)c2).getOrientation() == 0;
                PlasticUtils.addLight3DEffekt(g2, bounds, isHorizontal);
            }
        }
        this.paint(g2, c2);
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.toolBar)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.toolBar)) {
            return false;
        }
        return PlasticUtils.is3D(PROPERTY_PREFIX) && HeaderStyle.from(this.toolBar) != null && BorderStyle.from(this.toolBar, "Plastic.borderStyle") != BorderStyle.EMPTY;
    }
}

