/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.Log;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.RTPPacketSender;
import com.sun.media.rtp.util.UDPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.SessionAddress;

public class RTPRawSender
extends PacketFilter {
    private InetAddress destaddr;
    private int destport;
    private DatagramSocket socket = null;
    private RTPConnector rtpConnector = null;

    public String filtername() {
        return "RTP Raw Packet Sender";
    }

    public RTPRawSender(int port, String address) throws UnknownHostException, IOException {
        this.destaddr = InetAddress.getByName(address);
        this.destport = port;
        this.destAddressList = null;
    }

    public RTPRawSender(int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(port, address);
        this.socket = sender.getSocket();
        this.setConsumer(sender);
        this.destAddressList = null;
    }

    public RTPRawSender(RTPPacketSender sender) {
        this.rtpConnector = sender.getConnector();
        this.setConsumer(sender);
    }

    public InetAddress getRemoteAddr() {
        return this.destaddr;
    }

    public void setSendBufSize(int size) {
        try {
            if (this.socket != null) {
                Class<?> cls = this.socket.getClass();
                Method m3 = cls.getMethod("setSendBufferSize", Integer.TYPE);
                m3.invoke((Object)this.socket, new Integer(size));
            } else if (this.rtpConnector != null) {
                this.rtpConnector.setSendBufferSize(size);
            }
        }
        catch (Exception e2) {
            Log.comment("Cannot set send buffer size: " + e2);
        }
    }

    public int getSendBufSize() {
        try {
            if (this.socket != null) {
                Class<?> cls = this.socket.getClass();
                Method m3 = cls.getMethod("getSendBufferSize", null);
                Integer res = (Integer)m3.invoke((Object)this.socket, null);
                return res;
            }
            if (this.rtpConnector != null) {
                return this.rtpConnector.getSendBufferSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public Packet handlePacket(Packet p, int i2) {
        return null;
    }

    public Packet handlePacket(Packet p, SessionAddress sessionAddress) {
        this.assemble((RTPPacket)p);
        PacketConsumer consumer = this.getConsumer();
        if (consumer instanceof RTPPacketSender) {
            return p;
        }
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p.data;
        udpp.offset = p.offset;
        udpp.length = p.length;
        udpp.remoteAddress = sessionAddress.getDataAddress();
        udpp.remotePort = sessionAddress.getDataPort();
        return udpp;
    }

    public Packet handlePacket(Packet p) {
        this.assemble((RTPPacket)p);
        PacketConsumer consumer = this.getConsumer();
        if (consumer instanceof RTPPacketSender) {
            return p;
        }
        UDPPacket udpp = new UDPPacket();
        udpp.received = false;
        udpp.data = p.data;
        udpp.offset = p.offset;
        udpp.length = p.length;
        udpp.remoteAddress = this.destaddr;
        udpp.remotePort = this.destport;
        return udpp;
    }

    public void assemble(RTPPacket p) {
        int len = p.calcLength();
        p.assemble(len, false);
    }

    public void setDestAddresses(Vector destAddresses) {
        this.destAddressList = destAddresses;
    }
}

