/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.BufferControlImpl;
import com.sun.media.rtp.FormatInfo;
import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.OverallTransStats;
import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTCPRawReceiver;
import com.sun.media.rtp.RTCPRawSender;
import com.sun.media.rtp.RTCPReceiver;
import com.sun.media.rtp.RTCPReporter;
import com.sun.media.rtp.RTCPTransmitter;
import com.sun.media.rtp.RTPControlImpl;
import com.sun.media.rtp.RTPDemultiplexer;
import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPRawReceiver;
import com.sun.media.rtp.RTPRawSender;
import com.sun.media.rtp.RTPReceiver;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RTPSourceInfoCache;
import com.sun.media.rtp.RTPSourceStream;
import com.sun.media.rtp.RTPTransmitter;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCCacheCleaner;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.TrueRandom;
import com.sun.media.rtp.util.PacketForwarder;
import com.sun.media.rtp.util.RTPPacketSender;
import com.sun.media.rtp.util.SSRCTable;
import com.sun.media.rtp.util.UDPPacketSender;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12InetAddressAction;
import com.sun.media.util.jdk12PropertyAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.RemoteParticipant;
import javax.media.rtp.SSRCInUseException;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.SessionManagerException;
import javax.media.rtp.event.NewSendStreamEvent;
import javax.media.rtp.event.StreamClosedEvent;
import javax.media.rtp.rtcp.SourceDescription;

public class RTPSessionMgr
extends RTPManager
implements SessionManager {
    boolean bindtome = false;
    private SSRCCache cache = null;
    int ttl;
    int sendercount = 0;
    InetAddress localDataAddress = null;
    int localDataPort = 0;
    InetAddress localControlAddress = null;
    int localControlPort = 0;
    InetAddress dataaddress = null;
    InetAddress controladdress = null;
    int dataport = 0;
    int controlport = 0;
    RTPPushDataSource rtpsource = null;
    RTPPushDataSource rtcpsource = null;
    long defaultSSRC = 0L;
    SessionAddress localSenderAddress;
    private SessionAddress localReceiverAddress;
    UDPPacketSender udpsender = null;
    RTPPacketSender rtpsender = null;
    RTCPRawSender sender = null;
    SSRCCacheCleaner cleaner = null;
    private boolean unicast = false;
    private boolean startedparticipating = false;
    private boolean nonparticipating = false;
    private boolean nosockets = false;
    private boolean started = false;
    private boolean initialized = false;
    protected Vector sessionlistener = new Vector();
    protected Vector remotelistener = new Vector();
    protected Vector streamlistener = new Vector();
    protected Vector sendstreamlistener = new Vector();
    private static final int GET_ALL_PARTICIPANTS = -1;
    boolean encryption = false;
    SSRCTable dslist = new SSRCTable();
    StreamSynch streamSynch;
    FormatInfo formatinfo = null;
    com.sun.media.protocol.rtp.DataSource defaultsource = null;
    PushBufferStream defaultstream = null;
    Format defaultformat = null;
    BufferControl buffercontrol = null;
    OverallStats defaultstats = null;
    OverallTransStats transstats = null;
    int defaultsourceid = 0;
    Vector sendstreamlist = new Vector(1);
    RTPTransmitter rtpTransmitter = null;
    boolean bds = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    Vector peerlist = new Vector();
    boolean multi_unicast = false;
    Hashtable peerrtplist = new Hashtable(5);
    Hashtable peerrtcplist = new Hashtable(5);
    static FormatInfo supportedList;
    static Vector addedList;
    private boolean newRtpInterface = false;
    private SessionAddress remoteAddress;
    private SessionAddress localAddress;
    private RTCPRawReceiver rtcpRawReceiver;
    private RTPRawReceiver rtpRawReceiver;
    private PacketForwarder rtpForwarder;
    private PacketForwarder rtcpForwarder;
    private RTPDemultiplexer rtpDemultiplexer;
    private OverallStats overallStats;
    private boolean participating;
    private UDPPacketSender udpPacketSender;
    private Vector remoteAddresses;
    private RTCPTransmitter rtcpTransmitter;
    private RTPConnector rtpConnector;
    private DatagramSocket dataSocket;
    private DatagramSocket controlSocket;
    private final int MAX_PORT = 65535;

    public RTPSessionMgr() {
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        this.streamSynch = new StreamSynch();
    }

    public Object[] getControls() {
        Object[] c2 = new Object[]{this.buffercontrol};
        return c2;
    }

    public Object getControl(String controlname) {
        if (controlname.equals("javax.media.control.BufferControl")) {
            return this.buffercontrol;
        }
        return null;
    }

    public int initSession(SessionAddress localAddress, long defaultSSRC, SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) throws InvalidSessionAddressException {
        InetAddress host;
        if (this.initialized) {
            return -1;
        }
        if (rtcp_bw_fraction == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = defaultSSRC;
        this.localDataAddress = localAddress.getDataAddress();
        this.localControlAddress = localAddress.getControlAddress();
        this.localDataPort = localAddress.getDataPort();
        this.localControlPort = localAddress.getControlPort();
        InetAddress[] addrlist = null;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            String hostname;
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12InetAddressAction.cons;
                host = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getLocalHost", null));
                hostname = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(host, "getHostName", null));
                addrlist = (InetAddress[])jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getAllByName", hostname));
            } else {
                host = InetAddress.getLocalHost();
                hostname = host.getHostName();
                addrlist = InetAddress.getAllByName(hostname);
            }
        }
        catch (Throwable e3) {
            System.err.println("InitSession : UnknownHostExcpetion " + e3.getMessage());
            e3.printStackTrace();
            return -1;
        }
        if (this.localDataAddress == null) {
            this.localDataAddress = host;
        }
        if (this.localControlAddress == null) {
            this.localControlAddress = host;
        }
        boolean dataok = false;
        boolean ctlok = false;
        int i2 = 0;
        while (!(i2 >= addrlist.length || dataok && ctlok)) {
            if (addrlist[i2].equals(this.localDataAddress)) {
                dataok = true;
            }
            if (addrlist[i2].equals(this.localControlAddress)) {
                ctlok = true;
            }
            ++i2;
        }
        String s2 = "Does not belong to any of this hosts local interfaces";
        if (!dataok) {
            throw new InvalidSessionAddressException("Local Data Address" + s2);
        }
        if (!ctlok) {
            throw new InvalidSessionAddressException("Local Control Address" + s2);
        }
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = rtcp_bw_fraction;
        this.cache.rtcp_sender_bw_fraction = rtcp_sender_bw_fraction;
        this.cache.ourssrc = this.cache.get((int)defaultSSRC, host, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(defaultUserDesc)) {
            SourceDescription[] newUserDesc = this.setCNAME(defaultUserDesc);
            this.cache.ourssrc.setSourceDescription(newUserDesc);
        } else {
            this.cache.ourssrc.setSourceDescription(defaultUserDesc);
        }
        this.cache.ourssrc.ssrc = (int)defaultSSRC;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    public int initSession(SessionAddress localAddress, SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) throws InvalidSessionAddressException {
        long defaultSSRC = this.generateSSRC();
        return this.initSession(localAddress, defaultSSRC, defaultUserDesc, rtcp_bw_fraction, rtcp_sender_bw_fraction);
    }

    public int startSession(SessionAddress destAddress, int mcastScope, EncryptionInfo encryptionInfo) throws IOException, InvalidSessionAddressException {
        RTPRawReceiver rtpr;
        RTCPRawReceiver rtcpr;
        block32: {
            if (this.started) {
                return -1;
            }
            if (mcastScope < 1) {
                mcastScope = 1;
            }
            this.ttl = mcastScope;
            this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
            this.controlport = destAddress.getControlPort();
            this.dataport = destAddress.getDataPort();
            this.CheckRTPPorts(this.dataport, this.controlport);
            this.dataaddress = destAddress.getDataAddress();
            this.controladdress = destAddress.getControlAddress();
            if (jmfSecurity != null) {
                String permission = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        permission = "read property";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        permission = "connect";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable e2) {
                    if (permission.startsWith("read")) {
                        jmfSecurity.permissionFailureNotification(1);
                    }
                    jmfSecurity.permissionFailureNotification(128);
                }
            }
            this.CheckRTPAddress(this.dataaddress, this.controladdress);
            rtcpr = null;
            rtpr = null;
            InetAddress mine = null;
            try {
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    Constructor cons = jdk12InetAddressAction.cons;
                    mine = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getLocalHost", null));
                } else {
                    mine = InetAddress.getLocalHost();
                }
            }
            catch (Throwable e3) {
                System.err.println("InitSession : UnknownHostExcpetion " + e3.getMessage());
                e3.printStackTrace();
                return -1;
            }
            if (this.dataaddress.equals(mine)) {
                this.unicast = true;
            }
            if (!this.dataaddress.isMulticastAddress() && !this.dataaddress.equals(mine)) {
                this.bindtome = !this.isBroadcast(this.dataaddress) || this.Win32();
            }
            if (!this.bindtome) {
                try {
                    block31: {
                        try {
                            rtcpr = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats, this.streamSynch);
                            if (this.dataaddress == null) break block31;
                            rtpr = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
                        }
                        catch (SocketException e4) {
                            throw new IOException(e4.getMessage());
                        }
                    }
                    Object var9_12 = null;
                    if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                        System.err.println("could not create RTCP/RTP raw receivers");
                        rtcpr.closeSource();
                    }
                    break block32;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                        System.err.println("could not create RTCP/RTP raw receivers");
                        rtcpr.closeSource();
                    }
                    throw throwable;
                }
            }
            try {
                block33: {
                    try {
                        rtcpr = new RTCPRawReceiver(this.controlport, mine.getHostAddress(), this.defaultstats, this.streamSynch);
                        if (this.dataaddress == null) break block33;
                        rtpr = new RTPRawReceiver(this.dataport, mine.getHostAddress(), this.defaultstats);
                    }
                    catch (SocketException e5) {
                        throw new IOException(e5.getMessage());
                    }
                }
                Object var11_15 = null;
                if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
                throw throwable;
            }
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rtpr, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(rtcpr, new RTCPReceiver(this.cache));
        if (rtpr != null) {
            this.rtpForwarder = new PacketForwarder(rtpr, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(this.controlport, this.dataaddress.getHostAddress(), this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    public int startSession(SessionAddress localDestAddress, SessionAddress localSenderAddress, SessionAddress remoteDestAddress, EncryptionInfo encryptionInfo) throws IOException, InvalidSessionAddressException {
        if (this.started) {
            return -1;
        }
        this.localSenderAddress = localSenderAddress;
        this.cache.sessionbandwidth = 384000;
        this.controlport = localDestAddress.getControlPort();
        this.dataport = localDestAddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = localDestAddress.getDataAddress();
        this.controladdress = localDestAddress.getControlAddress();
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "read property";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "connect";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                if (permission.startsWith("read")) {
                    jmfSecurity.permissionFailureNotification(1);
                }
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Local Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        RTCPRawReceiver rtcpr = null;
        RTPRawReceiver rtpr = null;
        InetAddress mine = null;
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12InetAddressAction.cons;
                mine = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getLocalHost", null));
            } else {
                mine = InetAddress.getLocalHost();
            }
        }
        catch (Throwable e3) {
            System.err.println("InitSession : UnknownHostExcpetion " + e3.getMessage());
            e3.printStackTrace();
            return -1;
        }
        try {
            block23: {
                try {
                    rtcpr = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats, this.streamSynch);
                    if (this.dataaddress == null) break block23;
                    rtpr = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
                }
                catch (SocketException e4) {
                    throw new IOException(e4.getMessage());
                }
            }
            Object var10_12 = null;
            if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                System.err.println("could not create RTCP/RTP raw receivers");
                rtcpr.closeSource();
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                System.err.println("could not create RTCP/RTP raw receivers");
                rtcpr.closeSource();
            }
            throw throwable;
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rtpr, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(rtcpr, new RTCPReceiver(this.cache));
        if (rtpr != null) {
            this.rtpForwarder = new PacketForwarder(rtpr, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.controlport = remoteDestAddress.getControlPort();
        this.dataport = remoteDestAddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = remoteDestAddress.getDataAddress();
        this.controladdress = remoteDestAddress.getControlAddress();
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Remote Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(localDestAddress, localSenderAddress, this.cache.ourssrc, rtcpr.socket);
        }
        this.started = true;
        return 0;
    }

    public void addSessionListener(SessionListener listener) {
        if (!this.sessionlistener.contains(listener)) {
            this.sessionlistener.addElement(listener);
        }
    }

    public void addRemoteListener(RemoteListener listener) {
        if (!this.remotelistener.contains(listener)) {
            this.remotelistener.addElement(listener);
        }
    }

    public void addReceiveStreamListener(ReceiveStreamListener listener) {
        if (!this.streamlistener.contains(listener)) {
            this.streamlistener.addElement(listener);
        }
    }

    public void addSendStreamListener(SendStreamListener listener) {
        if (!this.sendstreamlistener.contains(listener)) {
            this.sendstreamlistener.addElement(listener);
        }
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionlistener.removeElement(listener);
    }

    public void removeRemoteListener(RemoteListener listener) {
        this.remotelistener.removeElement(listener);
    }

    public void removeReceiveStreamListener(ReceiveStreamListener listener) {
        this.streamlistener.removeElement(listener);
    }

    public void removeSendStreamListener(SendStreamListener listener) {
    }

    public long getDefaultSSRC() {
        return this.defaultSSRC;
    }

    public Vector getRemoteParticipants() {
        Vector<Participant> participantlist = new Vector<Participant>();
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Participant participant = (Participant)elements.nextElement();
            if (participant == null || !(participant instanceof RemoteParticipant)) continue;
            participantlist.addElement(participant);
        }
        return participantlist;
    }

    public Vector getActiveParticipants() {
        Vector<Participant> participantlist = new Vector<Participant>();
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Vector streams;
            Participant participant = (Participant)elements.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (streams = participant.getStreams()).size() <= 0) continue;
            participantlist.addElement(participant);
        }
        return participantlist;
    }

    public Vector getPassiveParticipants() {
        Vector<Participant> participantlist = new Vector<Participant>();
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Vector streams;
            Participant participant = (Participant)elements.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (streams = participant.getStreams()).size() != 0) continue;
            participantlist.addElement(participant);
        }
        return participantlist;
    }

    public LocalParticipant getLocalParticipant() {
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Participant participant = (Participant)elements.nextElement();
            if (participant == null || this.nonparticipating || !(participant instanceof LocalParticipant)) continue;
            return (LocalParticipant)participant;
        }
        return null;
    }

    public Vector getAllParticipants() {
        Vector<Participant> participantlist = new Vector<Participant>();
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Participant participant = (Participant)elements.nextElement();
            if (participant == null || participant instanceof LocalParticipant && this.nonparticipating) continue;
            participantlist.addElement(participant);
        }
        return participantlist;
    }

    public Vector getReceiveStreams() {
        Vector<RTPStream> smstreamlist = new Vector<RTPStream>();
        Vector participantlist = this.getAllParticipants();
        int i2 = 0;
        while (i2 < participantlist.size()) {
            Participant part = (Participant)participantlist.elementAt(i2);
            Vector partstreams = part.getStreams();
            int j2 = 0;
            while (j2 < partstreams.size()) {
                RTPStream stream = (RTPStream)partstreams.elementAt(j2);
                if (stream instanceof ReceiveStream) {
                    smstreamlist.addElement(stream);
                }
                ++j2;
            }
            ++i2;
        }
        smstreamlist.trimToSize();
        return smstreamlist;
    }

    public Vector getSendStreams() {
        return null;
    }

    public RTPStream getStream(long filterssrc) {
        Vector participantlist = null;
        participantlist = this.getAllParticipants();
        if (participantlist == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < participantlist.size()) {
            RTPSourceInfo si = (RTPSourceInfo)participantlist.elementAt(i2);
            RTPStream stream = si.getSSRCStream(filterssrc);
            if (stream != null) {
                return stream;
            }
            ++i2;
        }
        return null;
    }

    public int getMulticastScope() {
        return this.ttl;
    }

    public void setMulticastScope(int multicastScope) {
        if (multicastScope < 1) {
            multicastScope = 1;
        }
        this.ttl = multicastScope;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        if (this.udpsender != null) {
            try {
                this.udpsender.setttl(this.ttl);
            }
            catch (IOException e2) {
                System.err.println("setMulticastScope Exception " + e2.getMessage());
                e2.printStackTrace();
            }
        }
    }

    public void closeSession(String reason) {
        this.stopParticipating(reason, this.cache.ourssrc);
        if (this.defaultsource != null) {
            this.defaultsource.disconnect();
        }
        if (this.cache != null) {
            Enumeration e2 = this.cache.cache.elements();
            while (e2.hasMoreElements()) {
                SSRCInfo s2 = (SSRCInfo)e2.nextElement();
                if (s2.dstream != null) {
                    s2.dstream.close();
                }
                if (s2 instanceof SendSSRCInfo) {
                    ((SendSSRCInfo)s2).close();
                }
                this.stopParticipating(reason, s2);
            }
        }
        int i2 = 0;
        while (i2 < this.sendstreamlist.size()) {
            this.removeSendStream((SendStream)this.sendstreamlist.elementAt(i2));
            ++i2;
        }
        if (this.rtpTransmitter != null) {
            this.rtpTransmitter.close();
        }
        if (this.rtcpForwarder != null) {
            RTCPRawReceiver rtcpr = (RTCPRawReceiver)this.rtcpForwarder.getSource();
            this.rtcpForwarder.close();
            if (rtcpr != null) {
                rtcpr.close();
            }
        }
        if (this.cleaner != null) {
            this.cleaner.stop();
        }
        if (this.cache != null) {
            this.cache.destroy();
        }
        if (this.rtpForwarder != null) {
            RTPRawReceiver rtpr = (RTPRawReceiver)this.rtpForwarder.getSource();
            this.rtpForwarder.close();
            if (rtpr != null) {
                rtpr.close();
            }
        }
        if (this.multi_unicast) {
            this.removeAllPeers();
        }
    }

    public String generateCNAME() {
        return SourceDescription.generateCNAME();
    }

    public long generateSSRC() {
        long ssrc = TrueRandom.rand();
        return ssrc;
    }

    public SessionAddress getSessionAddress() {
        SessionAddress destAddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        return destAddress;
    }

    public SessionAddress getLocalSessionAddress() {
        if (this.newRtpInterface) {
            return this.localAddress;
        }
        SessionAddress localAddr = new SessionAddress(this.localDataAddress, this.localDataPort, this.localControlAddress, this.localControlPort);
        return localAddr;
    }

    public SessionAddress getLocalReceiverAddress() {
        return this.localReceiverAddress;
    }

    public GlobalReceptionStats getGlobalReceptionStats() {
        return this.defaultstats;
    }

    public GlobalTransmissionStats getGlobalTransmissionStats() {
        return this.transstats;
    }

    public void addFormat(Format info, int payload) {
        if (this.formatinfo != null) {
            this.formatinfo.add(payload, info);
        }
        if (info != null) {
            addedList.addElement(info);
        }
    }

    public static boolean formatSupported(Format format) {
        if (supportedList == null) {
            supportedList = new FormatInfo();
        }
        if (supportedList.getPayload(format) != -1) {
            return true;
        }
        int i2 = 0;
        while (i2 < addedList.size()) {
            Format fmt = (Format)addedList.elementAt(i2);
            if (fmt.matches(format)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public SendStream createSendStream(int ssrc, DataSource ds, int streamindex) throws UnsupportedFormatException, IOException, SSRCInUseException {
        SSRCInfo i2 = this.cache.lookup(ssrc);
        if (i2 != null) {
            throw new SSRCInUseException("SSRC supplied is already in use");
        }
        int newSSRC = ssrc;
        if (this.cache.rtcp_bw_fraction == 0.0) {
            throw new IOException("Initialized with zero RTP/RTCP outgoing bandwidth. Cannot create a sending stream ");
        }
        PushBufferStream[] streams = ((PushBufferDataSource)ds).getStreams();
        PushBufferStream sendstream = streams[streamindex];
        Format fmt = sendstream.getFormat();
        int payload = this.formatinfo.getPayload(fmt);
        if (payload == -1) {
            throw new UnsupportedFormatException("Format of Stream not supported in RTP Session Manager", fmt);
        }
        SSRCInfo info = null;
        if (this.sendercount == 0) {
            info = new SendSSRCInfo(this.cache.ourssrc);
            info.ours = true;
            this.cache.ourssrc = info;
            this.cache.getMainCache().put(info.ssrc, info);
        } else {
            info = this.cache.get(newSSRC, this.dataaddress, this.dataport, 3);
            info.ours = true;
            info.reporter = !this.nosockets ? this.startParticipating(this.controlport, this.controladdress.getHostAddress(), info) : this.startParticipating(this.rtcpsource, info);
        }
        info.payloadType = payload;
        info.sinkstream.setSSRCInfo((SendSSRCInfo)info);
        ((SendSSRCInfo)info).setFormat(fmt);
        if (fmt instanceof VideoFormat) {
            info.clockrate = 90000;
        } else if (fmt instanceof AudioFormat) {
            info.clockrate = (int)((AudioFormat)fmt).getSampleRate();
        } else {
            throw new UnsupportedFormatException("Format not supported", fmt);
        }
        info.pds = ds;
        sendstream.setTransferHandler(info.sinkstream);
        if (this.multi_unicast) {
            if (this.peerlist.size() > 0) {
                SessionAddress a2 = (SessionAddress)this.peerlist.firstElement();
                this.dataport = a2.getDataPort();
                this.dataaddress = a2.getDataAddress();
            } else {
                throw new IOException("At least one peer must be added");
            }
        }
        if (this.rtpTransmitter == null) {
            if (this.rtpConnector != null) {
                this.rtpTransmitter = this.startDataTransmission(this.rtpConnector);
            } else if (this.nosockets) {
                this.rtpTransmitter = this.startDataTransmission(this.rtpsource);
            } else {
                if (this.newRtpInterface) {
                    this.dataport = this.remoteAddress.getDataPort();
                    this.dataaddress = this.remoteAddress.getDataAddress();
                }
                this.rtpTransmitter = this.startDataTransmission(this.dataport, this.dataaddress.getHostAddress());
            }
            if (this.rtpTransmitter == null) {
                throw new IOException("Cannot create a transmitter");
            }
        }
        info.sinkstream.setTransmitter(this.rtpTransmitter);
        this.addSendStream((SendStream)((Object)info));
        if (this.multi_unicast) {
            int j2 = 0;
            while (j2 < this.peerlist.size()) {
                SessionAddress peerAddress = (SessionAddress)this.peerlist.elementAt(j2);
                if (info.sinkstream.transmitter.sender.peerlist == null) {
                    info.sinkstream.transmitter.sender.peerlist = new Vector();
                }
                info.sinkstream.transmitter.sender.peerlist.addElement(peerAddress);
                if (this.cache != null) {
                    Enumeration e2 = this.cache.cache.elements();
                    while (e2.hasMoreElements()) {
                        SSRCInfo s2 = (SSRCInfo)e2.nextElement();
                        if (!(s2 instanceof SendSSRCInfo)) continue;
                        s2.reporter.transmit.sender.control = true;
                        if (s2.reporter.transmit.sender.peerlist == null) {
                            s2.reporter.transmit.sender.peerlist = new Vector();
                        }
                        s2.reporter.transmit.sender.peerlist.addElement(peerAddress);
                    }
                }
                ++j2;
            }
        }
        info.sinkstream.startStream();
        NewSendStreamEvent evt = new NewSendStreamEvent(this, (SendStream)((Object)info));
        this.cache.eventhandler.postEvent(evt);
        return (SendStream)((Object)info);
    }

    public SSRCInfo getSSRCInfo(int ssrc) {
        SSRCInfo info = this.cache.lookup(ssrc);
        return info;
    }

    public SendStream createSendStream(DataSource ds, int streamindex) throws IOException, UnsupportedFormatException {
        int newSSRC = 0;
        while (this.cache.lookup(newSSRC = (int)this.generateSSRC()) != null) {
        }
        SendStream s2 = null;
        try {
            s2 = this.createSendStream(newSSRC, ds, streamindex);
            if (this.newRtpInterface) {
                this.setRemoteAddresses();
            }
        }
        catch (SSRCInUseException e2) {
            // empty catch block
        }
        return s2;
    }

    public int startSession(int mcastScope, EncryptionInfo encryptionInfo) throws IOException {
        this.multi_unicast = true;
        if (mcastScope < 1) {
            mcastScope = 1;
        }
        this.ttl = mcastScope;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        return 0;
    }

    public void addPeer(SessionAddress peerAddress) throws IOException, InvalidSessionAddressException {
        int controlp;
        int datap;
        InetAddress controladd;
        InetAddress dataadd;
        RTPRawReceiver rtpr;
        RTCPRawReceiver rtcpr;
        block37: {
            int i2 = 0;
            while (i2 < this.peerlist.size()) {
                SessionAddress a2 = (SessionAddress)this.peerlist.elementAt(i2);
                if (a2.equals(peerAddress)) {
                    return;
                }
                ++i2;
            }
            this.peerlist.addElement(peerAddress);
            this.CheckRTPPorts(peerAddress.getDataPort(), peerAddress.getControlPort());
            if (jmfSecurity != null) {
                String permission = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        permission = "read property";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        permission = "connect";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable e2) {
                    if (permission.startsWith("read")) {
                        jmfSecurity.permissionFailureNotification(1);
                    }
                    jmfSecurity.permissionFailureNotification(128);
                }
            }
            rtcpr = null;
            rtpr = null;
            dataadd = peerAddress.getDataAddress();
            controladd = peerAddress.getControlAddress();
            datap = peerAddress.getDataPort();
            controlp = peerAddress.getControlPort();
            this.CheckRTPAddress(dataadd, controladd);
            InetAddress mine = null;
            try {
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    Constructor cons = jdk12InetAddressAction.cons;
                    mine = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getLocalHost", null));
                } else {
                    mine = InetAddress.getLocalHost();
                }
            }
            catch (Throwable e3) {
                System.err.println("InitSession : UnknownHostExcpetion " + e3.getMessage());
                e3.printStackTrace();
            }
            if (!dataadd.isMulticastAddress() && !dataadd.equals(mine)) {
                this.bindtome = !this.isBroadcast(dataadd) || this.Win32();
            }
            if (!this.bindtome) {
                try {
                    block36: {
                        try {
                            rtcpr = new RTCPRawReceiver(controlp, controladd.getHostAddress(), this.defaultstats, this.streamSynch);
                            if (dataadd == null) break block36;
                            rtpr = new RTPRawReceiver(datap, dataadd.getHostAddress(), this.defaultstats);
                        }
                        catch (SocketException e4) {
                            throw new IOException(e4.getMessage());
                        }
                    }
                    Object var12_15 = null;
                    if (dataadd != null && rtpr == null && rtcpr != null) {
                        System.err.println("could not create RTCP/RTP raw receivers");
                        rtcpr.closeSource();
                    }
                    break block37;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (dataadd != null && rtpr == null && rtcpr != null) {
                        System.err.println("could not create RTCP/RTP raw receivers");
                        rtcpr.closeSource();
                    }
                    throw throwable;
                }
            }
            try {
                block38: {
                    try {
                        rtcpr = new RTCPRawReceiver(controlp, mine.getHostAddress(), this.defaultstats, this.streamSynch);
                        if (dataadd == null) break block38;
                        rtpr = new RTPRawReceiver(datap, mine.getHostAddress(), this.defaultstats);
                    }
                    catch (SocketException e5) {
                        throw new IOException(e5.getMessage());
                    }
                }
                Object var14_20 = null;
                if (dataadd != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                if (dataadd != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
                throw throwable;
            }
        }
        PacketForwarder rtcpf = new PacketForwarder(rtcpr, new RTCPReceiver(this.cache));
        PacketForwarder rtpf = null;
        if (rtpr != null) {
            rtpf = new PacketForwarder(rtpr, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        rtcpf.startPF("RTCP Forwarder for address" + controladd.toString() + "port " + controlp);
        if (rtpf != null) {
            rtpf.startPF("RTP Forwarder for address " + dataadd.toString() + "port " + datap);
        }
        this.peerrtplist.put(peerAddress, rtpf);
        this.peerrtcplist.put(peerAddress, rtcpf);
        if (this.cache.ourssrc != null) {
            if (this.cache.ourssrc.reporter == null) {
                this.controladdress = controladd;
                this.controlport = controlp;
                this.cache.ourssrc.reporter = this.startParticipating(controlp, dataadd.getHostAddress(), this.cache.ourssrc);
            }
            if (this.cache.ourssrc.reporter.transmit.sender.peerlist == null) {
                this.cache.ourssrc.reporter.transmit.sender.peerlist = new Vector();
            }
        }
        this.cache.ourssrc.reporter.transmit.sender.peerlist.addElement(peerAddress);
        if (this.cache != null) {
            Enumeration e6 = this.cache.cache.elements();
            while (e6.hasMoreElements()) {
                SSRCInfo s2 = (SSRCInfo)e6.nextElement();
                if (!(s2 instanceof SendSSRCInfo)) continue;
                s2.reporter.transmit.sender.control = true;
                if (s2.reporter.transmit.sender.peerlist != null) continue;
                s2.reporter.transmit.sender.peerlist = new Vector();
                s2.reporter.transmit.sender.peerlist.addElement(peerAddress);
            }
        }
        int j2 = 0;
        while (j2 < this.sendstreamlist.size()) {
            SendSSRCInfo i3 = (SendSSRCInfo)this.sendstreamlist.elementAt(j2);
            if (i3.sinkstream.transmitter.sender.peerlist == null) {
                i3.sinkstream.transmitter.sender.peerlist = new Vector();
                i3.sinkstream.transmitter.sender.peerlist.addElement(peerAddress);
            }
            ++j2;
        }
    }

    public void removePeer(SessionAddress peerAddress) {
        PacketForwarder rtpf = (PacketForwarder)this.peerrtplist.get(peerAddress);
        PacketForwarder rtcpf = (PacketForwarder)this.peerrtplist.get(peerAddress);
        if (rtpf != null) {
            rtpf.close();
        }
        if (rtcpf != null) {
            rtcpf.close();
        }
        int i2 = 0;
        while (i2 < this.peerlist.size()) {
            SessionAddress a2 = (SessionAddress)this.peerlist.elementAt(i2);
            if (a2.equals(peerAddress)) {
                this.peerlist.removeElementAt(i2);
            }
            ++i2;
        }
    }

    public void removeAllPeers() {
        int i2 = 0;
        while (i2 < this.peerlist.size()) {
            this.removePeer((SessionAddress)this.peerlist.elementAt(i2));
            ++i2;
        }
    }

    public Vector getPeers() {
        return this.peerlist;
    }

    void addSendStream(SendStream s2) {
        this.sendstreamlist.addElement(s2);
    }

    void removeSendStream(SendStream s2) {
        this.sendstreamlist.removeElement(s2);
        if (((SendSSRCInfo)s2).sinkstream != null) {
            ((SendSSRCInfo)s2).sinkstream.close();
            StreamClosedEvent evt = new StreamClosedEvent(this, s2);
            this.cache.eventhandler.postEvent(evt);
            this.stopParticipating("Closed Stream", (SendSSRCInfo)s2);
        }
        if (this.sendstreamlist.size() == 0 && this.cache.ourssrc != null) {
            PassiveSSRCInfo info = new PassiveSSRCInfo(this.getSSRCCache().ourssrc);
            this.cache.ourssrc = info;
            this.cache.getMainCache().put(info.ssrc, info);
        }
    }

    private RTPTransmitter startDataTransmission(int port, String address) throws IOException {
        RTPTransmitter transmitter = null;
        RTPRawSender sender = null;
        if (this.localDataPort == -1) {
            this.udpsender = new UDPPacketSender(this.dataaddress, this.dataport);
        } else if (this.newRtpInterface) {
            this.udpsender = new UDPPacketSender(this.rtpRawReceiver.socket);
        } else {
            int localDataPort = this.localSenderAddress.getDataPort();
            InetAddress localDataAddress = this.localSenderAddress.getDataAddress();
            this.udpsender = new UDPPacketSender(localDataPort, localDataAddress, this.dataaddress, this.dataport);
        }
        if (this.ttl != 1) {
            this.udpsender.setttl(this.ttl);
        }
        sender = new RTPRawSender(this.dataport, address, this.udpsender);
        transmitter = new RTPTransmitter(this.cache, sender);
        return transmitter;
    }

    private RTPTransmitter startDataTransmission(RTPPushDataSource s2) {
        RTPRawSender sender = null;
        RTPTransmitter transmitter = null;
        this.rtpsender = new RTPPacketSender(s2);
        sender = new RTPRawSender(this.rtpsender);
        transmitter = new RTPTransmitter(this.cache, sender);
        return transmitter;
    }

    private RTPTransmitter startDataTransmission(RTPConnector connector) {
        try {
            RTPRawSender sender = null;
            RTPTransmitter transmitter = null;
            this.rtpsender = new RTPPacketSender(connector);
            sender = new RTPRawSender(this.rtpsender);
            transmitter = new RTPTransmitter(this.cache, sender);
            return transmitter;
        }
        catch (IOException e2) {
            return null;
        }
    }

    public void UpdateEncodings(DataSource source) {
        RTPControlImpl control = (RTPControlImpl)source.getControl("javax.media.rtp.RTPControl");
        if (control != null && control.codeclist != null) {
            Enumeration e2 = control.codeclist.keys();
            while (e2.hasMoreElements()) {
                Integer p = (Integer)e2.nextElement();
                this.formatinfo.add(p, (Format)control.codeclist.get(p));
            }
        }
    }

    private int startSession(RTPPushDataSource rtpsource, RTPPushDataSource rtcpsource, EncryptionInfo info) {
        if (!this.initialized) {
            return -1;
        }
        if (this.started) {
            return -1;
        }
        this.cache.sessionbandwidth = 384000;
        RTPRawReceiver rtpr = new RTPRawReceiver(rtpsource, this.defaultstats);
        RTCPRawReceiver rtcpr = new RTCPRawReceiver(rtcpsource, this.defaultstats, this.streamSynch);
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rtpr, this.streamSynch);
        this.rtpForwarder = new PacketForwarder(rtpr, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder " + rtpsource);
        }
        this.rtcpForwarder = new PacketForwarder(rtcpr, new RTCPReceiver(this.cache));
        if (this.rtcpForwarder != null) {
            this.rtcpForwarder.startPF("RTCP Forwarder " + rtpsource);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(rtcpsource, this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    public RTPSessionMgr(RTPPushDataSource netdatasource) {
        this.nosockets = true;
        this.rtpsource = netdatasource;
        if (this.rtpsource instanceof RTPSocket) {
            this.rtcpsource = ((RTPSocket)this.rtpsource).getControlChannel();
        }
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        com.sun.media.protocol.rtp.DataSource newsource = this.createNewDS(null);
        this.UpdateEncodings(netdatasource);
        RTPControl contrl = (RTPControl)netdatasource.getControl("javax.media.rtp.RTPControl");
        newsource.setControl(contrl);
        this.initSession(this.setSDES(), 0.05, 0.25);
        this.startSession(this.rtpsource, this.rtcpsource, null);
    }

    public RTPSessionMgr(com.sun.media.protocol.rtp.DataSource configds) throws IOException {
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        this.UpdateEncodings(configds);
        RTPMediaLocator mrl = null;
        try {
            mrl = new RTPMediaLocator(configds.getLocator().toString());
        }
        catch (MalformedURLException e2) {
            throw new IOException("RTP URL is Malformed " + e2.getMessage());
        }
        com.sun.media.protocol.rtp.DataSource newsource = this.createNewDS(mrl);
        RTPControl contrl = (RTPControl)configds.getControl("javax.media.rtp.RTPControl");
        newsource.setControl(contrl);
        String address = mrl.getSessionAddress();
        this.dataport = mrl.getSessionPort();
        this.controlport = this.dataport + 1;
        this.ttl = mrl.getTTL();
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e3) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12InetAddressAction.cons;
                this.dataaddress = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getByName", address));
            } else {
                this.dataaddress = InetAddress.getByName(address);
            }
        }
        catch (Throwable e4) {
            e4.printStackTrace();
        }
        this.controladdress = this.dataaddress;
        SessionAddress localaddr = new SessionAddress();
        try {
            this.initSession(localaddr, this.setSDES(), 0.05, 0.25);
        }
        catch (SessionManagerException e5) {
            throw new IOException("SessionManager exception " + e5.getMessage());
        }
    }

    public void addMRL(RTPMediaLocator mrl) {
        int ssrc = (int)mrl.getSSRC();
        if (ssrc == 0) {
            return;
        }
        com.sun.media.protocol.rtp.DataSource reqsource = (com.sun.media.protocol.rtp.DataSource)this.dslist.get(ssrc);
        if (reqsource != null) {
            return;
        }
        com.sun.media.protocol.rtp.DataSource newSource = this.createNewDS(mrl);
    }

    public boolean isDefaultDSassigned() {
        return this.bds;
    }

    public Format getFormat(int payload) {
        return this.formatinfo.get(payload);
    }

    public void setDefaultDSassigned(int ssrc) {
        this.bds = true;
        this.defaultsourceid = ssrc;
        this.dslist.put(ssrc, this.defaultsource);
        this.defaultsource.setSSRC(ssrc);
        this.defaultsource.setMgr(this);
    }

    public com.sun.media.protocol.rtp.DataSource createNewDS(int ssrcid) {
        com.sun.media.protocol.rtp.DataSource source = new com.sun.media.protocol.rtp.DataSource();
        source.setContentType("raw");
        try {
            source.connect();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        RTPSourceStream stream = new RTPSourceStream(source);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(stream);
        this.dslist.put(ssrcid, source);
        source.setSSRC(ssrcid);
        source.setMgr(this);
        return source;
    }

    public com.sun.media.protocol.rtp.DataSource createNewDS(RTPMediaLocator mrl) {
        com.sun.media.protocol.rtp.DataSource source = new com.sun.media.protocol.rtp.DataSource();
        source.setContentType("raw");
        try {
            source.connect();
        }
        catch (IOException e2) {
            System.err.println("IOException in createNewDS() " + e2.getMessage());
            e2.printStackTrace();
        }
        RTPSourceStream stream = new RTPSourceStream(source);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(stream);
        if (mrl != null && (int)mrl.getSSRC() != 0) {
            this.dslist.put((int)mrl.getSSRC(), source);
            source.setSSRC((int)mrl.getSSRC());
            source.setMgr(this);
        } else {
            this.defaultsource = source;
            this.defaultstream = stream;
        }
        return source;
    }

    public com.sun.media.protocol.rtp.DataSource getDataSource(RTPMediaLocator mrl) {
        if (mrl == null) {
            return this.defaultsource;
        }
        int ssrc = (int)mrl.getSSRC();
        if (ssrc == 0) {
            return this.defaultsource;
        }
        return (com.sun.media.protocol.rtp.DataSource)this.dslist.get(ssrc);
    }

    public String toString() {
        String s2;
        if (this.newRtpInterface) {
            int controlPort = 0;
            int dataPort = 0;
            String address = "";
            if (this.localAddress != null) {
                controlPort = this.localAddress.getControlPort();
                dataPort = this.localAddress.getDataPort();
                address = this.localAddress.getDataHostAddress();
            }
            s2 = "RTPManager \n\tSSRCCache  " + this.cache + "\n\tDataport  " + dataPort + "\n\tControlport  " + controlPort + "\n\tAddress  " + address + "\n\tRTPForwarder  " + this.rtpForwarder + "\n\tRTPDemux  " + this.rtpDemultiplexer;
        } else {
            s2 = "RTPSession Manager  \n\tSSRCCache  " + this.cache + "\n\tDataport  " + this.dataport + "\n\tControlport  " + this.controlport + "\n\tAddress  " + this.dataaddress + "\n\tRTPForwarder  " + this.rtpForwarder + "\n\tRTPDEmux  " + this.rtpDemultiplexer;
        }
        return s2;
    }

    public boolean IsNonParticipating() {
        return this.nonparticipating;
    }

    public void startSession() throws IOException {
        SessionAddress destaddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        try {
            this.startSession(destaddress, this.ttl, null);
        }
        catch (SessionManagerException e2) {
            throw new IOException("SessionManager exception " + e2.getMessage());
        }
    }

    public void closeSession() {
        if (this.dslist.isEmpty() || this.nosockets) {
            this.closeSession("DataSource disconnected");
        }
    }

    public void removeDataSource(com.sun.media.protocol.rtp.DataSource source) {
        if (source == this.defaultsource) {
            this.defaultsource = null;
            this.defaultstream = null;
            this.defaultsourceid = 0;
            this.bds = false;
        }
        this.dslist.removeObj(source);
    }

    void startRTCPReports(InetAddress remoteAddress) {
        if (!this.nonparticipating && !this.startedparticipating) {
            try {
                if (this.cache.ourssrc != null) {
                    this.cache.ourssrc.reporter = this.startParticipating(this.controlport, remoteAddress.getHostAddress(), this.cache.ourssrc);
                }
            }
            catch (IOException e2) {
                System.err.println("startRTCPReports " + e2.getMessage());
                e2.printStackTrace();
            }
        }
    }

    boolean isUnicast() {
        return this.unicast;
    }

    public void addUnicastAddr(InetAddress destAddress) {
        if (this.sender != null) {
            this.sender.addDestAddr(destAddress);
        }
    }

    public boolean isSenderDefaultAddr(InetAddress destAddress) {
        if (this.sender == null) {
            return false;
        }
        InetAddress defaultaddr = this.sender.getRemoteAddr();
        return defaultaddr.equals(destAddress);
    }

    SSRCCache getSSRCCache() {
        return this.cache;
    }

    void setSessionBandwidth(int bw) {
        this.cache.sessionbandwidth = bw;
    }

    private String getProperty(String prop) {
        String value = null;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(1);
            }
        }
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12PropertyAction.cons;
                value = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(prop));
            } else {
                value = System.getProperty(prop);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    private SourceDescription[] setSDES() {
        SourceDescription[] desclist = new SourceDescription[3];
        if (desclist == null) {
            return null;
        }
        desclist[0] = new SourceDescription(2, this.getProperty("user.name"), 1, false);
        desclist[1] = new SourceDescription(1, SourceDescription.generateCNAME(), 1, false);
        desclist[2] = new SourceDescription(6, "JMF RTP Player v1.0", 1, false);
        return desclist;
    }

    private SourceDescription[] setCNAME(SourceDescription[] desclist) {
        String descval = null;
        boolean cname = false;
        if (desclist == null) {
            desclist = new SourceDescription[1];
            descval = SourceDescription.generateCNAME();
            desclist[0] = new SourceDescription(1, descval, 1, false);
            return desclist;
        }
        int i2 = 0;
        while (i2 < desclist.length) {
            int type = desclist[i2].getType();
            descval = desclist[i2].getDescription();
            if (type == 1 && descval == null) {
                descval = SourceDescription.generateCNAME();
                cname = true;
                break;
            }
            ++i2;
        }
        if (cname) {
            return desclist;
        }
        SourceDescription[] newdesclist = new SourceDescription[desclist.length + 1];
        newdesclist[0] = new SourceDescription(1, SourceDescription.generateCNAME(), 1, false);
        int curr = 1;
        int i3 = 0;
        while (i3 < desclist.length) {
            newdesclist[curr] = new SourceDescription(desclist[i3].getType(), desclist[i3].getDescription(), 1, false);
            ++curr;
            ++i3;
        }
        return newdesclist;
    }

    private boolean isCNAME(SourceDescription[] desclist) {
        String descval = null;
        boolean cname = false;
        if (desclist == null) {
            return cname;
        }
        int i2 = 0;
        while (i2 < desclist.length) {
            try {
                int type = desclist[i2].getType();
                descval = desclist[i2].getDescription();
                if (type == 1 && descval != null) {
                    cname = true;
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            ++i2;
        }
        return cname;
    }

    private void CheckRTPPorts(int dataport, int controlport) throws InvalidSessionAddressException {
        if (dataport == 0 || dataport == -1) {
            dataport = controlport - 1;
        }
        if (controlport == 0 || controlport == -1) {
            controlport = dataport + 1;
        }
        if (dataport != 0 && dataport % 2 != 0) {
            throw new InvalidSessionAddressException("Data Port must be valid and even");
        }
        if (controlport != 0 && controlport % 2 != 1) {
            throw new InvalidSessionAddressException("Control Port must be valid and odd");
        }
        if (controlport != dataport + 1) {
            throw new InvalidSessionAddressException("Control Port must be one higher than the Data Port");
        }
    }

    private void CheckRTPAddress(InetAddress dataaddress, InetAddress controladdress) throws InvalidSessionAddressException {
        if (dataaddress == null && controladdress == null) {
            throw new InvalidSessionAddressException("Data and control addresses are null");
        }
        if (controladdress == null && dataaddress != null) {
            controladdress = dataaddress;
        }
        if (dataaddress == null && controladdress != null) {
            dataaddress = controladdress;
        }
    }

    private synchronized RTCPReporter startParticipating(RTPPushDataSource dest, SSRCInfo info) {
        this.startedparticipating = true;
        this.rtpsender = new RTPPacketSender(dest);
        RTCPRawSender sender = new RTCPRawSender(this.rtpsender);
        RTCPTransmitter transmitter = new RTCPTransmitter(this.cache, sender);
        transmitter.setSSRCInfo(info);
        RTCPReporter reporter = new RTCPReporter(this.cache, transmitter);
        return reporter;
    }

    private synchronized RTCPReporter startParticipating(RTPConnector rtpConnector, SSRCInfo info) {
        this.startedparticipating = true;
        try {
            this.rtpsender = new RTPPacketSender(rtpConnector.getControlOutputStream());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        RTCPRawSender sender = new RTCPRawSender(this.rtpsender);
        RTCPTransmitter transmitter = new RTCPTransmitter(this.cache, sender);
        transmitter.setSSRCInfo(info);
        RTCPReporter reporter = new RTCPReporter(this.cache, transmitter);
        return reporter;
    }

    private synchronized RTCPReporter startParticipating(int port, String address, SSRCInfo info) throws IOException {
        this.startedparticipating = true;
        UDPPacketSender udpsender = null;
        if (this.localControlPort == -1) {
            udpsender = new UDPPacketSender(this.controladdress, this.controlport);
            this.localControlPort = udpsender.getLocalPort();
            this.localControlAddress = udpsender.getLocalAddress();
        } else {
            udpsender = new UDPPacketSender(this.localControlPort, this.localControlAddress, this.controladdress, this.controlport);
        }
        if (this.ttl != 1) {
            udpsender.setttl(this.ttl);
        }
        RTCPRawSender sender = new RTCPRawSender(port, address, udpsender);
        RTCPTransmitter transmitter = new RTCPTransmitter(this.cache, sender);
        transmitter.setSSRCInfo(info);
        RTCPReporter reporter = new RTCPReporter(this.cache, transmitter);
        return reporter;
    }

    private synchronized RTCPReporter startParticipating(SessionAddress localReceiverAddress, SessionAddress localSenderAddress, SSRCInfo info, DatagramSocket rtcpSocket) throws IOException {
        this.localReceiverAddress = localReceiverAddress;
        this.startedparticipating = true;
        UDPPacketSender udpsender = null;
        int localSenderControlPort = localSenderAddress.getControlPort();
        InetAddress localSenderControlAddress = localSenderAddress.getControlAddress();
        int localReceiverControlPort = localReceiverAddress.getControlPort();
        InetAddress localReceiverControlAddress = localReceiverAddress.getControlAddress();
        udpsender = localSenderControlPort == -1 ? new UDPPacketSender(localSenderControlAddress, localSenderControlPort) : (localSenderControlPort == localReceiverControlPort ? new UDPPacketSender(rtcpSocket) : new UDPPacketSender(localSenderControlPort, localSenderControlAddress, this.controladdress, this.controlport));
        if (this.ttl != 1) {
            udpsender.setttl(this.ttl);
        }
        RTCPRawSender sender = new RTCPRawSender(this.controlport, this.controladdress.getHostName(), udpsender);
        RTCPTransmitter transmitter = new RTCPTransmitter(this.cache, sender);
        transmitter.setSSRCInfo(info);
        RTCPReporter reporter = new RTCPReporter(this.cache, transmitter);
        return reporter;
    }

    private synchronized void stopParticipating(String reason, SSRCInfo info) {
        if (info.reporter != null) {
            info.reporter.close(reason);
            info.reporter = null;
        }
    }

    private int initSession(SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) {
        if (this.initialized) {
            return -1;
        }
        InetAddress host = null;
        if (rtcp_bw_fraction == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = this.generateSSRC();
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = rtcp_bw_fraction;
        this.cache.rtcp_sender_bw_fraction = rtcp_sender_bw_fraction;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12InetAddressAction.cons;
                host = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getLocalHost", null));
            } else {
                host = InetAddress.getLocalHost();
            }
        }
        catch (Throwable e3) {
            System.err.println("InitSession : UnknownHostExcpetion " + e3.getMessage());
            e3.printStackTrace();
            return -1;
        }
        this.cache.ourssrc = this.cache.get((int)this.defaultSSRC, null, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(defaultUserDesc)) {
            SourceDescription[] newUserDesc = this.setCNAME(defaultUserDesc);
            this.cache.ourssrc.setSourceDescription(newUserDesc);
        } else {
            this.cache.ourssrc.setSourceDescription(defaultUserDesc);
        }
        this.cache.ourssrc.ssrc = (int)this.defaultSSRC;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    boolean isBroadcast(InetAddress checkaddr) {
        InetAddress mine = null;
        try {
            mine = InetAddress.getLocalHost();
            byte[] addr = mine.getAddress();
            int address = addr[3] & 0xFF;
            address |= addr[2] << 8 & 0xFF00;
            address |= addr[1] << 16 & 0xFF0000;
            byte[] dataaddr = checkaddr.getAddress();
            int daddress = dataaddr[3] & 0xFF;
            daddress |= dataaddr[2] << 8 & 0xFF00;
            daddress |= dataaddr[1] << 16 & 0xFF0000;
            if (((address |= addr[0] << 24 & 0xFF000000) | 0xFF) == (daddress |= dataaddr[0] << 24 & 0xFF000000)) {
                return true;
            }
        }
        catch (UnknownHostException e2) {
            System.err.println(e2.getMessage());
        }
        return false;
    }

    private boolean Win32() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public void initialize(RTPConnector connector) {
        this.rtpConnector = connector;
        this.newRtpInterface = true;
        String cname = SourceDescription.generateCNAME();
        SourceDescription[] sourceDescription = new SourceDescription[]{new SourceDescription(3, "jmf-user@sun.com", 1, false), new SourceDescription(1, cname, 1, false), new SourceDescription(6, "JMF RTP Player v2.0", 1, false)};
        int ssrc = (int)this.generateSSRC();
        this.ttl = 1;
        this.participating = this.rtpConnector.getRTCPBandwidthFraction() != 0.0;
        this.cache = new SSRCCache(this);
        this.cache.sessionbandwidth = 384000;
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = this.rtpConnector.getRTCPBandwidthFraction() > 0.0 ? this.rtpConnector.getRTCPBandwidthFraction() : 0.05;
        this.cache.rtcp_sender_bw_fraction = this.rtpConnector.getRTCPSenderBandwidthFraction() > 0.0 ? this.rtpConnector.getRTCPSenderBandwidthFraction() : 0.25;
        this.cache.ourssrc = this.cache.get(ssrc, null, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescription)) {
            SourceDescription[] newUserDesc = this.setCNAME(sourceDescription);
            this.cache.ourssrc.setSourceDescription(newUserDesc);
        } else {
            this.cache.ourssrc.setSourceDescription(sourceDescription);
        }
        this.cache.ourssrc.ssrc = ssrc;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        this.rtpRawReceiver = new RTPRawReceiver(this.rtpConnector, this.defaultstats);
        this.rtcpRawReceiver = new RTCPRawReceiver(this.rtpConnector, this.defaultstats, this.streamSynch);
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, this.rtpRawReceiver, this.streamSynch);
        this.rtpForwarder = new PacketForwarder(this.rtpRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder: " + this.rtpConnector);
        }
        this.rtcpForwarder = new PacketForwarder(this.rtcpRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtcpForwarder != null) {
            this.rtcpForwarder.startPF("RTCP Forwarder: " + this.rtpConnector);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (this.participating && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(this.rtpConnector, this.cache.ourssrc);
        }
    }

    public void initialize(SessionAddress localAddress) throws InvalidSessionAddressException {
        String cname = SourceDescription.generateCNAME();
        SourceDescription[] sourceDescription = new SourceDescription[]{new SourceDescription(3, "jmf-user@sun.com", 1, false), new SourceDescription(1, cname, 1, false), new SourceDescription(6, "JMF RTP Player v2.0", 1, false)};
        double rtcp_bw_fraction = 0.05;
        double rtcp_sender_bw_fraction = 0.25;
        SessionAddress[] localAddresses = new SessionAddress[]{localAddress};
        this.initialize(localAddresses, sourceDescription, rtcp_bw_fraction, rtcp_sender_bw_fraction, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(SessionAddress[] localAddresses, SourceDescription[] sourceDescription, double rtcp_bw_fraction, double rtcp_sender_bw_fraction, EncryptionInfo encryptionInfo) throws InvalidSessionAddressException {
        InetAddress host;
        if (this.initialized) {
            return;
        }
        this.newRtpInterface = true;
        this.remoteAddresses = new Vector();
        int ssrc = (int)this.generateSSRC();
        this.ttl = 1;
        this.participating = rtcp_bw_fraction != 0.0;
        if (localAddresses.length == 0) {
            throw new InvalidSessionAddressException("At least one local address is required!");
        }
        this.localAddress = localAddresses[0];
        if (this.localAddress == null) {
            throw new InvalidSessionAddressException("Invalid local address: null");
        }
        InetAddress[] addrlist = null;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            String hostname;
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12InetAddressAction.cons;
                host = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getLocalHost", null));
                hostname = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(host, "getHostName", null));
                addrlist = (InetAddress[])jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getAllByName", hostname));
            } else {
                host = InetAddress.getLocalHost();
                hostname = host.getHostName();
                addrlist = InetAddress.getAllByName(hostname);
            }
        }
        catch (Throwable e3) {
            System.err.println("Initialize : UnknownHostExcpetion " + e3.getMessage());
            e3.printStackTrace();
            return;
        }
        if (this.localAddress.getDataAddress() == null) {
            this.localAddress.setDataHostAddress(host);
        }
        if (this.localAddress.getControlAddress() == null) {
            this.localAddress.setControlHostAddress(host);
        }
        if (this.localAddress.getDataAddress().isMulticastAddress()) {
            if (!this.localAddress.getControlAddress().isMulticastAddress()) throw new InvalidSessionAddressException("Invalid multicast address");
            this.ttl = this.localAddress.getTimeToLive();
        } else {
            boolean dataOk = false;
            boolean ctrlOk = false;
            int i2 = 0;
            while (!(i2 >= addrlist.length || dataOk && ctrlOk)) {
                if (addrlist[i2].equals(this.localAddress.getDataAddress())) {
                    dataOk = true;
                }
                if (addrlist[i2].equals(this.localAddress.getControlAddress())) {
                    ctrlOk = true;
                }
                ++i2;
            }
            if (!dataOk) {
                String s2 = "Does not belong to any of this hosts local interfaces";
                throw new InvalidSessionAddressException("Local Data Address" + s2);
            }
            if (!ctrlOk) {
                String s3 = "Does not belong to any of this hosts local interfaces";
                throw new InvalidSessionAddressException("Local Control Address" + s3);
            }
            if (this.localAddress.getDataPort() == -1) {
                int dataPort = this.findLocalPorts();
                this.localAddress.setDataPort(dataPort);
                this.localAddress.setControlPort(dataPort + 1);
            }
            if (!this.localAddress.getDataAddress().isMulticastAddress()) {
                try {
                    this.dataSocket = new DatagramSocket(this.localAddress.getDataPort(), this.localAddress.getDataAddress());
                }
                catch (SocketException e4) {
                    throw new InvalidSessionAddressException("Can't open local data port: " + this.localAddress.getDataPort());
                }
            }
            if (!this.localAddress.getControlAddress().isMulticastAddress()) {
                try {
                    this.controlSocket = new DatagramSocket(this.localAddress.getControlPort(), this.localAddress.getControlAddress());
                }
                catch (SocketException e5) {
                    if (this.dataSocket == null) throw new InvalidSessionAddressException("Can't open local control port: " + this.localAddress.getControlPort());
                    this.dataSocket.close();
                    throw new InvalidSessionAddressException("Can't open local control port: " + this.localAddress.getControlPort());
                }
            }
        }
        this.cache = new SSRCCache(this);
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = rtcp_bw_fraction;
        this.cache.rtcp_sender_bw_fraction = rtcp_sender_bw_fraction;
        this.cache.ourssrc = this.cache.get(ssrc, host, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescription)) {
            SourceDescription[] newUserDesc = this.setCNAME(sourceDescription);
            this.cache.ourssrc.setSourceDescription(newUserDesc);
        } else {
            this.cache.ourssrc.setSourceDescription(sourceDescription);
        }
        this.cache.ourssrc.ssrc = ssrc;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
    }

    public void addTarget(SessionAddress remoteAddress) throws IOException {
        this.remoteAddresses.addElement(remoteAddress);
        if (this.remoteAddresses.size() > 1) {
            this.setRemoteAddresses();
            return;
        }
        this.remoteAddress = remoteAddress;
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "read property";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "connect";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                if (permission.startsWith("read")) {
                    jmfSecurity.permissionFailureNotification(1);
                }
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            this.rtcpRawReceiver = new RTCPRawReceiver(this.localAddress, remoteAddress, this.defaultstats, this.streamSynch, this.controlSocket);
            this.rtpRawReceiver = new RTPRawReceiver(this.localAddress, remoteAddress, this.defaultstats, this.dataSocket);
        }
        catch (SocketException e3) {
            throw new IOException(e3.getMessage());
        }
        catch (UnknownHostException e4) {
            throw new IOException(e4.getMessage());
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, this.rtpRawReceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(this.rtcpRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtpRawReceiver != null) {
            this.rtpForwarder = new PacketForwarder(this.rtpRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + remoteAddress.getControlHostAddress() + " port " + remoteAddress.getControlPort());
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + remoteAddress.getDataHostAddress() + " port " + remoteAddress.getDataPort());
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (this.cache.ourssrc != null && this.participating) {
            this.cache.ourssrc.reporter = this.startParticipating(this.rtcpRawReceiver.socket);
        }
    }

    private synchronized RTCPReporter startParticipating(DatagramSocket rtcpSocket) throws IOException {
        UDPPacketSender udpsender;
        this.udpPacketSender = udpsender = new UDPPacketSender(rtcpSocket);
        if (this.ttl != 1) {
            udpsender.setttl(this.ttl);
        }
        RTCPRawSender sender = new RTCPRawSender(this.remoteAddress.getControlPort(), this.remoteAddress.getControlAddress().getHostName(), udpsender);
        this.rtcpTransmitter = new RTCPTransmitter(this.cache, sender);
        this.rtcpTransmitter.setSSRCInfo(this.cache.ourssrc);
        RTCPReporter reporter = new RTCPReporter(this.cache, this.rtcpTransmitter);
        this.startedparticipating = true;
        return reporter;
    }

    public void removeTargets(String reason) {
        if (this.cache != null) {
            this.stopParticipating(reason, this.cache.ourssrc);
        }
        if (this.remoteAddresses != null) {
            this.remoteAddresses.removeAllElements();
        }
        this.setRemoteAddresses();
    }

    public void removeTarget(SessionAddress remoteAddress, String reason) {
        this.remoteAddresses.removeElement(remoteAddress);
        this.setRemoteAddresses();
        if (this.remoteAddresses.size() == 0 && this.cache != null) {
            this.stopParticipating(reason, this.cache.ourssrc);
        }
    }

    private void setRemoteAddresses() {
        if (this.rtpTransmitter != null) {
            RTPRawSender rtpRawSender = this.rtpTransmitter.getSender();
            rtpRawSender.setDestAddresses(this.remoteAddresses);
        }
        if (this.rtcpTransmitter != null) {
            RTCPRawSender rtcpRawSender = this.rtcpTransmitter.getSender();
            rtcpRawSender.setDestAddresses(this.remoteAddresses);
        }
    }

    public void dispose() {
        if (this.rtpConnector != null) {
            this.rtpConnector.close();
        }
        if (this.defaultsource != null) {
            this.defaultsource.disconnect();
        }
        if (this.cache != null) {
            Enumeration e2 = this.cache.cache.elements();
            while (e2.hasMoreElements()) {
                SSRCInfo s2 = (SSRCInfo)e2.nextElement();
                if (s2.dstream != null) {
                    s2.dstream.close();
                }
                if (s2 instanceof SendSSRCInfo) {
                    ((SendSSRCInfo)s2).close();
                }
                this.stopParticipating("dispose", s2);
            }
        }
        int i2 = 0;
        while (i2 < this.sendstreamlist.size()) {
            this.removeSendStream((SendStream)this.sendstreamlist.elementAt(i2));
            ++i2;
        }
        if (this.rtpTransmitter != null) {
            this.rtpTransmitter.close();
        }
        if (this.rtcpTransmitter != null) {
            this.rtcpTransmitter.close();
        }
        if (this.rtcpForwarder != null) {
            RTCPRawReceiver rtcpRawReceiver = (RTCPRawReceiver)this.rtcpForwarder.getSource();
            this.rtcpForwarder.close();
            if (rtcpRawReceiver != null) {
                rtcpRawReceiver.close();
            }
        }
        if (this.cleaner != null) {
            this.cleaner.stop();
        }
        if (this.cache != null) {
            this.cache.destroy();
        }
        if (this.rtpForwarder != null) {
            RTPRawReceiver rtpRawReceiver = (RTPRawReceiver)this.rtpForwarder.getSource();
            this.rtpForwarder.close();
            if (rtpRawReceiver != null) {
                rtpRawReceiver.close();
            }
        }
    }

    public SessionAddress getRemoteSessionAddress() {
        return this.remoteAddress;
    }

    public int getSSRC() {
        return 0;
    }

    private int findLocalPorts() {
        boolean found = false;
        int port = -1;
        while (!found) {
            do {
                double num;
                if ((port = (int)((num = Math.random()) * 65535.0)) % 2 == 0) continue;
                ++port;
            } while (port < 1024 || port > 65534);
            try {
                DatagramSocket datagramSocket = new DatagramSocket(port);
                datagramSocket.close();
                datagramSocket = new DatagramSocket(port + 1);
                datagramSocket.close();
                found = true;
            }
            catch (SocketException e2) {
                found = false;
            }
        }
        return port;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        supportedList = null;
        addedList = new Vector();
    }
}

