/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class UDPPacketSender
implements PacketConsumer {
    private DatagramSocket sock;
    private InetAddress address;
    private int port;
    private int ttl;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public UDPPacketSender(DatagramSocket sock) {
        this.sock = sock;
    }

    public UDPPacketSender() throws IOException {
        this(new DatagramSocket());
    }

    public UDPPacketSender(int localPort) throws IOException {
        this(new DatagramSocket(localPort));
    }

    public UDPPacketSender(InetAddress remoteAddress, int remotePort) throws IOException {
        if (remoteAddress.isMulticastAddress()) {
            MulticastSocket sock = new MulticastSocket();
            this.sock = sock;
        } else {
            this.sock = new DatagramSocket();
        }
        this.setRemoteAddress(remoteAddress, remotePort);
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public UDPPacketSender(int localPort, InetAddress localAddress, InetAddress remoteAddress, int remotePort) throws IOException {
        if (remoteAddress.isMulticastAddress()) {
            MulticastSocket sock = new MulticastSocket(localPort);
            if (localAddress != null) {
                sock.setInterface(localAddress);
            }
            this.sock = sock;
        } else if (localAddress != null) {
            try {
                this.sock = new DatagramSocket(localPort, localAddress);
            }
            catch (SocketException e2) {
                System.out.println(e2);
                System.out.println("localPort: " + localPort);
                System.out.println("localAddress: " + localAddress);
                throw e2;
            }
        } else {
            this.sock = new DatagramSocket(localPort);
        }
        this.setRemoteAddress(remoteAddress, remotePort);
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }

    public void setRemoteAddress(InetAddress remoteAddress, int remotePort) {
        this.address = remoteAddress;
        this.port = remotePort;
    }

    public void setttl(int ttl) throws IOException {
        this.ttl = ttl;
        if (this.sock instanceof MulticastSocket) {
            ((MulticastSocket)this.sock).setTTL((byte)this.ttl);
        }
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public void sendTo(Packet p) throws IOException {
        InetAddress addr = null;
        int port = 0;
        if (p instanceof UDPPacket) {
            UDPPacket udpp = (UDPPacket)p;
            addr = udpp.remoteAddress;
            port = udpp.remotePort;
            if (jmfSecurity != null) {
                String permission = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        if (udpp.remoteAddress.isMulticastAddress()) {
                            permission = "multicast";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 512);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        }
                        permission = "connect";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable e2) {
                    if (permission.startsWith("multicast")) {
                        jmfSecurity.permissionFailureNotification(512);
                    }
                    jmfSecurity.permissionFailureNotification(128);
                }
            }
        }
        if (addr == null) {
            throw new IllegalArgumentException("No address set");
        }
        this.send(p, addr, port);
    }

    public void send(Packet p, InetAddress addr, int port) throws IOException {
        byte[] data = p.data;
        if (p.offset > 0) {
            byte[] byArray = data;
            data = new byte[p.length];
            System.arraycopy(byArray, p.offset, data, 0, p.length);
        }
        DatagramPacket dp = new DatagramPacket(data, p.length, addr, port);
        this.sock.send(dp);
    }

    public void closeConsumer() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    public String consumerString() {
        String s2 = "UDP Datagram Packet Sender on port " + this.sock.getLocalPort();
        if (this.address != null) {
            s2 = s2 + " sending to address " + this.address + ", port " + this.port + ", ttl" + this.ttl;
        }
        return s2;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

