/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.pswing;

import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class PComboBox
extends JComboBox
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PSwing pSwing;
    private PSwingCanvas canvas;

    public PComboBox(ComboBoxModel model) {
        super(model);
        this.init();
    }

    public PComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public PComboBox(Vector items) {
        super(items);
        this.init();
    }

    public PComboBox() {
        this.init();
    }

    private void init() {
        this.setUI(new PBasicComboBoxUI());
    }

    public void setEnvironment(PSwing pSwingNode, PSwingCanvas canvasEnvirnoment) {
        this.pSwing = pSwingNode;
        this.canvas = canvasEnvirnoment;
    }

    private Rectangle2D getNodeBoundsInCanvas() {
        if (this.pSwing == null || this.canvas == null) {
            throw new RuntimeException("PComboBox.setEnvironment( swing, pCanvas );//has to be done manually at present");
        }
        Rectangle2D r1c = new Rectangle2D.Double(this.pSwing.getX(), this.pSwing.getY(), this.getWidth(), this.getHeight());
        this.pSwing.localToGlobal(r1c);
        this.canvas.getCamera().globalToLocal(r1c);
        r1c = this.canvas.getCamera().getViewTransform().createTransformedShape(r1c).getBounds2D();
        return r1c;
    }

    public PSwing getPSwing() {
        return this.pSwing;
    }

    public PSwingCanvas getCanvas() {
        return this.canvas;
    }

    protected class PBasicComboPopup
    extends BasicComboPopup {
        private static final long serialVersionUID = 1L;

        public PBasicComboPopup(JComboBox combo) {
            super(combo);
        }

        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            Rectangle2D r = PComboBox.this.getNodeBoundsInCanvas();
            Rectangle sup = super.computePopupBounds(px, py, pw, ph);
            return new Rectangle((int)r.getX(), (int)r.getMaxY(), (int)sup.getWidth(), (int)sup.getHeight());
        }
    }

    protected class PBasicComboBoxUI
    extends BasicComboBoxUI {
        protected PBasicComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            PBasicComboPopup popup = new PBasicComboPopup(this.comboBox);
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }
}

