/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;

public class POcclusionDetection {
    public void detectOccusions(PNode n2, PBounds parentBounds) {
        this.detectOcclusions(n2, new PPickPath(null, parentBounds));
    }

    public void detectOcclusions(PNode node, PPickPath pickPath) {
        if (!node.fullIntersects(pickPath.getPickBounds())) {
            return;
        }
        pickPath.pushTransform(node.getTransformReference(false));
        int count = node.getChildrenCount();
        for (int i2 = count - 1; i2 >= 0; --i2) {
            PNode each = node.getChild(i2);
            if (node.getOccluded()) {
                each.setOccluded(true);
                continue;
            }
            this.detectOcclusions(each, pickPath);
        }
        if (this.nodeOccludesParents(node, pickPath)) {
            PNode parent = node.getParent();
            while (parent != null && !parent.getOccluded()) {
                parent.setOccluded(true);
            }
        }
        pickPath.popTransform(node.getTransformReference(false));
    }

    private boolean nodeOccludesParents(PNode n2, PPickPath pickPath) {
        return !n2.getOccluded() && n2.intersects(pickPath.getPickBounds()) && n2.isOpaque(pickPath.getPickBounds());
    }
}

