/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Shape;
import java.awt.Stroke;

abstract class PSemanticStroke
implements Stroke {
    protected static final double THRESHOLD = 1.0E-6;
    private transient float recentScale;
    private transient Stroke recentStroke;
    protected final Stroke stroke;

    protected PSemanticStroke(Stroke stroke) {
        this.stroke = stroke;
        this.recentStroke = stroke;
        this.recentScale = 1.0f;
    }

    public Shape createStrokedShape(Shape s2) {
        float currentScale = this.getActiveScale();
        if ((double)Math.abs(currentScale - this.recentScale) > 1.0E-6) {
            this.recentScale = currentScale;
            this.recentStroke = this.newStroke(this.recentScale);
        }
        return this.recentStroke.createStrokedShape(s2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSemanticStroke other = (PSemanticStroke)obj;
        return !(this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke));
    }

    protected float getActiveScale() {
        if (PDebug.getProcessingOutput()) {
            if (PPaintContext.CURRENT_PAINT_CONTEXT != null) {
                return (float)PPaintContext.CURRENT_PAINT_CONTEXT.getScale();
            }
        } else if (PPickPath.CURRENT_PICK_PATH != null) {
            return (float)PPickPath.CURRENT_PICK_PATH.getScale();
        }
        return 1.0f;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31;
        if (this.stroke != null) {
            result += this.stroke.hashCode();
        }
        return result;
    }

    protected abstract Stroke newStroke(float var1);

    public String toString() {
        return this.stroke.toString();
    }
}

