/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.event;

import java.util.Map;
import java.util.Set;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.api.event.EventDetectionTask;
import org.sikuli.api.event.StateChangeEvent;
import org.sikuli.api.event.StateChangeListener;

class StateChangeEventDetectionTask
implements EventDetectionTask {
    private final ScreenRegion screenRegion;
    private final StateChangeListener listener;
    private Target previousStateTarget = null;

    public StateChangeEventDetectionTask(ScreenRegion screenRegion, StateChangeListener listener) {
        this.screenRegion = screenRegion;
        this.listener = listener;
    }

    @Override
    public void run() {
        Target topStateTarget = null;
        double topScore = 0.0;
        Map<Target, Object> states = this.screenRegion.getStates();
        Set<Target> keySet = states.keySet();
        for (Target target : keySet) {
            ScreenRegion match = this.screenRegion.find(target);
            if (match == null || !(match.getScore() > topScore)) continue;
            topStateTarget = target;
            topScore = match.getScore();
        }
        if (topStateTarget != this.previousStateTarget) {
            Object oldState = this.previousStateTarget == null ? null : states.get(this.previousStateTarget);
            Object newState = topStateTarget == null ? null : states.get(topStateTarget);
            this.listener.stateChanged(new StateChangeEvent(this.screenRegion, oldState, newState));
            this.previousStateTarget = topStateTarget;
        }
    }
}

