/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.event;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.api.event.EventDetectionTask;
import org.sikuli.api.event.StateChangeEventDetectionTask;
import org.sikuli.api.event.StateChangeListener;
import org.sikuli.api.event.TargetEventDetectionTask;
import org.sikuli.api.event.TargetEventListener;

public class VisualEventManager {
    private List<EventDetectionTask> detectionTaskList = new CopyOnWriteArrayList<EventDetectionTask>();
    private static VisualEventManager ref;

    private VisualEventManager() {
        TargetEventDispatherThread t = new TargetEventDispatherThread();
        t.setDaemon(true);
        t.start();
    }

    public static VisualEventManager getSingleton() {
        if (ref == null) {
            ref = new VisualEventManager();
        }
        return ref;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void addTargetEventListener(ScreenRegion screenRegion, Target target, TargetEventListener listener) {
        this.detectionTaskList.add(new TargetEventDetectionTask(screenRegion, target, listener));
    }

    public void removeTargetEventListener(ScreenRegion screenRegion, Target target, TargetEventListener listener) {
        this.detectionTaskList.remove(new TargetEventDetectionTask(screenRegion, target, listener));
    }

    public void addStateChangeEventListener(ScreenRegion screenRegion, StateChangeListener listener) {
        this.detectionTaskList.add(new StateChangeEventDetectionTask(screenRegion, listener));
    }

    class TargetEventDispatherThread
    extends Thread {
        TargetEventDispatherThread() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Iterator iterator = VisualEventManager.this.detectionTaskList.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    EventDetectionTask task = (EventDetectionTask)iterator.next();
                    task.run();
                }
                break;
            }
        }
    }
}

