/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import org.sikuli.core.cv.VisionUtils;

public class ImagePreprocessor {
    public static opencv_core.IplImage createLab(BufferedImage input) {
        opencv_core.IplImage color = opencv_core.IplImage.createFrom(input);
        opencv_core.IplImage rgb = opencv_core.IplImage.create(opencv_core.cvGetSize(color), 8, 3);
        opencv_imgproc.cvCvtColor(color, rgb, 3);
        opencv_core.IplImage lab = opencv_core.IplImage.createCompatible(rgb);
        opencv_imgproc.cvCvtColor(rgb, lab, 45);
        return lab;
    }

    public static opencv_core.IplImage createHSV(BufferedImage input) {
        opencv_core.IplImage color = opencv_core.IplImage.createFrom(input);
        opencv_core.IplImage rgb = opencv_core.IplImage.create(opencv_core.cvGetSize(color), 8, 3);
        opencv_imgproc.cvCvtColor(color, rgb, 3);
        opencv_core.IplImage hsv = opencv_core.IplImage.createCompatible(rgb);
        opencv_imgproc.cvCvtColor(rgb, hsv, 41);
        return hsv;
    }

    public static opencv_core.IplImage createGrayscale(BufferedImage input) {
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(cs, null);
        BufferedImage gray1 = op.filter(input, null);
        return VisionUtils.createGrayImageFrom(opencv_core.IplImage.createFrom(gray1));
    }

    public static opencv_core.IplImage createGrayscale(opencv_core.IplImage input) {
        return VisionUtils.createGrayImageFrom(input);
    }
}

