/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search;

import com.googlecode.javacv.cpp.opencv_core;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import org.sikuli.core.cv.ImagePreprocessor;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;
import org.sikuli.core.search.ColorImageQuery;
import org.sikuli.core.search.ImageQuery;
import org.sikuli.core.search.Query;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.core.search.SearchAlgorithm;
import org.sikuli.core.search.SearchAlgorithmFactory;
import org.sikuli.core.search.Searcher;
import org.sikuli.core.search.algorithm.SearchByTextureAndColorAtOriginalResolution;

public class ImageSearcher
extends Searcher<RegionMatch> {
    private static ImageExplainer logger = ImageExplainer.getExplainer(ImageSearcher.class);
    private final BufferedImage image;

    public ImageSearcher(BufferedImage image) {
        this.image = image;
    }

    private SearchAlgorithm<RegionMatch> getAlgorithmFor(ImageQuery query) {
        return new SearchAlgorithmFactory.SearchByGrayscaleAtOriginalResolution(ImagePreprocessor.createGrayscale(this.getImage()), ImagePreprocessor.createGrayscale(query.getImage()));
    }

    @Override
    protected void explain(final Query query, final List<RegionMatch> os) {
        PiccoloImageRenderer r = new PiccoloImageRenderer(this.getImage()){

            @Override
            protected void addContent(PLayer layer) {
                for (RegionMatch o2 : os) {
                    Rectangle r = o2.getBounds();
                    PPath p = PPath.createRectangle(r.x, r.y, r.width, r.height);
                    p.setStrokePaint(Color.red);
                    p.setStroke(new BasicStroke(3.0f));
                    p.setPaint(null);
                    layer.addChild(p);
                    PText s2 = new PText(String.format("%3f", o2.getScore()));
                    s2.setOffset(r.x, r.y - 15);
                    layer.addChild(s2);
                    if (!(query instanceof ImageQuery)) continue;
                    BufferedImage queryImage = ((ImageQuery)query).getImage();
                    PImage img = new PImage(queryImage);
                    img.setOffset(r.x, r.y + r.height + 2);
                    img.setTransparency(0.5f);
                    layer.addChild(img);
                }
            }
        };
        logger.result(r, (Object)"search result");
    }

    @Override
    protected SearchAlgorithm<RegionMatch> getAlgorithm(Query query) {
        SearchByTextureAndColorAtOriginalResolution alg = null;
        if (query.getClass() == ColorImageQuery.class) {
            ColorImageQuery imageQuery = (ColorImageQuery)query;
            alg = new SearchByTextureAndColorAtOriginalResolution(opencv_core.IplImage.createFrom(this.getImage()), opencv_core.IplImage.createFrom(imageQuery.getImage()));
        } else if (query instanceof ImageQuery) {
            alg = this.getAlgorithmFor((ImageQuery)query);
        }
        return alg;
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

