/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search.index;

import com.google.common.collect.Lists;
import com.googlecode.javacv.cpp.opencv_core;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sikuli.core.cv.ImagePreprocessor;
import org.sikuli.core.cv.VisionUtils;
import org.sikuli.core.search.ScoredItem;
import org.sikuli.core.search.SearchAlgorithm;
import org.sikuli.core.search.index.LabeledImage;
import org.sikuli.core.search.index.LabeledImageMatch;

public class ImageIndex {
    private final List<IndexRecord> records = Lists.newArrayList();
    static NormalizedSimilairty templateMatchSimilarity = new NormalizedSimilairty(){

        @Override
        public double compute(ImageFeature f1, ImageFeature f2) {
            opencv_core.IplImage im1 = f1.rawImage;
            opencv_core.IplImage im2 = f2.rawImage;
            int minW = Math.min(im1.width(), im2.width());
            int minH = Math.min(im1.height(), im2.height());
            opencv_core.CvRect roi1 = opencv_core.cvRect(im1.width() / 2 - minW / 2, im1.height() / 2 - minH / 2, minW, minH);
            opencv_core.cvSetImageROI(im1, roi1);
            double score1 = VisionUtils.computeBestTemplateMatchScore(im2, im1);
            opencv_core.cvResetImageROI(im1);
            opencv_core.CvRect roi2 = opencv_core.cvRect(im2.width() / 2 - minW / 2, im2.height() / 2 - minH / 2, minW, minH);
            opencv_core.cvSetImageROI(im2, roi2);
            double score2 = VisionUtils.computeBestTemplateMatchScore(im1, im2);
            opencv_core.cvResetImageROI(im2);
            return (score1 + score2) / 2.0;
        }
    };
    static NormalizedSimilairty foregroundAreaSimilarity = new NormalizedSimilairty(){

        @Override
        public double compute(ImageFeature f1, ImageFeature f2) {
            return 1.0 - 1.0 * (double)Math.abs(f1.numberOfForegroundPixels - f2.numberOfForegroundPixels) / (double)Math.max(f1.numberOfForegroundPixels, f2.numberOfForegroundPixels);
        }
    };
    static NormalizedSimilairty heightSimilarity = new NormalizedSimilairty(){

        @Override
        public double compute(ImageFeature f1, ImageFeature f2) {
            return 1.0 - 1.0 * (double)Math.abs(f1.foregroundHeight - f2.foregroundHeight) / (double)Math.max(f1.foregroundHeight, f2.foregroundHeight);
        }
    };
    static NormalizedSimilairty widthSimilarity = new NormalizedSimilairty(){

        @Override
        public double compute(ImageFeature f1, ImageFeature f2) {
            return 1.0 - 1.0 * (double)Math.abs(f1.foregroundWidth - f2.foregroundWidth) / (double)Math.max(f1.foregroundWidth, f2.foregroundWidth);
        }
    };
    static NormalizedSimilairty sizeSimilarityComputer = new NormalizedSimilairty(){

        @Override
        public double compute(ImageFeature f1, ImageFeature f2) {
            double s1 = widthSimilarity.compute(f1, f2);
            double s2 = heightSimilarity.compute(f1, f2);
            return (s1 + s2) / 2.0;
        }
    };
    static NormalizedSimilairty totalSimilarity = new NormalizedSimilairty(){

        @Override
        public double compute(ImageFeature f1, ImageFeature f2) {
            double s1 = sizeSimilarityComputer.compute(f1, f2);
            double s2 = foregroundAreaSimilarity.compute(f1, f2);
            double s3 = templateMatchSimilarity.compute(f1, f2);
            return (s1 + s2 + s3) / 3.0;
        }
    };

    void add(LabeledImage labeledImage) {
        BufferedImage image = labeledImage.getImage();
        ImageFeature feature = FeatureComputer.compute(image);
        IndexRecord record = new IndexRecord(labeledImage, feature);
        this.records.add(record);
    }

    public SearchAlgorithm<LabeledImageMatch> getAlgorithm(BufferedImage queryImage) {
        return new ExhausiveLinearScanSearchAlgorithm(queryImage, totalSimilarity);
    }

    class ExhausiveLinearScanSearchAlgorithm
    implements SearchAlgorithm<LabeledImageMatch> {
        private final BufferedImage queryImage;
        private final NormalizedSimilairty normSimilarityComputer;
        private List<ScoredItem<IndexRecord>> scoredRecords = Lists.newArrayList();
        private Iterator<ScoredItem<IndexRecord>> iterator = null;

        public ExhausiveLinearScanSearchAlgorithm(BufferedImage queryImage, NormalizedSimilairty normSimilarityComputer) {
            this.queryImage = queryImage;
            this.normSimilarityComputer = normSimilarityComputer;
        }

        @Override
        public void execute() {
            ImageFeature queryFeature = FeatureComputer.compute(this.queryImage);
            for (IndexRecord record : ImageIndex.this.records) {
                ImageFeature dataFeature = record.getImageFeature();
                double score = this.normSimilarityComputer.compute(queryFeature, dataFeature);
                ScoredItem<IndexRecord> scoredItem = new ScoredItem<IndexRecord>(record, (float)score);
                this.scoredRecords.add(scoredItem);
            }
            Collections.sort(this.scoredRecords, ScoredItem.getComparator());
            this.iterator = this.scoredRecords.iterator();
        }

        @Override
        public LabeledImageMatch fetchNext() {
            if (this.iterator.hasNext()) {
                ScoredItem<IndexRecord> scoredItem = this.iterator.next();
                LabeledImageMatch imageDocumentMatch = new LabeledImageMatch(scoredItem.getItem().getLabeledImage());
                return imageDocumentMatch;
            }
            return null;
        }
    }

    static class ImageFeature {
        int numberOfForegroundPixels;
        int foregroundWidth;
        int foregroundHeight;
        opencv_core.IplImage rawImage;

        ImageFeature() {
        }
    }

    static class IndexRecord {
        private final ImageFeature imageFeature;
        private final LabeledImage labeledImage;

        public IndexRecord(LabeledImage labeledImage, ImageFeature imageFeature) {
            this.labeledImage = labeledImage;
            this.imageFeature = imageFeature;
        }

        public ImageFeature getImageFeature() {
            return this.imageFeature;
        }

        public LabeledImage getLabeledImage() {
            return this.labeledImage;
        }
    }

    static interface NormalizedSimilairty {
        public double compute(ImageFeature var1, ImageFeature var2);
    }

    static class FeatureComputer {
        FeatureComputer() {
        }

        public static ImageFeature compute(BufferedImage image) {
            ImageFeature fs = new ImageFeature();
            fs.rawImage = opencv_core.IplImage.createFrom(image);
            fs.foregroundHeight = image.getHeight();
            fs.foregroundWidth = image.getWidth();
            fs.numberOfForegroundPixels = opencv_core.cvCountNonZero(VisionUtils.computeForegroundMaskOf(ImagePreprocessor.createGrayscale(image)));
            return fs;
        }
    }
}

