/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.RangeExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstContentProviderAdapter;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.providers.UneditableTableCellLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.constants.GlobalMessageConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Shell;

public class RangeInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private static final String TO_EXPRESSION = "To Expression";
    private static final String FROM_EXPRESSION = "From Expression";
    private final InputValueType[] defaultInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.Range);
    private RangeExpressionWrapper rangeExpression;

    public RangeInputBuilderDialog(Shell parentShell, RangeExpressionWrapper rangeExpression) {
        super(parentShell);
        this.rangeExpression = rangeExpression.clone();
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new AstContentProviderAdapter(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == RangeInputBuilderDialog.this.rangeExpression) {
                    return new Object[]{RangeInputBuilderDialog.this.rangeExpression.getFrom(), RangeInputBuilderDialog.this.rangeExpression.getTo()};
                }
                return new Object[0];
            }
        });
        this.tableViewer.setInput((Object)this.rangeExpression);
    }

    @Override
    public RangeExpressionWrapper getReturnValue() {
        return this.rangeExpression;
    }

    @Override
    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_RANGE_INPUT;
    }

    @Override
    protected void addTableColumns() {
        TableViewerColumn tableViewerColumnObject = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnObject.getColumn().setText(GlobalMessageConstants.OBJECT);
        tableViewerColumnObject.getColumn().setWidth(100);
        tableViewerColumnObject.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element == RangeInputBuilderDialog.this.rangeExpression.getFrom()) {
                    return RangeInputBuilderDialog.FROM_EXPRESSION;
                }
                if (element == RangeInputBuilderDialog.this.rangeExpression.getTo()) {
                    return RangeInputBuilderDialog.TO_EXPRESSION;
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValueType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_VALUE_TYPE);
        tableViewerColumnValueType.getColumn().setWidth(100);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider());
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, this.defaultInputValueTypes));
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValue.getColumn().setText(GlobalMessageConstants.VALUE);
        tableViewerColumnValue.getColumn().setWidth(300);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider());
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer));
    }
}

