/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstructorCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.providers.UneditableTableCellLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.constants.GlobalMessageConstants;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class ThrowableInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private static final String MESSAGE = "Message";
    private static final String THROWABLE_TYPE = "Throwable type";
    private ConstructorCallExpressionWrapper constructorCallExpression;

    public ThrowableInputBuilderDialog(Shell parentShell, ConstructorCallExpressionWrapper constructorCallExpression) {
        super(parentShell);
        this.constructorCallExpression = constructorCallExpression.clone();
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<ASTNodeWrapper> expressionList = new ArrayList<ASTNodeWrapper>();
        expressionList.add(this.getExceptionType());
        expressionList.add(this.getVariableName());
        this.tableViewer.setInput(expressionList);
        this.tableViewer.refresh();
    }

    private ClassNodeWrapper getExceptionType() {
        return this.constructorCallExpression.getType();
    }

    private ExpressionWrapper getVariableName() {
        return this.constructorCallExpression.getArguments().getExpressions().get(0);
    }

    @Override
    public ASTNodeWrapper getReturnValue() {
        return this.constructorCallExpression;
    }

    @Override
    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_THROWABLE_CALL_INPUT;
    }

    @Override
    protected void addTableColumns() {
        TableViewerColumn tableViewerColumnObject = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnObject = tableViewerColumnObject.getColumn();
        tblclmnNewColumnObject.setWidth(100);
        tblclmnNewColumnObject.setText(GlobalMessageConstants.OBJECT);
        tableViewerColumnObject.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element == ThrowableInputBuilderDialog.this.getExceptionType()) {
                    return ThrowableInputBuilderDialog.THROWABLE_TYPE;
                }
                if (element == ThrowableInputBuilderDialog.this.getVariableName()) {
                    return ThrowableInputBuilderDialog.MESSAGE;
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnValue = tableViewerColumnValue.getColumn();
        tblclmnNewColumnValue.setText(GlobalMessageConstants.VALUE);
        tblclmnNewColumnValue.setWidth(500);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider());
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer));
    }
}

