/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.editors;

import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.editors.EntitySelectionDialogCellEditor;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import org.eclipse.swt.widgets.Composite;

public class CheckpointSelectionMethodCallBuilderDialog
extends EntitySelectionDialogCellEditor {
    private MethodCallExpressionWrapper methodCall;

    public CheckpointSelectionMethodCallBuilderDialog(Composite parent, String defaultContent) {
        super(parent, defaultContent);
    }

    @Override
    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_CHECKPOINT_BROWSER;
    }

    @Override
    public FolderEntity getRootFolder() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject == null) {
            return null;
        }
        try {
            return FolderController.getInstance().getCheckpointRoot(currentProject);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    @Override
    protected void doSetValue(Object value) {
        CheckpointEntity checkpoint = null;
        if (value instanceof MethodCallExpressionWrapper) {
            this.methodCall = ((MethodCallExpressionWrapper)value).clone();
            String checkpointId = AstEntityInputUtil.findCheckpointIdArgumentFromFindCheckpointMethodCall(this.methodCall);
            if (checkpointId == null) {
                return;
            }
            try {
                checkpoint = CheckpointController.getInstance().getByDisplayedId(checkpointId);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        } else if (value instanceof CheckpointTreeEntity) {
            try {
                checkpoint = ((CheckpointTreeEntity)value).getObject();
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        if (checkpoint == null) {
            return;
        }
        super.doSetValue(checkpoint);
    }

    @Override
    public ITreeEntity getInitialSelection() {
        CheckpointEntity selectedCheckpoint;
        block3: {
            try {
                String checkpointId = AstEntityInputUtil.findCheckpointIdArgumentFromFindCheckpointMethodCall(this.methodCall);
                selectedCheckpoint = CheckpointController.getInstance().getByDisplayedId(checkpointId);
                if (selectedCheckpoint != null) break block3;
                return null;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return null;
            }
        }
        return new CheckpointTreeEntity(selectedCheckpoint, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)selectedCheckpoint.getParentFolder(), (FolderEntity)this.getRootFolder()));
    }

    @Override
    protected MethodCallExpressionWrapper doGetValue() {
        Object value = super.doGetValue();
        if (!(value instanceof CheckpointEntity)) {
            return null;
        }
        AstEntityInputUtil.setCheckpointIdIntoFindCheckpointMethodCall(this.methodCall, ((CheckpointEntity)value).getIdForDisplay());
        return this.methodCall;
    }
}

