/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.editors;

import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.editors.TestDataSelectionDialogCellEditor;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;

public class TestDataSelectionMethodCallBuilderDialogCellEditor
extends TestDataSelectionDialogCellEditor {
    private MethodCallExpressionWrapper methodCall;

    public TestDataSelectionMethodCallBuilderDialogCellEditor(Composite parent, String defaultContent) {
        super(parent, defaultContent);
    }

    @Override
    protected void doSetValue(Object value) {
        DataFileEntity testData = null;
        if (value instanceof MethodCallExpressionWrapper) {
            this.methodCall = ((MethodCallExpressionWrapper)value).clone();
            String testDataId = AstEntityInputUtil.findTestDataIdFromFindTestDataMethodCall(this.methodCall);
            if (testDataId == null) {
                return;
            }
            try {
                testData = TestDataController.getInstance().getTestDataByDisplayId(testDataId);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        } else if (value instanceof TestDataTreeEntity) {
            try {
                testData = ((TestDataTreeEntity)value).getObject();
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        if (testData == null) {
            return;
        }
        super.doSetValue(testData);
    }

    @Override
    public ITreeEntity getInitialSelection() {
        if (!(this.getValue() instanceof MethodCallExpressionWrapper)) {
            return super.getInitialSelection();
        }
        String testDataId = AstEntityInputUtil.findTestDataIdFromFindTestDataMethodCall(this.methodCall);
        if (StringUtils.isEmpty((String)testDataId)) {
            return super.getInitialSelection();
        }
        try {
            DataFileEntity selectedDataFile = TestDataController.getInstance().getTestDataByDisplayId(testDataId);
            return new TestDataTreeEntity(selectedDataFile, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)selectedDataFile.getParentFolder(), (FolderEntity)this.getRootFolder()));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return super.getInitialSelection();
        }
    }

    @Override
    protected MethodCallExpressionWrapper doGetValue() {
        Object value = super.doGetValue();
        if (!(value instanceof DataFileEntity)) {
            return null;
        }
        AstEntityInputUtil.setTestDataIdIntoFindTestDataMethodCall(this.methodCall, ((DataFileEntity)value).getIdForDisplay());
        return this.methodCall;
    }
}

