/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.treetable;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.testcase.ast.editors.KeywordComboBoxCellEditorWithContentProposal;
import com.kms.katalon.composer.testcase.ast.treetable.AstAbstractKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.model.InputParameter;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.preferences.StoredKeyword;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.keyword.KeywordParameter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

public class AstBuiltInKeywordTreeTableNode
extends AstAbstractKeywordTreeTableNode {
    private List<KeywordMethod> builtInKeywordMethods = new ArrayList<KeywordMethod>();

    public AstBuiltInKeywordTreeTableNode(ExpressionStatementWrapper methodCallStatement, AstTreeTableNode parentNode) {
        super(methodCallStatement, parentNode);
        this.builtInKeywordMethods.addAll(this.getKeywords());
    }

    public String getBuiltInKWClassSimpleName() {
        return KeywordController.getInstance().getBuiltInKeywordClassByName(this.methodCall.getObjectExpressionAsString()).getSimpleName();
    }

    public String getBuiltInKWClassAliasName() {
        return KeywordController.getInstance().getBuiltInKeywordClassByName(this.methodCall.getObjectExpressionAsString()).getAliasName();
    }

    private List<KeywordMethod> getKeywords() {
        ArrayList<KeywordMethod> keywords = new ArrayList<KeywordMethod>();
        for (KeywordMethod keywordMethod : this.getBuiltInKeywordMethodsWithoutFlowControl()) {
            keywords.add(keywordMethod);
        }
        return keywords;
    }

    @Override
    public CellEditor getCellEditorForItem(Composite parent) {
        ArrayList<String> keywordNames = new ArrayList<String>();
        ArrayList<String> toolTips = new ArrayList<String>();
        String builtInKWClassSimpleName = this.getBuiltInKWClassSimpleName();
        for (KeywordMethod keywordMethod : this.builtInKeywordMethods) {
            keywordNames.add(TreeEntityUtil.getReadableKeywordName((String)keywordMethod.getName()));
            toolTips.add(TestCaseEntityUtil.getBuiltinKeywordJavadocText(builtInKWClassSimpleName, keywordMethod.getName()));
        }
        return new KeywordComboBoxCellEditorWithContentProposal(parent, this.parentStatement, this.getBuiltInKWClassAliasName(), this.builtInKeywordMethods.toArray(new KeywordMethod[this.builtInKeywordMethods.size()]), keywordNames.toArray(new String[keywordNames.size()]), toolTips.toArray(new String[toolTips.size()]));
    }

    @Override
    public String getItemTooltipText() {
        String keywordJavaDoc = TestCaseEntityUtil.getBuiltinKeywordJavadocText(this.getBuiltInKWClassSimpleName(), this.getKeywordName());
        if (!keywordJavaDoc.isEmpty()) {
            return keywordJavaDoc;
        }
        return super.getItemTooltipText();
    }

    @Override
    public boolean canEditInput() {
        KeywordMethod keywordMethod = this.findKeywordMethod();
        if (keywordMethod == null || keywordMethod.getParameters().length == 0) {
            return false;
        }
        boolean hasTestObjectParam = false;
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            boolean isTestObjectParam = AstEntityInputUtil.isTestObjectClass(keywordMethod.getParameters()[i].getType());
            if (!isTestObjectParam || hasTestObjectParam) {
                return true;
            }
            hasTestObjectParam = true;
            ++i;
        }
        return false;
    }

    @Override
    public String getInputText() {
        ArgumentListExpressionWrapper arguments = this.methodCall.getArguments();
        if (arguments == null || arguments.getExpressions().size() == 0) {
            return "";
        }
        KeywordMethod keywordMethod = this.findKeywordMethod();
        if (keywordMethod == null) {
            return "";
        }
        return this.buildInputDisplayString(arguments, keywordMethod);
    }

    protected String buildInputDisplayString(ArgumentListExpressionWrapper arguments, KeywordMethod keywordMethod) {
        int count = 0;
        StringBuilder displayString = new StringBuilder();
        boolean hasTestObjectParam = false;
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            KeywordParameter keywordParam = keywordMethod.getParameters()[i];
            Class paramType = keywordParam.getType();
            if (AstEntityInputUtil.isTestObjectClass(paramType) && !hasTestObjectParam) {
                hasTestObjectParam = true;
            } else if (!this.isIgnoreParamType(paramType)) {
                ExpressionWrapper inputExpression;
                if (count > 0) {
                    displayString.append("; ");
                }
                if ((inputExpression = arguments.getExpression(i)) == null) {
                    ++count;
                } else {
                    InputValueType typeValue = AstValueUtil.getTypeValue(inputExpression);
                    if (typeValue != null) {
                        displayString.append(typeValue.getValueToDisplay(inputExpression));
                    } else {
                        displayString.append(inputExpression.getText());
                    }
                    ++count;
                }
            }
            ++i;
        }
        return displayString.toString();
    }

    protected boolean isIgnoreParamType(Class<?> paramType) {
        return AstEntityInputUtil.isFailureHandlingClass(paramType);
    }

    @Override
    protected List<InputParameter> getInputParameters() {
        ArgumentListExpressionWrapper argumentList = this.methodCall.getArguments();
        if (argumentList == null) {
            return null;
        }
        return AstKeywordsInputUtil.generateBuiltInKeywordInputParameters(this.getBuiltInKWClassSimpleName(), this.getKeywordName(), argumentList.clone());
    }

    @Override
    public boolean setInputParameters(List<InputParameter> inputParameters) {
        return this.findKeywordMethod() != null && super.setInputParameters(inputParameters);
    }

    @Override
    protected int getObjectArgumentIndex() {
        KeywordMethod keywordMethod = this.findKeywordMethod();
        if (keywordMethod == null) {
            return -1;
        }
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            Class type = keywordMethod.getParameters()[i].getType();
            if (AstEntityInputUtil.isTestObjectClass(type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean canEditOutput() {
        KeywordMethod keywordMethod = this.findKeywordMethod();
        return this.isOutputNotVoid(keywordMethod);
    }

    private boolean isOutputNotVoid(KeywordMethod keywordMethod) {
        return keywordMethod != null && !AstKeywordsInputUtil.isVoidClass(keywordMethod.getReturnType());
    }

    @Override
    protected Class<?> getOutputReturnType() {
        KeywordMethod keywordMethod = this.findKeywordMethod();
        if (this.isOutputNotVoid(keywordMethod)) {
            return keywordMethod.getReturnType();
        }
        return null;
    }

    private List<KeywordMethod> getBuiltInKeywordMethodsWithoutFlowControl() {
        return KeywordController.getInstance().getBuiltInKeywords(this.getBuiltInKWClassSimpleName(), true);
    }

    protected KeywordMethod findKeywordMethod() {
        KeywordMethod keywordMethod = KeywordController.getInstance().getBuiltInKeywordByName(this.getBuiltInKWClassSimpleName(), this.getKeywordName(), this.methodCall.getArguments().getArgumentListParameterTypes());
        return keywordMethod;
    }

    @Override
    public boolean setItem(Object item) {
        try {
            boolean bl = super.setItem(item);
            return bl;
        }
        finally {
            KeywordClass keywordClass = KeywordController.getInstance().getBuiltInKeywordClassByName(this.getBuiltInKWClassAliasName());
            TestCasePreferenceDefaultValueInitializer.addNewRecentKeywords(new StoredKeyword(keywordClass.getName(), this.getKeywordName(), false));
            EventBrokerSingleton.getInstance().getEventBroker().post("TESTCASE/RECENT_KEYWORD_ADDED", null);
        }
    }
}

