/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.treetable;

import com.kms.katalon.composer.testcase.ast.treetable.AstAbstractTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstMethodTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.util.WrapperToAstTreeConverter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class AstScriptTreeTableNode
extends AstAbstractTreeTableNode {
    private ScriptNodeWrapper scriptNode;
    private List<AstTreeTableNode> childNodes = new ArrayList<AstTreeTableNode>();

    public AstScriptTreeTableNode(ScriptNodeWrapper scriptNode, AstTreeTableNode parentNode) {
        super(parentNode);
        this.scriptNode = scriptNode;
        this.reloadChildren();
    }

    @Override
    public boolean canHaveChildren() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return !this.childNodes.isEmpty();
    }

    @Override
    public List<AstTreeTableNode> getChildren() {
        return this.childNodes;
    }

    @Override
    public void reloadChildren() {
        this.childNodes.clear();
        this.childNodes.addAll(WrapperToAstTreeConverter.getInstance().convert(this.scriptNode.getBlock().getStatements(), this));
        for (MethodNodeWrapper method : this.scriptNode.getMethods()) {
            if ("run".equals(method.getName())) continue;
            this.childNodes.add(new AstMethodTreeTableNode(method, this));
        }
    }

    @Override
    public ScriptNodeWrapper getASTObject() {
        return this.scriptNode;
    }

    @Override
    public String getItemText() {
        return "";
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public boolean isChildAssignble(ASTNodeWrapper astNode) {
        return this.scriptNode.getBlock().isChildAssignble(astNode);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject) {
        return this.scriptNode.getBlock().addChild(childObject);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject, int index) {
        return this.scriptNode.getBlock().addChild(childObject, index);
    }

    @Override
    public boolean removeChild(ASTNodeWrapper childObject) {
        return this.scriptNode.getBlock().removeChild(childObject);
    }

    @Override
    public int indexOf(ASTNodeWrapper childObject) {
        return this.scriptNode.getBlock().indexOf(childObject);
    }
}

