/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.variable.operations;

import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.composer.testcase.parts.TestCaseDataBindingPart;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class MoveVariableOperation
extends AbstractOperation {
    private TableActionOperator testCaseVariablePart;
    private TableViewer tableViewer;
    private List<VariableEntity> variableList;
    private int currentIndex;
    private int newIndex;
    private TableViewer variableBindingTableViewer;
    private TestCaseDataBindingPart dataBindingPart;
    private List<VariableLink> variableLinks;

    public MoveVariableOperation(TableActionOperator testCaseVariablePart, int currentIndex, int newIndex) {
        super(MoveVariableOperation.class.getName());
        this.testCaseVariablePart = testCaseVariablePart;
        this.tableViewer = testCaseVariablePart.getTableViewer();
        this.variableList = testCaseVariablePart.getVariablesList();
        this.newIndex = newIndex;
        this.currentIndex = currentIndex;
        if (testCaseVariablePart.getParent() != null) {
            this.dataBindingPart = testCaseVariablePart.getParent().getDataBindingPart();
            this.variableBindingTableViewer = this.dataBindingPart.getVariableBindingTableViewer();
            this.variableLinks = this.dataBindingPart.getVariableLinkList();
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.currentIndex < 0 || this.newIndex < 0) {
            return Status.CANCEL_STATUS;
        }
        return this.redo(monitor, info);
    }

    private void doMoveVariable(int currentIndex, int newIndex) {
        VariableEntity var = this.variableList.get(currentIndex);
        this.variableList.remove(currentIndex);
        this.variableList.add(newIndex, var);
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)var));
        this.tableViewer.refresh();
        if (this.variableLinks != null) {
            VariableLink variableLink = this.variableLinks.get(currentIndex);
            this.variableLinks.remove(currentIndex);
            this.variableLinks.add(newIndex, variableLink);
        }
        this.refreshVariableBindingTable();
        this.testCaseVariablePart.setDirty(true);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.doMoveVariable(this.currentIndex, this.newIndex);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.doMoveVariable(this.newIndex, this.currentIndex);
        return Status.OK_STATUS;
    }

    private void refreshVariableBindingTable() {
        if (this.dataBindingPart != null) {
            this.variableBindingTableViewer.refresh();
            this.variableBindingTableViewer.setInput(this.variableLinks);
        }
    }
}

