/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.editors;

import com.kms.katalon.composer.components.adapter.CComboContentAdapter;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.testcase.components.IContentProposalListener3;
import com.kms.katalon.composer.testcase.components.KeywordContentProposalAdapter;
import com.kms.katalon.composer.testcase.editors.TooltipComboBoxCellEditor;
import com.kms.katalon.composer.testcase.model.ContentProposalCheck;
import com.kms.katalon.custom.keyword.KeywordMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.MethodNode;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBoxCellEditorWithContentProposal
extends TooltipComboBoxCellEditor {
    private ContentProposalCheck contentProposalCheck = new ContentProposalCheck();
    protected Object[] items;
    protected String[] toolTips;
    private KeywordContentProposalAdapter adapter;
    private Map<IContentProposal, Integer> itemAndProposalIndexes;

    public ComboBoxCellEditorWithContentProposal(Composite parent, Object[] items, String[] toolTips) {
        super(parent, items, toolTips);
        this.items = items;
        this.toolTips = toolTips;
        this.itemAndProposalIndexes = new HashMap<IContentProposal, Integer>();
    }

    @Override
    protected void focusLost() {
        if (!this.contentProposalCheck.isProposing()) {
            super.focusLost();
        }
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    public void loseFocus() {
        this.focusLost();
    }

    @Override
    protected Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        if (control instanceof CCombo) {
            final CCombo combo = (CCombo)control;
            IContentProposalProvider proposalProvider = new IContentProposalProvider(){

                public IContentProposal[] getProposals(String inputText, int position) {
                    ArrayList<ContentProposal> bestMatches = new ArrayList<ContentProposal>();
                    ArrayList<ContentProposal> lessMatches = new ArrayList<ContentProposal>();
                    String inputTextLowerCase = StringUtils.defaultString((String)inputText).toLowerCase();
                    ComboBoxCellEditorWithContentProposal.this.itemAndProposalIndexes.clear();
                    int i = 0;
                    while (i < ComboBoxCellEditorWithContentProposal.this.items.length) {
                        boolean isBestMatch;
                        String itemText = ComboBoxCellEditorWithContentProposal.this.getItemText(ComboBoxCellEditorWithContentProposal.this.items[i]);
                        String itemTextLowerCase = itemText.toLowerCase();
                        boolean bl = isBestMatch = StringUtils.isNotBlank((String)inputTextLowerCase) && itemTextLowerCase.startsWith(inputTextLowerCase);
                        if (isBestMatch) {
                            proposal = new ContentProposal(itemText, ComboBoxCellEditorWithContentProposal.this.toolTips[i]);
                            bestMatches.add(proposal);
                            ComboBoxCellEditorWithContentProposal.this.itemAndProposalIndexes.put((IContentProposal)proposal, i);
                        } else {
                            boolean isLessMatch;
                            boolean bl2 = isLessMatch = StringUtils.isBlank((String)inputTextLowerCase) || itemTextLowerCase.contains(inputTextLowerCase);
                            if (isLessMatch) {
                                proposal = new ContentProposal(itemText, ComboBoxCellEditorWithContentProposal.this.toolTips[i]);
                                lessMatches.add(proposal);
                                ComboBoxCellEditorWithContentProposal.this.itemAndProposalIndexes.put((IContentProposal)proposal, i);
                            }
                        }
                        ++i;
                    }
                    ArrayList<ContentProposal> matches = new ArrayList<ContentProposal>();
                    matches.addAll(bestMatches);
                    matches.addAll(lessMatches);
                    return matches.toArray(new IContentProposal[bestMatches.size()]);
                }
            };
            this.adapter = new KeywordContentProposalAdapter((Control)combo, (IControlContentAdapter)new CComboContentAdapter(), proposalProvider, null, null);
            this.adapter.setPropagateKeys(true);
            this.adapter.setProposalAcceptanceStyle(2);
            this.adapter.addContentProposalListener(new IContentProposalListener3(){

                @Override
                public void proposalPopupOpened(KeywordContentProposalAdapter adapter) {
                    ComboBoxCellEditorWithContentProposal.this.contentProposalCheck.setProposing(true);
                }

                @Override
                public void proposalPopupClosed(KeywordContentProposalAdapter adapter) {
                    ComboBoxCellEditorWithContentProposal.this.contentProposalCheck.setProposing(false);
                }
            });
            this.adapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    int selectedIndex = ComboBoxCellEditorWithContentProposal.this.itemAndProposalIndexes.getOrDefault(proposal, -1);
                    if (selectedIndex >= 0) {
                        ComboBoxCellEditorWithContentProposal.this.setValue(selectedIndex);
                    }
                    ComboBoxCellEditorWithContentProposal.this.loseFocus();
                }
            });
            combo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    ComboBoxCellEditorWithContentProposal.this.adapter.setEnabled(!combo.getListVisible());
                }
            });
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    if (!ComboBoxCellEditorWithContentProposal.this.openProposalPopupWhenBlank(combo)) {
                        new Thread(() -> {
                            block8: {
                                try {
                                    try {
                                        UISynchronizeService.syncExec(() -> {
                                            while (combo != null && !combo.isDisposed() && cCombo.getLocation().x == 0 && cCombo.getLocation().y == 0) {
                                                try {
                                                    Thread.sleep(100L);
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    break;
                                                }
                                            }
                                        });
                                    }
                                    catch (Exception exception) {
                                        if (combo != null && !combo.isDisposed()) {
                                            UISynchronizeService.syncExec(() -> ComboBoxCellEditorWithContentProposal.this.openProposalPopupWhenBlank(combo));
                                        }
                                        break block8;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (combo != null && !combo.isDisposed()) {
                                        UISynchronizeService.syncExec(() -> ComboBoxCellEditorWithContentProposal.this.openProposalPopupWhenBlank(combo));
                                    }
                                    throw throwable;
                                }
                                if (combo != null && !combo.isDisposed()) {
                                    UISynchronizeService.syncExec(() -> ComboBoxCellEditorWithContentProposal.this.openProposalPopupWhenBlank(combo));
                                }
                            }
                        }).start();
                    }
                }
            });
        }
        return control;
    }

    private boolean openProposalPopupWhenBlank(CCombo combo) {
        if (StringUtils.isBlank((String)combo.getText()) && this.items != null) {
            Point comboLocation = combo.getLocation();
            if (comboLocation.x != 0 || comboLocation.y != 0) {
                this.adapter.openProposalPopup(false);
                return true;
            }
            return false;
        }
        return true;
    }

    private String getItemText(Object item) {
        if (item instanceof KeywordMethod) {
            return TreeEntityUtil.getReadableKeywordName((String)((KeywordMethod)item).getName());
        }
        if (item instanceof MethodNode) {
            return TreeEntityUtil.getReadableKeywordName((String)((MethodNode)item).getName());
        }
        return item.toString();
    }
}

