/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.editors;

import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.testcase.components.TooltipCCombo;
import com.kms.katalon.custom.keyword.KeywordMethod;
import java.text.MessageFormat;
import org.codehaus.groovy.ast.MethodNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TooltipComboBoxCellEditor
extends CellEditor {
    private Object[] items;
    private String[] toolTips;
    int selection;
    TooltipCCombo comboBox;
    private static final int defaultStyle = 0;

    public TooltipComboBoxCellEditor() {
        this.setStyle(0);
    }

    public TooltipComboBoxCellEditor(Composite parent, Object[] items, String[] toolTips) {
        this(parent, items, toolTips, 0);
    }

    public TooltipComboBoxCellEditor(Composite parent, Object[] items, String[] toolTips, int style) {
        super(parent, style);
        this.setItems(items, toolTips);
    }

    public Object[] getItems() {
        return this.items;
    }

    public void setItems(Object[] items, String[] toolTips) {
        Assert.isNotNull((Object)items);
        Assert.isNotNull((Object)toolTips);
        this.items = items;
        this.toolTips = toolTips;
        this.populateComboBoxItems();
    }

    public String[] getToolTips() {
        return this.toolTips;
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new TooltipCCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.populateComboBoxItems();
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TooltipComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                TooltipComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                TooltipComboBoxCellEditor.this.selection = TooltipComboBoxCellEditor.this.comboBox.getSelectionIndex();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TooltipComboBoxCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        return new Integer(this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.comboBox != null && value instanceof Integer ? 1 : 0) != 0);
        this.selection = (Integer)value;
        this.comboBox.select(this.selection);
    }

    private void populateComboBoxItems() {
        this.comboBox.setData(this.items);
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.items.length) {
                String itemText = this.getItemText(this.items[i]);
                this.comboBox.add(itemText, i, i < this.toolTips.length ? this.toolTips[i] : "");
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            if (this.items.length > 0 && this.selection >= 0 && this.selection < this.items.length) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    private String getItemText(Object item) {
        if (item instanceof KeywordMethod) {
            return TreeEntityUtil.getReadableKeywordName((String)((KeywordMethod)item).getName());
        }
        if (item instanceof MethodNode) {
            return ((MethodNode)item).getName();
        }
        return item.toString();
    }

    public TooltipCCombo getTooltipCCombo() {
        return this.comboBox;
    }
}

