/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.NotExpression;

public class BooleanExpressionWrapper
extends ExpressionWrapper {
    private ExpressionWrapper expression;
    private boolean isReverse = false;

    public BooleanExpressionWrapper(BooleanExpressionWrapper booleanExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(booleanExpressionWrapper, parentNodeWrapper);
        this.copyBooleanProperties(booleanExpressionWrapper);
    }

    public BooleanExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.expression = new ConstantExpressionWrapper(true, (ASTNodeWrapper)this);
        this.isReverse = false;
        this.type = ClassNodeWrapper.getClassWrapper(ClassHelper.boolean_TYPE, this);
    }

    public BooleanExpressionWrapper(BooleanExpression expression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)expression, parentNodeWrapper);
        if (expression instanceof NotExpression) {
            this.isReverse = true;
            this.expression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(((NotExpression)expression).getExpression(), this);
            return;
        }
        this.expression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(expression.getExpression(), this);
    }

    private void copyBooleanProperties(BooleanExpressionWrapper booleanExpressionWrapper) {
        this.expression = booleanExpressionWrapper.getExpression().copy(this);
        this.isReverse = booleanExpressionWrapper.isReverse();
    }

    @Override
    public String getText() {
        if (this.isReverse) {
            return "!(" + this.expression.getText() + ")";
        }
        return this.expression.getText();
    }

    public ExpressionWrapper getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionWrapper expression) {
        if (expression == null) {
            return;
        }
        expression.setParent(this);
        this.expression = expression;
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ExpressionWrapper> astNodeWrappers = new ArrayList<ExpressionWrapper>();
        astNodeWrappers.add(this.expression);
        return astNodeWrappers;
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    public void setReverse(boolean reverse) {
        this.isReverse = reverse;
    }

    @Override
    public BooleanExpressionWrapper clone() {
        return new BooleanExpressionWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof BooleanExpressionWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.copyBooleanProperties((BooleanExpressionWrapper)input);
        return true;
    }

    @Override
    public boolean isChildAssignble(ASTNodeWrapper astNode) {
        return astNode instanceof ExpressionWrapper;
    }

    @Override
    public int indexOf(ASTNodeWrapper childObject) {
        return 0;
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject, int index) {
        if (!this.isChildAssignble(childObject) || childObject.isEqualsTo(this.getExpression())) {
            return false;
        }
        this.setExpression((ExpressionWrapper)childObject);
        return true;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (!this.isChildAssignble(newChild) || oldChild != this.getExpression()) {
            return false;
        }
        this.setExpression((ExpressionWrapper)newChild);
        return true;
    }
}

