/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BreakStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexChildStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.DefaultStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.SwitchStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class CaseStatementWrapper
extends ComplexChildStatementWrapper {
    protected ExpressionWrapper expression;

    public CaseStatementWrapper(CaseStatement caseStatement, SwitchStatementWrapper parentSwitchStatement) {
        super((Statement)caseStatement, CaseStatementWrapper.initCodeBlock(caseStatement), (ASTNodeWrapper)parentSwitchStatement);
        this.lastLineNumber = caseStatement.getCode().getLastLineNumber();
        this.lastColumnNumber = caseStatement.getCode().getColumnNumber();
        this.end = caseStatement.getEnd();
        this.expression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(caseStatement.getExpression(), this);
    }

    public CaseStatementWrapper(CaseStatementWrapper caseStatementWrapper, SwitchStatementWrapper parentSwitchStatement) {
        super(caseStatementWrapper, (ASTNodeWrapper)parentSwitchStatement);
        this.expression = caseStatementWrapper.getExpression().copy(this);
    }

    public CaseStatementWrapper(SwitchStatementWrapper parentSwitchStatement) {
        super(parentSwitchStatement);
        this.expression = new BooleanExpressionWrapper(this);
        this.block.addStatement(new BreakStatementWrapper(this.block));
    }

    public CaseStatementWrapper() {
        this(null);
    }

    private static BlockStatement initCodeBlock(CaseStatement caseStatement) {
        Statement code = caseStatement.getCode();
        if (code instanceof BlockStatement) {
            return (BlockStatement)code;
        }
        BlockStatement block = new BlockStatement();
        block.addStatement(code);
        return block;
    }

    public void setExpression(ExpressionWrapper expression) {
        if (expression == null) {
            return;
        }
        expression.setParent(this);
        this.expression = expression;
    }

    public ExpressionWrapper getExpression() {
        return this.expression;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<? extends ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.expression);
        astNodeWrappers.addAll(super.getAstChildren());
        return astNodeWrappers;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("case ");
        stringBuilder.append(this.getExpression().getText());
        stringBuilder.append(":");
        return stringBuilder.toString();
    }

    @Override
    public SwitchStatementWrapper getParent() {
        return (SwitchStatementWrapper)super.getParent();
    }

    @Override
    public CaseStatementWrapper clone() {
        return new CaseStatementWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public String getInputText() {
        return this.getInput().getText();
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (input instanceof CaseStatementWrapper && !this.getExpression().isEqualsTo(((CaseStatementWrapper)input).getExpression())) {
            this.setExpression(((CaseStatementWrapper)input).getExpression());
            return true;
        }
        return false;
    }

    @Override
    protected boolean isAstNodeBelongToParentComplex(ASTNodeWrapper astNode) {
        return astNode instanceof CaseStatementWrapper || astNode instanceof DefaultStatementWrapper;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (oldChild == this.getExpression() && newChild instanceof ExpressionWrapper) {
            this.setExpression((ExpressionWrapper)newChild);
            return true;
        }
        return super.replaceChild(oldChild, newChild);
    }
}

