/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexChildStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.FinallyStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.TryCatchStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class CatchStatementWrapper
extends ComplexChildStatementWrapper {
    private static final String DEFAULT_VARIABLE_NAME = "e";
    private static final Class<?> DEFAULT_EXCEPTION_TYPE = Exception.class;
    private ParameterWrapper variable;

    public CatchStatementWrapper(TryCatchStatementWrapper parentTryCatchStatement) {
        super(parentTryCatchStatement);
        this.variable = new ParameterWrapper(DEFAULT_EXCEPTION_TYPE, DEFAULT_VARIABLE_NAME, this);
    }

    public CatchStatementWrapper(CatchStatement catchStatement, TryCatchStatementWrapper parentTryCatchStatement) {
        super((Statement)catchStatement, CatchStatementWrapper.initCodeBlock(catchStatement), (ASTNodeWrapper)parentTryCatchStatement);
        this.variable = new ParameterWrapper(catchStatement.getVariable(), (ASTNodeWrapper)this);
    }

    public CatchStatementWrapper(CatchStatementWrapper catchStatementWrapper, TryCatchStatementWrapper parentTryCatchStatement) {
        super(catchStatementWrapper, (ASTNodeWrapper)parentTryCatchStatement);
        this.variable = new ParameterWrapper(catchStatementWrapper.getVariable(), (ASTNodeWrapper)this);
    }

    public CatchStatementWrapper() {
        this(null);
    }

    private static BlockStatement initCodeBlock(CatchStatement catchStatement) {
        Statement code = catchStatement.getCode();
        if (code instanceof BlockStatement) {
            return (BlockStatement)code;
        }
        BlockStatement block = new BlockStatement();
        block.addStatement(code);
        return block;
    }

    public ParameterWrapper getVariable() {
        return this.variable;
    }

    public void setVariable(ParameterWrapper variable) {
        if (variable == null) {
            return;
        }
        variable.setParent(this);
        this.variable = variable;
    }

    @Override
    public String getText() {
        return "catch (" + this.getVariable().getText() + ")";
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public TryCatchStatementWrapper getParent() {
        return (TryCatchStatementWrapper)super.getParent();
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<? extends ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.variable);
        astNodeWrappers.addAll(super.getAstChildren());
        return astNodeWrappers;
    }

    @Override
    public CatchStatementWrapper clone() {
        return new CatchStatementWrapper(this, this.getParent());
    }

    public ClassNodeWrapper getExceptionType() {
        return this.variable.getType();
    }

    public void setExceptionType(ClassNodeWrapper type) {
        if (type == null) {
            return;
        }
        type.setParent(this.variable);
        this.variable.setType(type);
    }

    public String getVariableName() {
        return this.variable.getName();
    }

    public void setVariableName(String name) {
        this.variable.setName(name);
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public String getInputText() {
        return this.variable.getType().getNameWithoutPackage() + " " + this.variable.getName();
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof CatchStatementWrapper) || this.getVariable().isEqualsTo(((CatchStatementWrapper)input).getVariable())) {
            return false;
        }
        this.setVariable(((CatchStatementWrapper)input).getVariable());
        return true;
    }

    @Override
    protected boolean isAstNodeBelongToParentComplex(ASTNodeWrapper astNode) {
        return astNode instanceof CatchStatementWrapper || astNode instanceof FinallyStatementWrapper;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (oldChild == this.getExceptionType() && newChild instanceof ClassNodeWrapper) {
            this.setExceptionType((ClassNodeWrapper)newChild);
            return true;
        }
        if (oldChild == this.getVariable() && newChild instanceof ParameterWrapper) {
            this.setVariable((ParameterWrapper)newChild);
        }
        return false;
    }
}

