/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class ExpressionStatementWrapper
extends StatementWrapper {
    private ExpressionWrapper expression;

    public ExpressionStatementWrapper(ExpressionWrapper expression) {
        this(expression, null);
    }

    public ExpressionStatementWrapper(ExpressionWrapper expression, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.setExpression(expression);
    }

    public ExpressionStatementWrapper(ExpressionStatement statement, ASTNodeWrapper parentNodeWrapper) {
        super((Statement)statement, parentNodeWrapper);
        this.expression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(statement.getExpression(), this);
    }

    public ExpressionStatementWrapper(ExpressionStatementWrapper expressionStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(expressionStatementWrapper, parentNodeWrapper);
        this.expression = expressionStatementWrapper.getExpression().copy(this);
    }

    public ExpressionWrapper getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionWrapper expression) {
        if (expression == null) {
            return;
        }
        expression.setParent(this);
        this.expression = expression;
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public String getText() {
        return this.getExpression().getText();
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ExpressionWrapper> astNodeWrappers = new ArrayList<ExpressionWrapper>();
        astNodeWrappers.add(this.expression);
        return astNodeWrappers;
    }

    @Override
    public ExpressionStatementWrapper clone() {
        return new ExpressionStatementWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public String getInputText() {
        if (this.expression == null) {
            return "";
        }
        return this.expression.getText();
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this.expression;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (input == null || !(input instanceof ExpressionWrapper)) {
            return false;
        }
        if (this.expression.isEqualsTo(input)) {
            return false;
        }
        this.setExpression((ExpressionWrapper)input);
        return true;
    }
}

