/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstructorCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.core.exception.StepFailedException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;

public class ThrowStatementWrapper
extends StatementWrapper {
    public static final Class<?> DEFAULT_THROW_TYPE = StepFailedException.class;
    private ExpressionWrapper expression;

    public ThrowStatementWrapper() {
        this(null);
    }

    public ThrowStatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.expression = new ConstructorCallExpressionWrapper(DEFAULT_THROW_TYPE, (ASTNodeWrapper)this);
    }

    public ThrowStatementWrapper(ExpressionWrapper expression, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.expression = expression;
    }

    public ThrowStatementWrapper(ThrowStatement throwStatement, ASTNodeWrapper parentNodeWrapper) {
        super((Statement)throwStatement, parentNodeWrapper);
        this.expression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(throwStatement.getExpression(), this);
    }

    public ThrowStatementWrapper(ThrowStatementWrapper throwStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(throwStatementWrapper, parentNodeWrapper);
        this.expression = throwStatementWrapper.getExpression().copy(this);
    }

    public ExpressionWrapper getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionWrapper expression) {
        if (expression == null) {
            return;
        }
        expression.setParent(this);
        this.expression = expression;
    }

    @Override
    public String getText() {
        return "throw " + this.getInputText();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ExpressionWrapper> astNodeWrappers = new ArrayList<ExpressionWrapper>();
        astNodeWrappers.add(this.expression);
        return astNodeWrappers;
    }

    @Override
    public ThrowStatementWrapper clone() {
        return new ThrowStatementWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public String getInputText() {
        return this.getExpression().getText();
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (input instanceof ThrowStatementWrapper && !this.getExpression().isEqualsTo(((ThrowStatementWrapper)input).getExpression())) {
            this.setExpression(((ThrowStatementWrapper)input).getExpression());
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (oldChild == this.getExpression() && newChild instanceof ExpressionWrapper) {
            this.setExpression((ExpressionWrapper)newChild);
            return true;
        }
        return super.replaceChild(oldChild, newChild);
    }
}

