/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.folder.handlers.deletion.IDeleteFolderHandler;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.handlers.DeleteTestCaseHandler;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public class DeleteTestCaseFolderHandler
extends DeleteTestCaseHandler
implements IDeleteFolderHandler {
    public FolderEntity.FolderType getFolderType() {
        return FolderEntity.FolderType.TESTCASE;
    }

    public boolean execute(FolderTreeEntity folderTreeEntity, IProgressMonitor monitor) {
        try {
            FolderEntity folder = folderTreeEntity.getObject();
            if (folder == null) {
                return false;
            }
            List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(folder);
            String folderIdForDisplay = folder.getIdForDisplay();
            monitor.beginTask(MessageFormat.format(ComposerTestcaseMessageConstants.HAND_JOB_DELETING_FOLDER, folderIdForDisplay), descendantEntities.size() + 1);
            List affectedTestCaseScripts = TestArtifactScriptRefactor.createForFolderEntity((FolderEntity)folder).findReferrersInTestCaseScripts(ProjectController.getInstance().getCurrentProject());
            ArrayList<TestCaseEntity> undeletedTestCases = new ArrayList<TestCaseEntity>();
            for (Object entity : descendantEntities) {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (entity instanceof TestCaseEntity && !this.deleteTestCase((TestCaseEntity)entity, monitor, affectedTestCaseScripts)) {
                    undeletedTestCases.add((TestCaseEntity)entity);
                    continue;
                }
                if (!(entity instanceof FolderEntity)) continue;
                this.deleteFolder((FolderEntity)entity, undeletedTestCases, monitor);
            }
            this.deleteFolder(folder, undeletedTestCases, monitor);
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)folderTreeEntity.getParent());
            this.eventBroker.post("FOLDER/DELETE_TESTCASE_FOLDER", null);
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.HAND_ERROR_MSG_UNABLE_TO_DEL_TEST_CASE_FOLDER);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private boolean deleteTestCase(TestCaseEntity testCase, IProgressMonitor monitor, List<IFile> affectedTestCaseScripts) {
        try {
            String testCaseId = testCase.getIdForDisplay();
            monitor.subTask(MessageFormat.format(ComposerTestcaseMessageConstants.HAND_JOB_DELETING, testCaseId));
            boolean bl = this.performDeleteTestCase(testCase, TestArtifactScriptRefactor.createForTestCaseEntity((String)testCaseId).findReferrers(affectedTestCaseScripts));
            return bl;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.worked(1);
        }
    }
}

