/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.menu;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ASTHasBlock;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexChildStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.model.ExecuteFromTestStepEntity;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.providers.AstTestScriptGeneratorProvider;
import com.kms.katalon.composer.testcase.util.TestCaseMenuUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.execution.session.ExecutionSession;
import java.util.List;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ExecuteFromTestStepContributionItem
extends ContributionItem
implements SelectionListener {
    public ExecuteFromTestStepContributionItem() {
    }

    public ExecuteFromTestStepContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        if (this.findCompositeParentPart(this.getActiveGroovyEditor()) == null) {
            return;
        }
        TestCaseMenuUtil.generateExecuteFromTestStepMenuItem(menu, this, index);
    }

    private void executeFromTestStep(ExecutionSession executionSession) {
        GroovyEditor groovyEditor = this.getActiveGroovyEditor();
        if (groovyEditor == null) {
            return;
        }
        TestCaseCompositePart testCaseCompositePart = this.findCompositeParentPart(groovyEditor);
        if (testCaseCompositePart == null) {
            return;
        }
        String rawScript = this.generateRawScriptFromSelectedStep(groovyEditor);
        if (rawScript == null) {
            return;
        }
        ExecuteFromTestStepEntity executeFromTestStepEntity = new ExecuteFromTestStepEntity();
        executeFromTestStepEntity.setDriverTypeName(executionSession.getDriverTypeName());
        executeFromTestStepEntity.setRawScript(rawScript);
        executeFromTestStepEntity.setRemoteServerUrl(executionSession.getRemoteUrl());
        executeFromTestStepEntity.setTestCase(testCaseCompositePart.getTestCase());
        executeFromTestStepEntity.setSessionId(executionSession.getSessionId());
        executeFromTestStepEntity.setWebSocketUrl(executionSession.getWebSocketUrl());
        EventBrokerSingleton.getInstance().getEventBroker().post("EXECUTE/FROM_TEST_STEP", (Object)executeFromTestStepEntity);
    }

    protected GroovyEditor getActiveGroovyEditor() {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(activeEditor instanceof GroovyEditor)) {
            return null;
        }
        return (GroovyEditor)activeEditor;
    }

    private String generateRawScriptFromSelectedStep(GroovyEditor groovyEditor) {
        StatementWrapper selectedStatement;
        ScriptNodeWrapper scriptNode;
        block3: {
            TextViewer viewer = (TextViewer)groovyEditor.getViewer();
            ITextSelection textSelection = (ITextSelection)viewer.getSelection();
            String scriptContent = viewer.getDocument().get();
            try {
                scriptNode = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(scriptContent);
                selectedStatement = this.findSelectedStatement(textSelection.getStartLine() + 1, textSelection.getEndLine() + 1, scriptNode);
                if (selectedStatement != null) break block3;
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.ERR_MSG_UNABLE_TO_EXECUTE_FROM_TEST_STEP_STEP_NOT_SELECTED);
                return null;
            }
            catch (GroovyParsingException e) {
                LoggerSingleton.logError((Throwable)e);
                return null;
            }
        }
        return AstTestScriptGeneratorProvider.generateScriptForExecuteFromTestStep(scriptNode, selectedStatement);
    }

    private StatementWrapper findSelectedStatement(int startLine, int endLine, ScriptNodeWrapper scriptNode) {
        MethodNodeWrapper resultMethod = null;
        for (MethodNodeWrapper method : scriptNode.getMethods()) {
            if (!ExecuteFromTestStepContributionItem.isNodeWrapperSelected(startLine, method)) continue;
            resultMethod = method;
        }
        if (resultMethod == null) {
            return null;
        }
        return this.findSelectedStatement(startLine, resultMethod);
    }

    protected StatementWrapper findSelectedStatement(int startLine, ASTHasBlock astBlock) {
        if (astBlock == null) {
            return null;
        }
        StatementWrapper bestFit = null;
        List<StatementWrapper> statements = astBlock.getBlock().getStatements();
        for (StatementWrapper statement : statements) {
            if (statement.getLineNumber() >= startLine && bestFit == null) {
                bestFit = statement;
            }
            if (!ExecuteFromTestStepContributionItem.isNodeWrapperSelected(startLine, statement)) continue;
            if (!this.isChildNodeSelected(startLine, statement)) {
                return statement;
            }
            if (statement instanceof ComplexStatementWrapper) {
                return this.findSelectedElementInComplexStatement(startLine, (ComplexStatementWrapper)statement);
            }
            StatementWrapper childStatement = this.findSelectedStatement(startLine, (ASTHasBlock)((Object)statement));
            if (childStatement != null) {
                return childStatement;
            }
            return statement;
        }
        return bestFit;
    }

    protected StatementWrapper findSelectedElementInComplexStatement(int startLine, ComplexStatementWrapper<?, ?> complexStatement) {
        for (ComplexChildStatementWrapper complexChildStatement : complexStatement.getComplexChildStatements()) {
            StatementWrapper childStatement = this.findSelectedStatement(startLine, complexChildStatement);
            if (childStatement == null) continue;
            return childStatement;
        }
        StatementWrapper childStatement = this.findSelectedStatement(startLine, (ASTHasBlock)complexStatement.getLastStatement());
        if (childStatement != null) {
            return childStatement;
        }
        childStatement = this.findSelectedStatement(startLine, (ASTHasBlock)((Object)complexStatement));
        if (childStatement != null) {
            return childStatement;
        }
        return complexStatement;
    }

    protected boolean isChildNodeSelected(int startLine, StatementWrapper statement) {
        return (statement instanceof ASTHasBlock || statement instanceof ComplexStatementWrapper) && ExecuteFromTestStepContributionItem.isNodeWrapperContainLine(startLine, statement);
    }

    private static boolean isNodeWrapperSelected(int lineNumber, ASTNodeWrapper node) {
        return node.getLineNumber() == lineNumber || ExecuteFromTestStepContributionItem.isNodeWrapperContainLine(lineNumber, node) || node.getLastLineNumber() == lineNumber;
    }

    private static boolean isNodeWrapperContainLine(int lineNumber, ASTNodeWrapper node) {
        return node.getLineNumber() < lineNumber && node.getLastLineNumber() > lineNumber;
    }

    private TestCaseCompositePart findCompositeParentPart(GroovyEditor groovyEditor) {
        if (groovyEditor == null) {
            return null;
        }
        EPartService partService = PartServiceSingleton.getInstance().getPartService();
        for (MPart dirtyPart : partService.getParts()) {
            TestCaseCompositePart compositePart;
            if (!(dirtyPart.getObject() instanceof TestCaseCompositePart) || !groovyEditor.equals((compositePart = (TestCaseCompositePart)dirtyPart.getObject()).getChildGroovyEditor())) continue;
            return compositePart;
        }
        return null;
    }

    public void widgetSelected(SelectionEvent e) {
        Object item = e.getSource();
        if (!(item instanceof MenuItem)) {
            return;
        }
        MenuItem menuItem = (MenuItem)item;
        if (!(menuItem.getData() instanceof ExecutionSession)) {
            return;
        }
        this.executeFromTestStep((ExecutionSession)menuItem.getData());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

