/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForCompositePart;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.explorer.util.TransferTypeCollection;
import com.kms.katalon.composer.testcase.actions.KatalonFormatAction;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseDataBindingPart;
import com.kms.katalon.composer.testcase.parts.TestCaseIntegrationPart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.composer.testcase.parts.TestCasePropertiesPart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariableEditorPart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariablePart;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.composer.testcase.providers.TestObjectScriptDropListener;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.ast.GroovyParser;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.dal.ITestCaseDataProvider;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testcase.events.TestCaseUpdatedEvent;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.ExecutionTimeTracker;
import io.reactivex.rxjava3.subjects.PublishSubject;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestCaseCompositePart
implements EventHandler,
SavableCompositePart,
IComposerPartEvent {
    public static final int CHILD_TEST_CASE_PARTS_NUM = 7;
    public static final int CHILD_TEST_CASE_EDITOR_PART_INDEX = 1;
    public static final String SCRIPT_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_SCRIPT;
    public static final String MANUAL_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_MANUAL;
    public static final String VARIABLE_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_VARIABLE;
    public static final String VARIABLE_EDITOR_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_VARIABLE_EDITOR;
    public static final String INTEGRATION_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_INTEGRATION;
    public static final String PROPERTIES_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_PROPERTIES;
    @Inject
    private MDirtyable dirty;
    private IPropertyListener childPropertyListner;
    private MCompositePart compositePart;
    @Inject
    private EPartService partService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    @Named(value="activeShell")
    private Shell parentShell;
    private TestCasePart childTestCasePart;
    private TestCaseVariablePart childTestCaseVariablesPart;
    private TestCaseVariableEditorPart childTestCaseVariableEditorPart;
    private CompatibilityEditor childTestCaseEditorPart;
    private TestCaseIntegrationPart childTestCaseIntegrationPart;
    private TestCasePropertiesPart propertiesPart;
    private TestCaseDataBindingPart dataBindingPart;
    private GroovyEditor groovyEditor;
    private CTabFolder tabFolder;
    private MPartStack subPartStack;
    private HelpToolBarForCompositePart helpPart;
    private boolean editorLastDirty;
    private boolean isInitialized;
    private boolean isScriptChanged;
    private boolean variableEditorLastDirty = false;
    private TestCaseEntity testCase;
    private TestCaseEntity originalTestCase;
    private List<VariableEntity> originalTestCaseVariableEntities;
    private ScriptNodeWrapper scriptNode;
    private boolean parsingFailed;
    private boolean disposed;
    private boolean invalidScheme;
    private boolean variableTab = true;
    private int index = -1;
    private boolean isRecorderNewTestCase = false;
    private final PublishSubject<DocumentEvent> groovyScriptChangedSubject = PublishSubject.create();
    private boolean tabPropertiesInitialized = false;
    private Map<String, TabItemProperties> tabPropertiesCache = new HashMap<String, TabItemProperties>();

    public MDirtyable getDirty() {
        return this.dirty;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @PostConstruct
    public void init(Composite parent, MCompositePart compositePart) {
        this.compositePart = compositePart;
        this.dirty.setDirty(false);
        this.isInitialized = false;
        this.isScriptChanged = false;
        this.changeOriginalTestCase((TestCaseEntity)compositePart.getObject());
        this.initListeners();
        this.createToolBar((MPart)compositePart);
        this.invalidScheme = false;
        this.groovyScriptChangedSubject.debounce(2L, TimeUnit.SECONDS).subscribe(this::handleDebouncedGroovyScriptChanged);
    }

    private void createToolBar(MPart part) {
        this.helpPart = new HelpToolBarForCompositePart(part, this.partService){

            protected String getDocumentationUrlForPartObject(Object partObject) {
                if (partObject instanceof TestCasePart) {
                    return DocumentationMessageConstants.TEST_CASE_MANUAL;
                }
                if (partObject instanceof TestCaseVariablePart) {
                    return DocumentationMessageConstants.TEST_CASE_VARIABLE;
                }
                if (partObject instanceof TestCaseVariableEditorPart) {
                    return DocumentationMessageConstants.TEST_CASE_VARIABLE_EDITOR;
                }
                if (partObject instanceof TestCaseDataBindingPart) {
                    return DocumentationMessageConstants.TEST_CASE_DATA_BINDING;
                }
                if (partObject instanceof CompatibilityEditor) {
                    return DocumentationMessageConstants.TEST_CASE_SCRIPT;
                }
                if (partObject instanceof TestCaseIntegrationPart) {
                    return ((TestCaseIntegrationPart)partObject).getDocumentationUrl();
                }
                if (partObject instanceof TestCasePropertiesPart) {
                    return DocumentationMessageConstants.TEST_CASE_PROPERTIES;
                }
                return null;
            }
        };
    }

    public void initDefaultSelectedPart() {
        String defaultTestCaseView = TestCasePreferenceDefaultValueInitializer.getTestCasePartStartView();
        if (StringUtils.equals((String)defaultTestCaseView, (String)MANUAL_TAB_TITLE)) {
            MPart manualPart = this.getChildManualPart();
            if (!this.isPartSelected(manualPart)) {
                this.setSelectedPart(manualPart);
            } else if (this.isScriptChanged) {
                this.setScriptContentToManual();
            }
        } else if (StringUtils.equals((String)defaultTestCaseView, (String)SCRIPT_TAB_TITLE)) {
            MPart editorPart = this.getChildCompatibilityPart();
            if (!this.isPartSelected(editorPart)) {
                this.setSelectedPart(editorPart);
            } else if (this.childTestCasePart.isManualScriptChanged()) {
                this.setChildEditorContents(this.scriptNode);
            }
        }
    }

    private boolean isPartSelected(MPart part) {
        return part != null && part.getElementId() != null && part.getElementId().equals(((MStackElement)this.subPartStack.getSelectedElement()).getElementId());
    }

    public void initComponent() {
        List compositePartChildren = this.compositePart.getChildren();
        if (compositePartChildren.size() == 1 && compositePartChildren.get(0) instanceof MPartStack) {
            this.subPartStack = (MPartStack)compositePartChildren.get(0);
            if (this.subPartStack.getChildren().size() == 7) {
                for (MStackElement stackElement : this.subPartStack.getChildren()) {
                    if (!(stackElement instanceof MPart)) continue;
                    Object partObject = ((MPart)stackElement).getObject();
                    if (partObject instanceof TestCasePart) {
                        this.childTestCasePart = (TestCasePart)partObject;
                        continue;
                    }
                    if (partObject instanceof CompatibilityEditor) {
                        this.initChildEditorPart((CompatibilityEditor)partObject);
                        continue;
                    }
                    if (partObject instanceof TestCaseVariablePart) {
                        this.childTestCaseVariablesPart = (TestCaseVariablePart)partObject;
                        continue;
                    }
                    if (partObject instanceof TestCaseVariableEditorPart) {
                        this.childTestCaseVariableEditorPart = (TestCaseVariableEditorPart)((Object)partObject);
                        continue;
                    }
                    if (partObject instanceof TestCaseDataBindingPart) {
                        this.dataBindingPart = (TestCaseDataBindingPart)partObject;
                    }
                    if (partObject instanceof TestCaseIntegrationPart) {
                        this.childTestCaseIntegrationPart = (TestCaseIntegrationPart)partObject;
                        continue;
                    }
                    if (!(partObject instanceof TestCasePropertiesPart)) continue;
                    this.propertiesPart = (TestCasePropertiesPart)((Object)partObject);
                }
            }
            if (this.subPartStack.getWidget() instanceof CTabFolder) {
                this.tabFolder = (CTabFolder)this.subPartStack.getWidget();
                this.tabFolder.setTabPosition(1024);
                this.tabFolder.setBorderVisible(false);
                this.tabFolder.setMaximizeVisible(false);
                this.tabFolder.setMinimizeVisible(false);
                this.initTabPropertiesCache();
                this.setupTabFolder();
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (TestCaseCompositePart.this.tabFolder == null || TestCaseCompositePart.this.childTestCasePart == null) {
                            return;
                        }
                        TestCaseCompositePart.this.index = TestCaseCompositePart.this.tabFolder.getSelectionIndex();
                        CTabItem selectedItem = TestCaseCompositePart.this.tabFolder.getSelection();
                        if (selectedItem == null) {
                            return;
                        }
                        MPart selectedPart = TestCaseCompositePart.this.getPartForTabItem(selectedItem);
                        if (selectedPart == null) {
                            return;
                        }
                        String elementId = selectedPart.getElementId();
                        if (elementId.equals(TestCaseCompositePart.this.getChildManualPart().getElementId())) {
                            if (OSUtil.isMacBigSurOrLater()) {
                                TestCaseCompositePart.this.childTestCasePart.getTestCaseTreeTable().getTree().redraw();
                            }
                            if (TestCaseCompositePart.this.isScriptChanged || TestCaseCompositePart.this.scriptNode == null || !TestCaseCompositePart.this.childTestCasePart.isScriptLoaded()) {
                                TestCaseCompositePart.this.setScriptContentToManual();
                            }
                            Trackings.trackOpenObject((String)"testCaseManual", (Object[])new Object[0]);
                            return;
                        }
                        if (elementId.equals(TestCaseCompositePart.this.getChildCompatibilityPart().getElementId())) {
                            if (TestCaseCompositePart.this.childTestCasePart.isManualScriptChanged()) {
                                TestCaseCompositePart.this.setChildEditorContents(TestCaseCompositePart.this.scriptNode);
                            }
                            Trackings.trackOpenObject((String)"testCaseScript", (Object[])new Object[0]);
                            return;
                        }
                        if (elementId.equals(TestCaseCompositePart.this.getChildVariablesPart().getElementId())) {
                            if (TestCaseCompositePart.this.dirty.isDirty() && TestCaseCompositePart.this.variableEditorLastDirty) {
                                TestCaseCompositePart.this.updateVariableManualView();
                            }
                            TestCaseCompositePart.this.variableEditorLastDirty = false;
                            Trackings.trackOpenObject((String)"testCaseVariable", (Object[])new Object[0]);
                            TestCaseCompositePart.this.variableTab = true;
                            return;
                        }
                        if (elementId.equals(TestCaseCompositePart.this.getChildVariableEditorPart().getElementId())) {
                            if (TestCaseCompositePart.this.dirty.isDirty() && !TestCaseCompositePart.this.variableEditorLastDirty) {
                                TestCaseCompositePart.this.updateVariableScriptView();
                            }
                            TestCaseCompositePart.this.variableEditorLastDirty = true;
                            TestCaseCompositePart.this.variableTab = false;
                            return;
                        }
                        if (elementId.equals(TestCaseCompositePart.this.getChildDataBindingPart().getElementId())) {
                            Trackings.trackOpenObject((String)"testCaseDataBinding", (Object[])new Object[0]);
                        }
                        if (elementId.equals(TestCaseCompositePart.this.getPropertiesPart().getElementId())) {
                            if (TestCaseCompositePart.this.isScriptChanged || TestCaseCompositePart.this.scriptNode == null) {
                                TestCaseCompositePart.this.setScriptContentToManual();
                            }
                            TestCaseCompositePart.this.propertiesPart.loadInput();
                            return;
                        }
                    }
                });
                this.tabFolder.layout();
            }
            this.childTestCaseVariablesPart.loadVariables();
            this.dataBindingPart.loadTestCaseTestData();
            this.dataBindingPart.loadVariableBinding();
            this.updateVariableScriptView();
            this.childTestCaseIntegrationPart.loadInput();
            this.initDefaultSelectedPart();
            if (this.isPartSelected(this.getChildManualPart())) {
                this.setScriptContentToManual();
            } else if (this.scriptNode == null) {
                this.scriptNode = new ScriptNodeWrapper();
            } else {
                this.childTestCasePart.loadASTNodesToTreeTable(this.scriptNode);
            }
            this.propertiesPart.loadInput();
            this.isInitialized = true;
        }
    }

    private MPart getPartForTabItem(CTabItem tabItem) {
        if (tabItem == null || this.subPartStack == null) {
            return null;
        }
        Control itemControl = tabItem.getControl();
        for (MStackElement element : this.subPartStack.getChildren()) {
            MPart part;
            if (!(element instanceof MPart) || (part = (MPart)element).getWidget() != itemControl) continue;
            return part;
        }
        return null;
    }

    private void initTabPropertiesCache() {
        this.tabPropertiesCache.clear();
        this.addTabProperties(this.getChildManualPart(), MANUAL_TAB_TITLE, ImageConstants.IMG_16_MANUAL, false);
        this.addTabProperties(this.getChildCompatibilityPart(), SCRIPT_TAB_TITLE, ImageConstants.IMG_16_SCRIPT, false);
        this.addTabProperties(this.getChildVariablesPart(), VARIABLE_TAB_TITLE, ImageConstants.IMG_16_VARIABLE, false);
        this.addTabProperties(this.getChildVariableEditorPart(), VARIABLE_EDITOR_TAB_TITLE, ImageConstants.IMG_16_SCRIPT, false);
        this.addTabProperties(this.getChildDataBindingPart(), ComposerTestcaseMessageConstants.PA_TAB_DATA_BINDING, ImageConstants.IMG_16_DATA_BINDING, false);
        this.addTabProperties(this.getChildIntegrationPart(), INTEGRATION_TAB_TITLE, ImageConstants.IMG_16_INTEGRATION, false);
        this.addTabProperties(this.getPropertiesPart(), PROPERTIES_TAB_TITLE, ImageConstants.IMG_16_PROPERTIES, false);
    }

    private void addTabProperties(MPart part, String text, Image image, boolean showClose) {
        if (part != null) {
            this.tabPropertiesCache.put(part.getElementId(), new TabItemProperties(text, image, showClose));
        }
    }

    private void setupTabFolder() {
        if (this.tabFolder == null || this.tabFolder.isDisposed() || this.tabPropertiesInitialized) {
            return;
        }
        this.updateAllTabItemProperties();
        this.tabPropertiesInitialized = true;
    }

    private void updateAllTabItemProperties() {
        if (this.tabFolder == null || this.tabFolder.isDisposed() || this.subPartStack == null) {
            return;
        }
        int tabIndex = 0;
        while (tabIndex < this.tabFolder.getItemCount()) {
            String elementId;
            TabItemProperties properties;
            CTabItem tabItem = this.tabFolder.getItem(tabIndex);
            MPart part = this.getPartForTabItem(tabItem);
            if (part != null && (properties = this.tabPropertiesCache.get(elementId = part.getElementId())) != null) {
                tabItem.setText(properties.text);
                tabItem.setImage(properties.image);
                tabItem.setShowClose(properties.showClose);
            }
            ++tabIndex;
        }
    }

    private void updateVariableManualView() {
        try {
            this.childTestCaseVariablesPart.setVariablesFromScriptContent(this.childTestCaseVariableEditorPart.getScriptContent());
            this.setInvalidScheme(false);
        }
        catch (Exception exception) {
            this.setInvalidScheme(true);
        }
    }

    private void updateVariableScriptView() {
        try {
            this.childTestCaseVariableEditorPart.setScriptContentFrom(this.childTestCaseVariablesPart.getVariableEntityWrapper());
            this.setInvalidScheme(false);
        }
        catch (Exception exception) {
            this.setInvalidScheme(true);
        }
    }

    private void initChildEditorPart(CompatibilityEditor compatibilityEditor) {
        this.childTestCaseEditorPart = compatibilityEditor;
        this.groovyEditor = (GroovyEditor)this.childTestCaseEditorPart.getEditor();
        this.addFormatAction();
        GroovyEditorUtil.addImportActions((GroovyEditor)this.groovyEditor);
        this.groovyEditor.getViewer().getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                try {
                    if (!TestCaseCompositePart.this.childTestCasePart.isManualScriptChanged()) {
                        if (!((MStackElement)TestCaseCompositePart.this.subPartStack.getSelectedElement()).equals(TestCaseCompositePart.this.partService.getActivePart())) {
                            TestCaseCompositePart.this.setScriptContentToManual();
                        } else {
                            if (!TestCaseCompositePart.this.isScriptChanged) {
                                TestCaseCompositePart.this.isScriptChanged = true;
                            }
                            TestCaseCompositePart.this.childTestCaseEditorPart.getModel().setDirty(true);
                        }
                        TestCaseCompositePart.this.groovyScriptChangedSubject.onNext((Object)event);
                    }
                    TestCaseCompositePart.this.updateDirty();
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.addTestObjectDropListener();
    }

    private void handleDebouncedGroovyScriptChanged(DocumentEvent event) {
        this.triggerGroovySyntaxCheck();
    }

    private void triggerGroovySyntaxCheck() {
        String taskName = "Check groovy script problem";
        ExecutionTimeTracker.getInstance().start(taskName);
        GroovyEditorUtil.showProblems((GroovyEditor)this.groovyEditor);
        ExecutionTimeTracker.getInstance().stop(taskName);
    }

    private void addFormatAction() {
        if (this.groovyEditor.getAction(ComposerTestcaseMessageConstants.PA_ACTION_FORMAT) instanceof KatalonFormatAction) {
            return;
        }
        KatalonFormatAction formatAction = new KatalonFormatAction((IWorkbenchSite)this.groovyEditor.getSite(), FormatKind.FORMAT);
        formatAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.groovyEditor.setAction(ComposerTestcaseMessageConstants.PA_ACTION_FORMAT, (IAction)formatAction);
    }

    public void changeOriginalTestCase(TestCaseEntity testCase) {
        this.originalTestCase = testCase;
        this.cloneTestCase();
        this.originalTestCaseVariableEntities = this.originalTestCase.getVariables().stream().map(entity -> (VariableEntity)SerializationUtils.clone((Serializable)entity)).toList();
    }

    private void cloneTestCase() {
        this.testCase = new TestCaseEntity();
        TestCaseEntityUtil.copyTestCaseProperties(this.originalTestCase, this.testCase, false);
    }

    public boolean setScriptContentToManual() {
        block6: {
            block5: {
                try {
                    if (this.groovyEditor != null && this.childTestCasePart != null) break block5;
                    return false;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    return false;
                }
            }
            this.parsingFailed = false;
            Shell activeShell = Display.getCurrent().getActiveShell();
            final String scriptContent = this.groovyEditor.getViewer().getDocument().get();
            new ProgressMonitorDialog(activeShell).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(ComposerTestcaseMessageConstants.PARSING_SCRIPT_PROGRESS_NAME, -1);
                    try {
                        TestCaseCompositePart.this.scriptNode = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(scriptContent);
                    }
                    catch (GroovyParsingException groovyParsingException) {
                        TestCaseCompositePart.this.parsingFailed = true;
                    }
                    catch (Exception e) {
                        TestCaseCompositePart.this.parsingFailed = true;
                        LoggerSingleton.logError((Throwable)e);
                    }
                    monitor.done();
                }
            });
            if (!this.parsingFailed) break block6;
            MessageDialog.openError((Shell)activeShell, (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_PLS_FIX_ERROR_IN_SCRIPT);
            this.subPartStack.setSelectedElement((MUIElement)this.childTestCaseEditorPart.getModel());
            this.isScriptChanged = true;
            GroovyEditorUtil.showProblems((GroovyEditor)this.groovyEditor);
            return false;
        }
        if (this.scriptNode == null) {
            this.scriptNode = new ScriptNodeWrapper();
        }
        this.childTestCasePart.loadASTNodesToTreeTable(this.scriptNode);
        this.isScriptChanged = false;
        return true;
    }

    public String getScriptContent() {
        try {
            return this.groovyEditor.getViewer().getDocument().get();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    public List<ASTNode> getAstNodesFromScript() throws Exception {
        if (this.groovyEditor != null && this.groovyEditor.getViewer() != null) {
            return GroovyParser.parseGroovyScriptIntoAstNodes((String)this.groovyEditor.getViewer().getDocument().get());
        }
        return Collections.emptyList();
    }

    private boolean setChildEditorContents(ScriptNodeWrapper scriptNode) {
        Duration timeout;
        Instant startTime = Instant.now();
        if (!this.waitForGroovyEditorViewer(startTime, timeout = Duration.ofSeconds(2L))) {
            return false;
        }
        return this.setEditorContent(scriptNode);
    }

    private boolean waitForGroovyEditorViewer(Instant startTime, Duration timeout) {
        while (this.groovyEditor.getViewer() == null) {
            if (Duration.between(startTime, Instant.now()).compareTo(timeout) > 0) {
                ICompilationUnit scriptFile;
                MPartStack partStack;
                block9: {
                    LoggerSingleton.logInfo((String)"Timeout waiting for groovy editor viewer. Attempting to initialize a new one.");
                    try {
                        partStack = (MPartStack)this.compositePart.getChildren().get(0);
                        scriptFile = GroovyUtil.getOrCreateGroovyScriptForTestCaseFromPlugin((TestCaseEntity)this.testCase);
                        if (scriptFile != null) break block9;
                        LoggerSingleton.logError((String)"Could not find or create script file for test case");
                        return false;
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e, (String)"Failed to initialize new groovy editor");
                        return false;
                    }
                }
                String testCaseEditorId = this.compositePart.getElementId() + ".partStack.editor";
                MPart editorPart = GroovyEditorUtil.createTestCaseEditorPart((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(scriptFile.getPath()), (MPartStack)partStack, (String)testCaseEditorId, (EPartService)this.partService, (int)1);
                this.partService.activate(editorPart);
                this.childTestCaseEditorPart = (CompatibilityEditor)editorPart.getObject();
                this.groovyEditor = (GroovyEditor)this.childTestCaseEditorPart.getEditor();
                if (this.groovyEditor.getViewer() == null) {
                    LoggerSingleton.logError((String)"Failed to initialize groovy editor viewer after timeout");
                    return false;
                }
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LoggerSingleton.logError((Throwable)e, (String)"Thread interrupted while waiting for groovy editor");
                return false;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e, (String)"Unexpected error while waiting for editor");
            }
        }
        return true;
    }

    private boolean setEditorContent(ScriptNodeWrapper scriptNode) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(scriptNode);
            this.groovyEditor.getViewer().getDocument().set(stringBuilder.toString());
            this.childTestCasePart.setManualScriptChanged(false);
            this.childTestCaseEditorPart.getModel().setDirty(true);
            this.updateDirty();
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to set editor content");
            return false;
        }
    }

    private void initListeners() {
        this.eventBroker.subscribe("TESTCASE/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("EDITORS_CLOSED", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
        this.childPropertyListner = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (source instanceof GroovyEditor && propId == 257) {
                    TestCaseCompositePart.this.editorLastDirty = TestCaseCompositePart.this.childTestCaseEditorPart.getModel().isDirty();
                }
            }
        };
    }

    public TestCasePart getChildTestCasePart() {
        return this.childTestCasePart;
    }

    public void loadTreeTableInput() {
        this.setScriptContentToManual();
    }

    public MPart getChildManualPart() {
        return this.childTestCasePart.getMPart();
    }

    public MPart getChildCompatibilityPart() {
        return this.childTestCaseEditorPart.getModel();
    }

    public GroovyEditor getChildGroovyEditor() {
        return (GroovyEditor)this.childTestCaseEditorPart.getEditor();
    }

    public MPart getChildVariablesPart() {
        return this.childTestCaseVariablesPart.getMPart();
    }

    public MPart getChildVariableEditorPart() {
        return this.childTestCaseVariableEditorPart.getMPart();
    }

    public MPart getChildDataBindingPart() {
        return this.dataBindingPart.getMPart();
    }

    public TestCaseDataBindingPart getDataBindingPart() {
        return this.dataBindingPart;
    }

    public MPart getChildIntegrationPart() {
        return this.childTestCaseIntegrationPart.getMPart();
    }

    public MPart getPropertiesPart() {
        return this.propertiesPart.getMPart();
    }

    public TestCaseEntity getTestCase() {
        return this.testCase;
    }

    public TestCaseEntity getOriginalTestCase() {
        return this.originalTestCase;
    }

    private void setInvalidScheme(boolean value) {
        this.invalidScheme = value;
    }

    public void save() throws Exception {
        if (this.variableTab) {
            this.updateVariableScriptView();
        } else {
            this.updateVariableManualView();
        }
        if (this.childTestCasePart.isManualScriptChanged()) {
            this.setChildEditorContents(this.scriptNode);
        }
        this.saveTestScript();
        ITestCaseDataProvider.ReferenceUpdateOption referenceUpdateOption = ITestCaseDataProvider.ReferenceUpdateOption.UPDATE_REFERENCE;
        List<VariableEntity> newTestCaseVariableEntities = this.childTestCaseVariablesPart.getVariablesList();
        if (this.originalTestCaseVariableEntities.equals(newTestCaseVariableEntities)) {
            referenceUpdateOption = ITestCaseDataProvider.ReferenceUpdateOption.KEEP_REFERENCE;
        }
        this.saveTestCase(referenceUpdateOption);
        this.updateDirty();
        if (!this.isRecorderNewTestCase) {
            Trackings.trackEditObject((String)"testCase", (String)"");
        }
        Trackings.trackSaveTestCase((String)"edit_script", (boolean)this.testCase.isAPITestGenerationTestCase());
    }

    public void recorderSave(boolean isNewTestCase) throws Exception {
        this.setRecorderNewTestCase(isNewTestCase);
        this.save();
        if (this.isRecorderNewTestCase && this.groovyEditor != null) {
            GroovyEditorUtil.collapseImportBlock((GroovyEditor)this.groovyEditor);
        }
        this.setRecorderNewTestCase(false);
    }

    public void addVariables(VariableEntity[] variables) {
        this.childTestCaseVariablesPart.addVariable(variables);
    }

    public void deleteVariables(List<VariableEntity> variables) {
        this.childTestCaseVariablesPart.deleteVariables(variables);
    }

    public VariableEntity[] getVariables() {
        return this.childTestCaseVariablesPart.getVariables();
    }

    public List<VariableEntity> getVariablesList() {
        return this.childTestCaseVariablesPart.getVariablesList();
    }

    private boolean validateInput() {
        IStatus status = ResourcesPlugin.getWorkspace().validateName(this.testCase.getName(), 2);
        if (status.isOK()) {
            return this.childTestCaseVariablesPart.validateVariables();
        }
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)status.getMessage());
        return false;
    }

    public boolean saveTestCase() throws Exception {
        return this.saveTestCase(ITestCaseDataProvider.ReferenceUpdateOption.UPDATE_REFERENCE);
    }

    public boolean saveTestCase(ITestCaseDataProvider.ReferenceUpdateOption referenceUpdateOption) throws Exception {
        if (this.validateInput()) {
            List<TestCaseTestDataLink> testDataLinks = this.dataBindingPart.getTestCaseTestDataLinks();
            this.testCase.getTestDataLinks().clear();
            this.testCase.setTestDataLinks(testDataLinks);
            List<VariableLink> variableLinks = this.dataBindingPart.getVariableLinks();
            this.testCase.getVariableLinks().clear();
            this.testCase.setVariableLinks(variableLinks);
            List variableList = this.testCase.getVariables();
            variableList.clear();
            variableList.addAll(this.childTestCaseVariablesPart.getVariablesList());
            this.propertiesPart.preSave();
            this.childTestCaseIntegrationPart.getEditingIntegrated().entrySet().forEach(entry -> this.testCase.updateIntegratedEntity((IntegratedEntity)entry.getValue()));
            String oldPk = this.originalTestCase.getId();
            String oldIdForDisplay = this.originalTestCase.getIdForDisplay();
            TestCaseEntity temp = new TestCaseEntity();
            TestCaseEntityUtil.copyTestCaseProperties(this.originalTestCase, temp, false);
            TestCaseEntityUtil.copyTestCaseProperties(this.testCase, this.originalTestCase, false);
            try {
                boolean nameChanged;
                boolean bl = nameChanged = !this.originalTestCase.getName().equals(temp.getName());
                if (nameChanged) {
                    GroovyUtil.loadScriptContentIntoTestCase((TestCaseEntity)temp);
                    this.originalTestCase.setScriptContents(temp.getScriptContents());
                    temp.setScriptContents(this.originalTestCase.getScriptContents());
                }
                TestCaseController.getInstance().updateTestCase(this.originalTestCase, referenceUpdateOption);
                if (nameChanged) {
                    this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, this.originalTestCase.getIdForDisplay()});
                }
                TestCaseTreeEntity testCaseTreeEntity = TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)this.originalTestCase, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testCaseTreeEntity);
                this.eventBroker.post("TESTCASE/UPDATED", (Object)new TestCaseUpdatedEvent(oldPk, (FileEntity)this.originalTestCase));
                EventUtil.send((String)"PROPERTIES/ENTITY", null);
                EventUtil.send((String)"PROPERTIES/ENTITY", (Object)this.originalTestCase);
                this.originalTestCase.setScriptContents(new byte[0]);
                temp.setScriptContents(new byte[0]);
                this.childTestCaseIntegrationPart.onSaveSuccess(this.originalTestCase);
                return true;
            }
            catch (Exception e) {
                TestCaseEntityUtil.copyTestCaseProperties(temp, this.originalTestCase);
                this.originalTestCase.setScriptContents(temp.getScriptContents());
                LoggerSingleton.logError((Throwable)e);
                this.childTestCaseIntegrationPart.onSaveFailure(e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.WARN, (String)e.getMessage());
            }
        }
        return false;
    }

    public boolean saveTestScript() {
        try {
            this.triggerGroovySyntaxCheck();
            GroovyUtil.refreshScriptFolder((TestCaseEntity)this.testCase);
            this.groovyEditor.doSave(null);
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.parentShell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
            return false;
        }
    }

    public void setDirty(boolean isDirty) {
        this.dirty.setDirty(isDirty);
    }

    public void updateDirty() {
        this.updateDirty(this.isAnyChildDirty());
    }

    private void updateDirty(boolean isDirty) {
        this.dirty.setDirty(isDirty);
        this.childTestCasePart.getMPart().setDirty(false);
        this.childTestCaseVariablesPart.getMPart().setDirty(false);
        this.childTestCaseVariableEditorPart.getMPart().setDirty(false);
        this.dataBindingPart.getMPart().setDirty(false);
        this.childTestCaseEditorPart.getModel().setDirty(false);
        this.childTestCaseIntegrationPart.getMPart().setDirty(false);
        this.getPropertiesPart().setDirty(false);
        if (isDirty) {
            this.updateTabTitles();
        }
    }

    private void updateTabTitles() {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        this.updateAllTabItemProperties();
    }

    private boolean isAnyChildDirty() {
        return this.childTestCasePart.getMPart().isDirty() || this.childTestCaseEditorPart.getModel().isDirty() || this.childTestCaseVariablesPart.getMPart().isDirty() || this.childTestCaseVariableEditorPart.getMPart().isDirty() || this.dataBindingPart.getMPart().isDirty() || this.childTestCaseIntegrationPart.getMPart().isDirty() || this.propertiesPart.isDirty();
    }

    @Persist
    public void onSave() {
        try {
            this.save();
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_PART);
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public IPropertyListener getChildPropertyListner() {
        return this.childPropertyListner;
    }

    public void handleEvent(Event event) {
        block11: {
            if (event.getTopic().equals("TESTCASE/UPDATED")) {
                try {
                    TestCaseUpdatedEvent eventData;
                    String elementId;
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (object == null || !(object instanceof TestCaseUpdatedEvent) || !(elementId = EntityPartUtil.getTestCaseCompositePartId((String)(eventData = (TestCaseUpdatedEvent)object).getOriginalPk())).equalsIgnoreCase(this.compositePart.getElementId())) break block11;
                    TestCaseEntity testCase = (TestCaseEntity)eventData.getTestCaseEntity();
                    this.changeOriginalTestCase(testCase);
                    this.updatePart(testCase);
                    if (this.index != -1) {
                        this.tabFolder.setSelection(this.index);
                        break block11;
                    }
                    this.initDefaultSelectedPart();
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            } else if (event.getTopic().equals("EXPLORER/REFRESH_SELECTED_ITEM")) {
                try {
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (object instanceof TestCaseTreeEntity) {
                        this.handleTestCaseRefreshed(((TestCaseTreeEntity)object).getObject());
                    } else if (object instanceof FolderTreeEntity) {
                        this.handleFolderRefreshed(((FolderTreeEntity)object).getObject());
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        }
    }

    private void handleTestCaseRefreshed(TestCaseEntity testCase) throws Exception {
        TestCaseEntity currentTestCase = this.getTestCase();
        if (testCase == null || !testCase.getId().equals(currentTestCase.getId())) {
            return;
        }
        if (this.isTestCaseDisposed(testCase)) {
            this.dispose();
            return;
        }
        this.refresh(testCase);
    }

    private void refresh(TestCaseEntity testCase) throws Exception {
        if (this.dirty.isDirty()) {
            return;
        }
        this.changeOriginalTestCase(testCase);
        TestCaseTreeTableInput treeTableInput = this.childTestCasePart.getTreeTableInput();
        if (treeTableInput != null) {
            treeTableInput.reloadTestCaseVariables(this.childTestCasePart.getVariables());
        }
        this.updatePart(testCase);
        this.childTestCaseIntegrationPart.loadInput();
        this.propertiesPart.loadInput();
        this.updateDirty(false);
        this.clearChildsUndoRedoHistory();
    }

    private void clearChildsUndoRedoHistory() {
        this.childTestCasePart.clearHistory();
        this.childTestCaseVariablesPart.clearHistory();
        this.propertiesPart.clearHistory();
    }

    private boolean isTestCaseDisposed(TestCaseEntity testCase) throws Exception {
        return TestCaseController.getInstance().getTestCase(testCase.getId()) == null;
    }

    private void handleFolderRefreshed(FolderEntity folder) throws Exception {
        TestCaseEntity currentTestCase = this.getTestCase();
        if (folder != null && FolderController.getInstance().isFolderAncestorOfEntity(folder, (IEntity)currentTestCase) && this.isTestCaseDisposed(currentTestCase)) {
            this.dispose();
        }
    }

    private void dispose() {
        MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        mStackPart.getChildren().remove(this.compositePart);
        this.eventBroker.unsubscribe((EventHandler)this);
        this.groovyScriptChangedSubject.onComplete();
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @PreDestroy
    public void preDestroy() {
        try {
            if (this.groovyEditor != null && this.getChildCompatibilityPart() != null) {
                GroovyEditorUtil.clearEditorProblems((GroovyEditor)this.groovyEditor);
            }
            this.helpPart.dispose();
            this.dispose();
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void updatePart(TestCaseEntity testCase) throws Exception {
        String newCompositePartId = EntityPartUtil.getTestCaseCompositePartId((String)testCase.getId());
        this.changeOriginalTestCase(testCase);
        if (!newCompositePartId.equals(this.compositePart.getElementId())) {
            this.compositePart.setLabel(testCase.getName());
            this.compositePart.setElementId(newCompositePartId);
            if (this.compositePart.getChildren().size() == 1 && this.compositePart.getChildren().get(0) instanceof MPartStack) {
                MPartStack partStack = (MPartStack)this.compositePart.getChildren().get(0);
                partStack.setElementId(newCompositePartId + ".partStack");
                this.childTestCasePart.getMPart().setElementId(newCompositePartId + ".partStack.testCasePart");
                this.childTestCaseVariablesPart.getMPart().setElementId(newCompositePartId + ".partStack.variables");
                this.getPropertiesPart().setElementId(newCompositePartId + ".partStack.properties");
                this.childTestCaseVariableEditorPart.getMPart().setElementId(newCompositePartId + ".partStack.variableEditor");
                this.partService.hidePart(this.getChildCompatibilityPart(), true);
                String testCaseEditorId = newCompositePartId + ".partStack.editor";
                MPart editorPart = GroovyEditorUtil.createTestCaseEditorPart((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(GroovyUtil.getOrCreateGroovyScriptForTestCaseFromPlugin((TestCaseEntity)testCase).getPath()), (MPartStack)partStack, (String)testCaseEditorId, (EPartService)this.partService, (int)1);
                this.partService.activate(editorPart);
                this.initComponent();
                this.childTestCaseEditorPart.getEditor().addPropertyListener(this.getChildPropertyListner());
                this.updateDirty();
            }
        }
        boolean isAnyChildDirty = this.isAnyChildDirty();
        this.childTestCaseVariablesPart.loadVariables();
        this.childTestCaseVariableEditorPart.setScriptContentFrom(this.childTestCaseVariablesPart.getVariableEntityWrapper());
        if (this.childTestCasePart.getTreeTableInput() == null) {
            this.setScriptContentToManual();
        }
        this.childTestCasePart.getTreeTableInput().reloadTestCaseVariables(this.childTestCasePart.getVariables());
        this.childTestCaseIntegrationPart.reloadInput();
        this.dataBindingPart.loadTestCaseTestData();
        this.dataBindingPart.loadVariableBinding();
        this.updateDirty();
        this.setDirty(isAnyChildDirty);
        if (!isAnyChildDirty) {
            this.updateTabTitles();
        }
    }

    public MPart getSelectedPart() {
        return (MPart)this.subPartStack.getSelectedElement();
    }

    public void setSelectedPart(MPart partToSelect) {
        if (this.subPartStack.getChildren().contains(partToSelect)) {
            this.subPartStack.setSelectedElement((MUIElement)partToSelect);
            if (partToSelect == this.getChildManualPart() && (this.isScriptChanged || this.scriptNode == null)) {
                this.setScriptContentToManual();
            } else if (partToSelect == this.getChildCompatibilityPart() && this.childTestCasePart.isManualScriptChanged()) {
                this.setChildEditorContents(this.scriptNode);
            }
        }
    }

    public void refreshScript() {
        if (!this.isInitialized) {
            return;
        }
        if (this.subPartStack.getSelectedElement() == this.getChildCompatibilityPart()) {
            this.setChildEditorContents(this.scriptNode);
        }
    }

    public List<MPart> getChildParts() {
        ArrayList<MPart> childrenParts = new ArrayList<MPart>();
        childrenParts.add(this.getChildManualPart());
        childrenParts.add(this.getChildCompatibilityPart());
        childrenParts.add(this.getChildVariablesPart());
        childrenParts.add(this.getChildVariableEditorPart());
        childrenParts.add(this.getChildDataBindingPart());
        childrenParts.add(this.getChildIntegrationPart());
        childrenParts.add(this.getPropertiesPart());
        return childrenParts;
    }

    public boolean isTestCaseEmpty() {
        if (this.groovyEditor.getViewer() == null) {
            return true;
        }
        return GroovyWrapperParser.parseGroovyScriptAndGetFirstStatement(this.groovyEditor.getViewer().getDocument().get()) == null;
    }

    public void validateScriptErrors() throws Exception {
        try {
            if (this.groovyEditor != null && this.groovyEditor.getViewer() != null) {
                GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(this.groovyEditor.getViewer().getDocument().get());
            }
        }
        catch (Exception e) {
            GroovyEditorUtil.showProblems((GroovyEditor)this.groovyEditor);
            throw e;
        }
    }

    private void addTestObjectDropListener() {
        Control control = (Control)this.groovyEditor.getAdapter(Control.class);
        if (!(control instanceof StyledText)) {
            return;
        }
        DropTarget dropTarget = null;
        Object existingDropTarget = control.getData("DropTarget");
        dropTarget = existingDropTarget != null ? (DropTarget)existingDropTarget : new DropTarget(control, 1);
        Transfer[] transfers = dropTarget.getTransfer();
        List treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        if (transfers.length != 0) {
            treeEntityTransfers.addAll(Arrays.asList(transfers));
        }
        dropTarget.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
        dropTarget.addDropListener((DropTargetListener)new TestObjectScriptDropListener(this.groovyEditor.getViewer().getTextWidget()));
    }

    public MCompositePart getCompositePart() {
        return this.compositePart;
    }

    public String getEntityId() {
        return this.getTestCase().getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (this.originalTestCase == null) {
            return;
        }
        MPart part = EventUtil.getPart((Event)event);
        if (part == null || !StringUtils.startsWith((String)part.getElementId(), (String)EntityPartUtil.getTestCaseCompositePartId((String)this.originalTestCase.getId()))) {
            return;
        }
        EventUtil.post((String)"PROPERTIES/ENTITY", (Object)this.originalTestCase);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
        Object eventData = EventUtil.getData((Event)event);
        if (!(eventData instanceof TestCaseEntity)) {
            return;
        }
        TestCaseEntity updatedEntity = (TestCaseEntity)eventData;
        if (!StringUtils.equals((String)updatedEntity.getIdForDisplay(), (String)this.getEntityId())) {
            return;
        }
        String newTag = updatedEntity.getTag();
        String newDescription = updatedEntity.getDescription();
        String newComment = updatedEntity.getComment();
        this.testCase.setTag(newTag);
        this.testCase.setDescription(newDescription);
        this.testCase.setComment(newComment);
        this.propertiesPart.loadInput();
    }

    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
    }

    public void setInvalidSchemeDetected(boolean b) {
        this.invalidScheme = b;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public boolean isDirty() {
        return this.compositePart.isDirty();
    }

    public void changeScriptNode(ScriptNodeWrapper scriptNode) {
        this.scriptNode = scriptNode;
    }

    public void openAddedTestData(DataFileEntity dataFileEntity) {
        this.eventBroker.post("TESTDATA/OPEN", (Object)dataFileEntity);
    }

    public void setVariablesAndDataBindingTab() {
        this.setSelectedPart(this.getChildDataBindingPart());
    }

    public void refreshTestCaseAfterTestDataChanged(String oldTestDataId, String newTestDataId) {
        this.dataBindingPart.refreshTestCaseAfterTestDataChanged(oldTestDataId, newTestDataId);
    }

    public void setRecorderNewTestCase(boolean isRecorderNewTestCase) {
        this.isRecorderNewTestCase = isRecorderNewTestCase;
    }

    private static class TabItemProperties {
        String text;
        Image image;
        boolean showClose;

        public TabItemProperties(String text, Image image, boolean showClose) {
            this.text = text;
            this.image = image;
            this.showClose = showClose;
        }
    }
}

