/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.preferences;

import com.kms.katalon.entity.repository.WebElementEntity;
import java.util.LinkedList;
import java.util.List;

public class RecentObjectStorage {
    private static final int MAX_SIZE = 5;
    private List<String> recentObjectIds;
    private List<String> recentFolderIds;

    public List<String> getRecentObjectIds() {
        if (this.recentObjectIds == null) {
            this.recentObjectIds = new LinkedList<String>();
        }
        return this.recentObjectIds;
    }

    public List<String> getRecentFolderIds() {
        if (this.recentFolderIds == null) {
            this.recentFolderIds = new LinkedList<String>();
        }
        return this.recentFolderIds;
    }

    public void addRecentTestObject(WebElementEntity testObject) {
        this.addFirst(this.getRecentObjectIds(), testObject.getIdForDisplay(), 5);
        if (this.isNotUnderRoot(testObject)) {
            this.addFirst(this.getRecentFolderIds(), testObject.getParentFolder().getIdForDisplay(), 5);
        }
    }

    private void addFirst(List<String> list, String s, int maxSize) {
        if (list.contains(s)) {
            list.remove(s);
        }
        list.add(0, s);
        list = this.getNewSize(list, maxSize);
    }

    private List<String> getNewSize(List<String> list, int maxSize) {
        while (list.size() > maxSize) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    private boolean isNotUnderRoot(WebElementEntity testObject) {
        return testObject.getParentFolder().getParentFolder() != null;
    }

    public boolean isEmpty() {
        return this.getRecentObjectIds().isEmpty() && this.getRecentFolderIds().isEmpty();
    }
}

