/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.providers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.parts.TestCasePartDataBindingView;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;

public class TestDataTableLabelProvider
extends StyledCellLabelProvider {
    public static final int COLUMN_NOTIFICATION_INDEX = 0;
    public static final int COLUMN_ORDER_INDEX = 1;
    public static final int COLUMN_ID_INDEX = 2;
    public static final int COLUMN_ITERATION_INDEX = 3;
    private static TestDataController testDataControler = TestDataController.getInstance();
    private TestCasePartDataBindingView testCaseDataBindingView;
    private int columnIndex;

    public TestDataTableLabelProvider(int columnIndex, TestCasePartDataBindingView testCaseDataBindingView) {
        this.columnIndex = columnIndex;
        this.testCaseDataBindingView = testCaseDataBindingView;
    }

    protected void paint(Event event, Object element) {
        if (element == null || !(element instanceof TestCaseTestDataLink)) {
            return;
        }
        GC gc = event.gc;
        if (this.columnIndex == 0) {
            Image columnImage = this.getColumnImage(element);
            if (columnImage != null) {
                gc.drawImage(ImageConstants.IMG_16_NOTIFICATION_HEADER, event.getBounds().x + 2, event.getBounds().y);
            }
        } else {
            super.paint(event, element);
        }
    }

    public Image getColumnImage(Object element) {
        if (element == null || !(element instanceof TestCaseTestDataLink)) {
            return null;
        }
        TestCaseTestDataLink link = (TestCaseTestDataLink)element;
        if (this.columnIndex == 0) {
            String testDataId = link.getTestDataId();
            try {
                if (testDataId == null || testDataControler.getTestDataByDisplayId(testDataId) == null) {
                    return ImageConstants.IMG_16_NOTIFICATION_HEADER;
                }
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }
        return null;
    }

    public String getColumnText(Object element) {
        if (element == null || !(element instanceof TestCaseTestDataLink)) {
            return "";
        }
        TestCaseTestDataLink link = (TestCaseTestDataLink)element;
        switch (this.columnIndex) {
            case 1: {
                int order = this.testCaseDataBindingView.getTestCaseTestDataLinks().indexOf(link) + 1;
                return Integer.toString(order);
            }
            case 2: {
                return link.getTestDataId();
            }
            case 3: {
                return link.getIterationEntity().getDisplayString();
            }
        }
        return "";
    }

    public void update(ViewerCell cell) {
        cell.setText(this.getColumnText(cell.getElement()));
        cell.setImage(null);
        TestCaseTestDataLink link = (TestCaseTestDataLink)cell.getElement();
        String testDataId = link.getTestDataId();
        try {
            if (testDataId == null || testDataControler.getTestDataByDisplayId(testDataId) == null) {
                if (this.columnIndex == 0) {
                    cell.setForeground(ColorUtil.getDefaultTextColor());
                } else if (this.columnIndex == 2) {
                    cell.setForeground(ColorUtil.getErrorTableItemForegroundColor());
                }
            } else {
                cell.setForeground(ColorUtil.getDefaultTextColor());
            }
        }
        catch (Exception exception) {}
        super.update(cell);
    }

    public String getToolTipText(Object element) {
        if (element == null || !(element instanceof TestCaseTestDataLink)) {
            return null;
        }
        TestCaseTestDataLink link = (TestCaseTestDataLink)element;
        if (this.columnIndex == 0) {
            String testDataId = link.getTestDataId();
            try {
                if (testDataId == null || testDataControler.getTestDataByDisplayId(testDataId) == null) {
                    return MessageFormat.format(ComposerTestcaseMessageConstants.LP_WARN_MSG_TEST_DATA_MISSING, testDataId);
                }
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        } else {
            return this.getColumnText(element);
        }
        return null;
    }
}

