/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.support;

import com.kms.katalon.composer.components.operation.OperationExecutor;
import com.kms.katalon.composer.testcase.ast.treetable.IAstOutputEditableNode;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class OutputColumnEditingSupport
extends EditingSupport {
    private TreeViewer treeViewer;
    private ITestCasePart parentTestCasePart;

    public OutputColumnEditingSupport(TreeViewer treeViewer, ITestCasePart parentTestCasePart) {
        super((ColumnViewer)treeViewer);
        this.treeViewer = treeViewer;
        this.parentTestCasePart = parentTestCasePart;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof IAstOutputEditableNode) {
            return ((IAstOutputEditableNode)element).getCellEditorForOutput((Composite)this.treeViewer.getTree());
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return element instanceof IAstOutputEditableNode && ((IAstOutputEditableNode)element).canEditOutput();
    }

    protected Object getValue(Object element) {
        if (element instanceof IAstOutputEditableNode) {
            return ((IAstOutputEditableNode)element).getOutput();
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof IAstOutputEditableNode) {
            new OperationExecutor((Object)this.parentTestCasePart).executeOperation((IUndoableOperation)new NodeOutputValueChangeOperation((IAstOutputEditableNode)element, value));
        }
    }

    private class NodeOutputValueChangeOperation
    extends AbstractOperation {
        private IAstOutputEditableNode node;
        private Object value;
        private Object oldValue;

        public NodeOutputValueChangeOperation(IAstOutputEditableNode node, Object value) {
            super(NodeOutputValueChangeOperation.class.getName());
            this.node = node;
            this.value = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldValue = this.node.getOutput();
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetOutputValue(this.value);
        }

        protected IStatus doSetOutputValue(Object outputValue) {
            if (!this.node.setOutput(outputValue)) {
                return Status.CANCEL_STATUS;
            }
            OutputColumnEditingSupport.this.parentTestCasePart.getTreeTableInput().setDirty(true);
            OutputColumnEditingSupport.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.node));
            OutputColumnEditingSupport.this.treeViewer.refresh((Object)this.node);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetOutputValue(this.oldValue);
        }
    }
}

